/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CestaDePromocao;
import com.escolpi.omni.api.model.entity.ItemDoPedido;
import com.escolpi.omni.api.model.entity.ItemDoPedidoPorPromocao;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.model.entity.ValorDaPersonalizacao;
import com.escolpi.omni.api.repository.ProdutoRepository;
import com.escolpi.omni.api.repository.ValorDaPersonalizacaoRepository;
import com.escolpi.omni.api.util.NullUtil;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ControleDeEstoqueService {
    @Autowired
    private ValorDaPersonalizacaoRepository customizationValueRepository;
    @Autowired
    private ProdutoRepository produtoRepository;

    @Transactional
    public void subtractCustomizationValueFromStock(Set<ValorDaPersonalizacao> customizationValues, Double quantity) {
        for (ValorDaPersonalizacao value : customizationValues) {
            if (value.getEstoqueIlimitado().booleanValue()) continue;
            ValorDaPersonalizacao edit = (ValorDaPersonalizacao)this.customizationValueRepository.findById((Object)value.getId()).get();
            edit.setEstoque(new Double(edit.getEstoque() - quantity));
            if (edit.getEstoque() == -1.0 || edit.getEstoque() == 0.0) {
                edit.setEmFalta(Boolean.valueOf(true));
            }
            this.customizationValueRepository.save((Object)edit);
        }
    }

    @Transactional
    public void subtractProductFromStock(Produto product, Double quantity) {
        if (!product.getEstoqueIlimitado().booleanValue()) {
            Produto edit = (Produto)this.produtoRepository.findById((Object)product.getId()).get();
            edit.setEstoque(edit.getEstoque().subtract(new BigDecimal(quantity)));
            if (edit.getEstoque().compareTo(BigDecimal.ZERO) == -1 || edit.getEstoque().compareTo(BigDecimal.ZERO) == 0) {
                edit.setEmFalta(Boolean.valueOf(true));
            }
            this.produtoRepository.save((Object)edit);
        }
    }

    @Transactional
    public void sumCustomizationValueFromStock(Set<ValorDaPersonalizacao> customizationValues, Double quantity) {
        for (ValorDaPersonalizacao value : customizationValues) {
            if (value.getEstoqueIlimitado().booleanValue()) continue;
            ValorDaPersonalizacao edit = (ValorDaPersonalizacao)this.customizationValueRepository.findById((Object)value.getId()).get();
            edit.setEstoque(new Double(edit.getEstoque() + quantity));
            if (edit.getEstoque() >= 1.0) {
                edit.setEmFalta(Boolean.valueOf(false));
            }
            this.customizationValueRepository.save((Object)edit);
        }
    }

    @Transactional
    public void sumProductToStock(Produto product, Double quantity) {
        if (!product.getEstoqueIlimitado().booleanValue()) {
            Produto edit = (Produto)this.produtoRepository.findById((Object)product.getId()).get();
            edit.setEstoque(edit.getEstoque().add(new BigDecimal(quantity)));
            if (edit.getEstoque().doubleValue() >= 1.0) {
                edit.setEmFalta(Boolean.valueOf(false));
            }
            this.produtoRepository.save((Object)edit);
        }
    }

    public void validateCustomizationValueOnStock(Pedido order) throws ApiException {
        for (ItemDoPedido item : order.getItensDoPedido()) {
            for (ValorDaPersonalizacao value : item.getValoresDasPersonalizacoes()) {
                ValorDaPersonalizacao currentValue = (ValorDaPersonalizacao)this.customizationValueRepository.findById((Object)value.getId()).get();
                if (currentValue.getEstoque() == 0.0) {
                    throw new ApiException("msg.erro.129", new String[]{value.getDescricao()});
                }
                if (!(item.getQuantidade() > currentValue.getEstoque())) continue;
                throw new ApiException("msg.erro.130", new String[]{value.getDescricao()});
            }
        }
    }

    public void validateOrderItemsOnStock(Pedido order) throws ApiException {
        for (ItemDoPedido item : order.getItensDoPedido()) {
            if (NullUtil.isNotNull((Object)item.getProduto())) {
                if (item.getProduto().getEstoqueIlimitado().booleanValue()) continue;
                Produto product = (Produto)this.produtoRepository.findById((Object)item.getProduto().getId()).get();
                this.validadeProductOnStock(item, product);
                continue;
            }
            List productsIds = Arrays.asList(item.getProdutoComposto().getProdutosIds().split(",")).stream().map(id -> new Long((String)id)).collect(Collectors.toList());
            List products = this.produtoRepository.findByIdIn(productsIds);
            for (Produto product : products) {
                this.validadeProductOnStock(item, product);
            }
        }
    }

    public void validateProductPromotionBasketsOnStock(Pedido order) throws ApiException {
        for (CestaDePromocao cesta : order.getCestasDePromocao()) {
            for (ItemDoPedidoPorPromocao item : cesta.getItens()) {
                if (NullUtil.isNotNull((Object)item.getProduto())) {
                    if (item.getProduto().getEstoqueIlimitado().booleanValue()) continue;
                    Produto product = (Produto)this.produtoRepository.findById((Object)item.getProduto().getId()).get();
                    this.validateProductOnStock(cesta, item, product);
                    continue;
                }
                List products = this.listProductsFromPromotionComposedProduct(item);
                for (Produto product : products) {
                    if (item.getProduto().getEstoqueIlimitado().booleanValue()) continue;
                    this.validateProductOnStock(cesta, item, product);
                }
            }
        }
    }

    private List<Produto> listProductsFromPromotionComposedProduct(ItemDoPedidoPorPromocao orderItem) {
        List productsIds = Arrays.asList(orderItem.getProdutoComposto().getProdutosIds().split(",")).stream().map(id -> new Long((String)id)).collect(Collectors.toList());
        return this.produtoRepository.findByIdIn(productsIds);
    }

    private void validadeProductOnStock(ItemDoPedido item, Produto product) throws ApiException {
        if (product.getEstoque().equals(BigDecimal.ZERO)) {
            throw new ApiException("msg.erro.129", new String[]{product.getNome()});
        }
        if (item.getQuantidade() > product.getEstoque().doubleValue()) {
            throw new ApiException("msg.erro.130", new String[]{product.getNome()});
        }
    }

    private void validateProductOnStock(CestaDePromocao promotionBasket, ItemDoPedidoPorPromocao item, Produto product) throws ApiException {
        if (product.getEstoque().equals(BigDecimal.ZERO)) {
            throw new ApiException("msg.erro.131", new String[]{product.getNome(), promotionBasket.getPromocao().getTitulo()});
        }
        if (item.getQuantidade().doubleValue() > product.getEstoque().doubleValue()) {
            throw new ApiException("msg.erro.132", new String[]{product.getNome(), promotionBasket.getPromocao().getTitulo()});
        }
    }
}

