/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CategoriaDoProduto;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.model.projection.AutocompleteView;
import com.escolpi.omni.api.model.specification.builder.CategoriaDoProdutoSpecificationBuilder;
import com.escolpi.omni.api.repository.CategoriaDoProdutoRepository;
import com.escolpi.omni.api.repository.ProdutoRepository;
import com.escolpi.omni.api.service.FileService;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.FileUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class CategoriaDoProdutoService
implements BaseCrudService<CategoriaDoProduto, Long> {
    @Autowired
    private CategoriaDoProdutoRepository categoriaRepository;
    @Autowired
    private ProdutoRepository produtoRepository;
    @Autowired
    private FileService fileService;

    public Integer countPizzaCategories(Long companyId) {
        return this.categoriaRepository.countByComposicaoIsTrueAndEmpresaId(companyId);
    }

    public List<AutocompleteView> searchByAutocomplete(Long empresaId, String descricao) throws ApiException {
        return this.categoriaRepository.autoCompleteByDescription(empresaId, descricao);
    }

    public Page<CategoriaDoProduto> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) {
        CategoriaDoProdutoSpecificationBuilder builder = new CategoriaDoProdutoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        return this.categoriaRepository.findAll(spec, (Pageable)pageable);
    }

    public List<CategoriaDoProduto> findAll(Long empresaId) {
        return this.categoriaRepository.findByEmpresaIdAndExcluidaIsFalseOrderByDescricao(empresaId);
    }

    public List<CategoriaDoProduto> findAllParentCategories(Long empresaId) {
        return this.categoriaRepository.findAllParentCategoriesByEmpresaId(empresaId);
    }

    public List<CategoriaDoProduto> findAllWithoutSubcategories(Long empresaId) {
        return this.categoriaRepository.findByEmpresaIdAndExcluidaIsFalseAndCategoriaPaiIsNullOrderByDescricao(empresaId);
    }

    public CategoriaDoProduto findById(Long id) throws ApiException {
        CategoriaDoProduto category = (CategoriaDoProduto)this.categoriaRepository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Categoria do Produto", id.toString()}));
        if (StringUtils.hasText((String)category.getCaminhoFoto())) {
            category.setFoto(this.fileService.getPictureUrl(category, false));
            category.setMiniatura(this.fileService.getPictureUrl(category, true));
        }
        return category;
    }

    public CategoriaDoProduto findById(Long id, Long empresaId) throws ApiException {
        CategoriaDoProduto category = (CategoriaDoProduto)this.categoriaRepository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Categoria do Produto", id.toString()}));
        if (StringUtils.hasText((String)category.getCaminhoFoto())) {
            category.setFoto(this.fileService.getPictureUrl(category, false));
            category.setMiniatura(this.fileService.getPictureUrl(category, true));
        }
        if (!category.getEmpresa().getId().equals(empresaId)) {
            throw new ApiException("erro.nao.vinculada", new String[]{Entidade.CATEGORIA_DO_PRODUTO.getDescricao()});
        }
        return category;
    }

    @Transactional
    public void save(CategoriaDoProduto category) throws ApiException {
        this.validate(category);
        if (NullUtil.isNotNullOrZero((Number)category.getId())) {
            CategoriaDoProduto edit = this.populateCategory(category);
            this.categoriaRepository.save((Object)edit);
            this.saveCategorySpotlightPicture(edit);
        } else {
            CategoriaDoProduto cat;
            if (this.categoriaRepository.countByDescricaoAndEmpresaId(category.getDescricao(), category.getEmpresa().getId()) > 0L && !(cat = this.categoriaRepository.findTopByEmpresaIdAndDescricaoOrderByIdDesc(category.getEmpresa().getId(), category.getDescricao())).getExcluida().booleanValue()) {
                throw new ApiException("erro.entidade.existente.f", new String[]{"Categoria do Produto"});
            }
            if (NullUtil.isNullOrZero((Number)category.getOrdem())) {
                category.setOrdem(Integer.valueOf(1));
            }
            category.setExcluida(Boolean.valueOf(false));
            this.categoriaRepository.save((Object)category);
            this.saveCategorySpotlightPicture(category);
        }
    }

    @Transactional
    public void delete(Long id) throws ApiException {
        CategoriaDoProduto categoria = (CategoriaDoProduto)this.categoriaRepository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Categoria do Produto", id.toString()}));
        List produtosCategoria = this.produtoRepository.findByEmpresaIdAndCategoriaIdAndExcluidoIsFalseOrderByNome(categoria.getEmpresa().getId(), id);
        for (Produto produto : produtosCategoria) {
            produto.setExcluido(Boolean.valueOf(true));
            this.produtoRepository.save((Object)produto);
        }
        categoria.setExcluida(Boolean.valueOf(true));
        this.categoriaRepository.save((Object)categoria);
    }

    @Transactional
    public void updateCategoriesActivationState(Set<CategoriaDoProduto> categories) throws ApiException {
        for (CategoriaDoProduto category : categories) {
            CategoriaDoProduto edit = this.findById(category.getId());
            edit.setAtivo(category.getAtivo());
            edit.setOrdem(category.getOrdem());
            this.categoriaRepository.save((Object)edit);
        }
    }

    public void validate(CategoriaDoProduto categoria) throws ApiException {
        CategoriaDoProduto cat;
        if (NullUtil.isNotNullOrZero((Number)categoria.getId()) && this.categoriaRepository.countByDescricaoAndEmpresaIdAndIdNotAndExcluidaIsFalseAndAtivoIsTrue(categoria.getDescricao(), categoria.getEmpresa().getId(), categoria.getId()) > 0L && !(cat = this.categoriaRepository.findTopByEmpresaIdAndDescricaoOrderByIdDesc(categoria.getEmpresa().getId(), categoria.getDescricao())).getExcluida().booleanValue()) {
            throw new ApiException("erro.entidade.existente.f", new String[]{"Categoria do Produto"});
        }
        if (!NullUtil.isNotNull((Object)categoria)) {
            throw new ApiException("msg.erro.001", new String[]{"Categoria do Produto"});
        }
        if (!NullUtil.isNotNull((Object)categoria.getDescricao())) {
            throw new ApiException("msg.erro.001", new String[]{"Descri\u00e7\u00e3o da Categoria do Produto"});
        }
        if (!NullUtil.isNotNull((Object)categoria.getEmpresa().getId())) {
            throw new ApiException("msg.erro.001", new String[]{"Empresa"});
        }
    }

    private String getCategoriesPath(Long companyId) throws ApiException {
        return this.fileService.getCompanyPath(companyId.toString(), "/galeria/categorias/destaques", Boolean.valueOf(true));
    }

    private String generatePictureName(CategoriaDoProduto category) {
        if (StringUtil.isNotBlank((String)category.getFoto()) && StringUtil.isNotBlank((String)category.getCaminhoFoto())) {
            return DateUtil.format((String)"yyyyMMdd", (Date)new Date()) + "_" + new Date().getTime() + StringUtil.obterExtensao((String)category.getCaminhoFoto());
        }
        return null;
    }

    private CategoriaDoProduto populateCategory(CategoriaDoProduto category) throws ApiException {
        CategoriaDoProduto edit = (CategoriaDoProduto)this.categoriaRepository.findById((Object)category.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Categoria do Produto", category.getId().toString()}));
        edit.setDescricao(category.getDescricao());
        edit.setEmblema(category.getEmblema());
        edit.setCategoriaPai(category.getCategoriaPai());
        edit.setAtivo(Boolean.valueOf(NullUtil.isNull((Object)category.getAtivo()) ? true : category.getAtivo()));
        edit.setQuantitativa(category.getQuantitativa());
        edit.setComposicao(category.getComposicao());
        edit.setDestaque(Boolean.valueOf(NullUtil.isNotNull((Object)category.getDescricao()) ? category.getDestaque() : false));
        edit.setCaminhoFoto(category.getCaminhoFoto());
        edit.setDisponibilidades(category.getDisponibilidades());
        edit.setEditarFoto(category.getEditarFoto());
        edit.setFoto(category.getFoto());
        return edit;
    }

    @Transactional
    private void saveCategorySpotlightPicture(CategoriaDoProduto category) throws ApiException {
        if (category.getEditarFoto().booleanValue() && StringUtils.hasText((String)category.getCaminhoFoto())) {
            String path = this.getCategoriesPath(category.getEmpresa().getId()) + File.separator;
            String currentPath = path + category.getCaminhoFoto();
            String thumbPath = this.getCategoriesPath(category.getEmpresa().getId()) + File.separator + "_" + category.getCaminhoFoto();
            if (FileUtil.fileExists((String)currentPath)) {
                FileUtil.deleteFile((String)currentPath);
            }
            if (FileUtil.fileExists((String)thumbPath)) {
                FileUtil.deleteFile((String)thumbPath);
            }
            category.setCaminhoFoto(this.generatePictureName(category));
            path = path + category.getCaminhoFoto();
            this.fileService.saveBase64File(path, category.getFoto());
            this.fileService.saveThumbnailFile(path, category.getFoto(), 640);
        }
    }
}

