/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.BairroNaoAtendido;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.dto.Option;
import com.escolpi.omni.api.model.specification.builder.BairroNaoAtendidoSpecificationBuilder;
import com.escolpi.omni.api.repository.BairroNaoAtendidoRepository;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.repository.MunicipioAtendidoRepository;
import com.escolpi.omni.api.repository.TarifacaoDeEntregaRepository;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintViolationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BairroNaoAtendidoService
implements BaseCrudService<BairroNaoAtendido, Long> {
    @Autowired
    EmpresaRepository empresaRepository;
    @Autowired
    BairroNaoAtendidoRepository repository;
    @Autowired
    MunicipioAtendidoRepository municipioAtendidoRepository;
    @Autowired
    private TarifacaoDeEntregaRepository tarifacaoDeEntregaRepository;

    @Transactional
    public void delete(Long id) throws ApiException {
        try {
            this.repository.deleteById((Object)id);
        }
        catch (ConstraintViolationException | DataIntegrityViolationException e) {
            throw new ApiException("msg.erro.048", new String[]{"Bairro n\u00e3o Atendido", "Pedido"});
        }
    }

    public Page<BairroNaoAtendido> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) throws ApiException {
        BairroNaoAtendidoSpecificationBuilder builder = new BairroNaoAtendidoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        return this.repository.findAll(spec, (Pageable)pageable);
    }

    public List<BairroNaoAtendido> findAll(Long empresaId) throws ApiException {
        return this.repository.findByEmpresaId(empresaId);
    }

    public BairroNaoAtendido findById(Long id) throws ApiException {
        return (BairroNaoAtendido)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Bairro n\u00e3o Atendido", id.toString()}));
    }

    public BairroNaoAtendido findById(Long id, Long empresaId) throws ApiException {
        BairroNaoAtendido neighborhood = (BairroNaoAtendido)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Bairro n\u00e3o Atendido", id.toString()}));
        if (!neighborhood.getEmpresa().getId().equals(empresaId)) {
            throw new ApiException("erro.nao.vinculado", new String[]{Entidade.BAIRRO_NAO_ATENDIDO.getDescricao()});
        }
        return neighborhood;
    }

    public List<Option> listCitiesByCompanyId(Long companyId) throws ApiException {
        ArrayList<Option> options = new ArrayList<Option>();
        Empresa empresa = (Empresa)this.empresaRepository.findById((Object)companyId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", companyId.toString()}));
        options.add(new Option(empresa.getMunicipio().getMunicipioFormatado(), empresa.getMunicipio().getId().toString()));
        this.municipioAtendidoRepository.findByEmpresaIdOrderByMunicipioNome(companyId).forEach(municipioAtendido -> options.add(new Option(municipioAtendido.getMunicipio().getMunicipioFormatado(), municipioAtendido.getMunicipio().getId().toString())));
        return options;
    }

    @Transactional
    public void save(BairroNaoAtendido bairro) throws ApiException {
        this.validate(bairro);
        bairro.setNome(bairro.getNome().trim());
        if (NullUtil.isNotNullOrZero((Number)bairro.getId())) {
            BairroNaoAtendido edicao = this.findById(bairro.getId());
            edicao.setNome(bairro.getNome());
            edicao.setMunicipio(bairro.getMunicipio());
            this.repository.save((Object)edicao);
            return;
        }
        this.repository.save((Object)bairro);
    }

    public void validate(BairroNaoAtendido bairro) throws ApiException {
        if (NullUtil.isNull((Object)bairro)) {
            throw new ApiException("msg.erro.001", new String[]{"Bairro n\u00e3o Atendido"});
        }
        if (StringUtil.isBlank((String)bairro.getNome())) {
            throw new ApiException("msg.erro.001", new String[]{"Nome"});
        }
        if (NullUtil.isNull((Object)bairro.getMunicipio())) {
            throw new ApiException("msg.erro.001", new String[]{"Munic\u00edpio"});
        }
        if (NullUtil.isNull((Object)bairro.getEmpresa()) || NullUtil.isNullOrZero((Number)bairro.getEmpresa().getId())) {
            throw new ApiException("msg.erro.001", new String[]{"Empresa"});
        }
        if (NullUtil.isNotNullOrZero((Number)bairro.getId()) ? this.repository.countByIdNotAndEmpresaIdAndMunicipioIdAndNome(bairro.getId(), bairro.getMunicipio().getId(), bairro.getEmpresa().getId(), bairro.getNome()) > 0L : this.repository.checkIfNeighborhoodExists(bairro.getEmpresa().getId(), bairro.getMunicipio().getId(), bairro.getNome()) > 0L) {
            throw new ApiException("erro.entidade.existente.m", new String[]{"Bairro n\u00e3o Atendido"});
        }
        if (this.tarifacaoDeEntregaRepository.countByEmpresaIdAndMunicipioIdAndBairroIgnoreCase(bairro.getEmpresa().getId(), bairro.getMunicipio().getId(), bairro.getNome()) > 0L) {
            throw new ApiException("msg.erro.171", new String[]{bairro.getNome(), "taxas de entrega"});
        }
    }
}

