/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.security.filter;

import com.escolpi.omni.api.domain.Domains;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=-2147483648)
public class CorsFilter
implements Filter {
    public static final List<String> ORIGENS_PERMITIDAS = Arrays.asList(Domains.CORS_ALLOWED_ORIGINS);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (ORIGENS_PERMITIDAS.contains(req.getHeader("Origin"))) {
            resp.setHeader("Access-Control-Allow-Origin", req.getHeader("Origin"));
        }
        resp.setHeader("Access-Control-Allow-Credentials", "true");
        if ("OPTIONS".equals(req.getMethod()) && ORIGENS_PERMITIDAS.contains(req.getHeader("Origin"))) {
            resp.setHeader("Access-Control-Allow-Methods", "POST, GET, DELETE, PUT, OPTIONS");
            resp.setHeader("Access-Control-Allow-Headers", "Authorization, Content-Type, Accept, Pdag-Secure-Token");
            resp.setHeader("Access-Control-Max-Age", "3600");
            resp.setStatus(200);
        } else {
            chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        }
    }
}

