/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.store;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CategoriaDoProduto;
import com.escolpi.omni.api.model.entity.ConfiguracaoDePizzaria;
import com.escolpi.omni.api.model.entity.ProdutoDoCatalogo;
import com.escolpi.omni.api.model.entity.dto.CatalogoDePersonalizacoes;
import com.escolpi.omni.api.model.projection.EmpresaProdutoEmDestaqueView;
import com.escolpi.omni.api.model.projection.EmpresaView;
import com.escolpi.omni.api.model.projection.ProdutoView;
import com.escolpi.omni.api.model.projection.PromocaoView;
import com.escolpi.omni.api.model.projection.StatusDaLojaView;
import com.escolpi.omni.api.model.projection.StatusDoPedidoView;
import com.escolpi.omni.api.service.CatalogoService;
import com.escolpi.omni.api.service.ConfiguracaoDePizzariaService;
import com.escolpi.omni.api.service.EmpresaService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/store"})
public class StoreResource {
    @Autowired
    private CatalogoService catalogService;
    @Autowired
    private EmpresaService companyService;
    @Autowired
    private ConfiguracaoDePizzariaService pizzaConfigService;

    @GetMapping(value={"/catalog/{companyId}/product/{productId}"})
    public ResponseEntity<ProdutoView> findProductById(@PathVariable Long companyId, @PathVariable Long productId) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.catalogService.findProductToCatalog(companyId, productId));
    }

    @GetMapping(value={"/catalog/{companyId}/product/{productId}/customizations"})
    public ResponseEntity<CatalogoDePersonalizacoes> getCustomizationCatalogByProduct(@PathVariable Long productId) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.catalogService.getCustomizationCatalogByProduct(productId));
    }

    @GetMapping(value={"/{storeId}"})
    public ResponseEntity<EmpresaView> getCompanyByStoreId(@PathVariable String storeId) throws ApiException {
        return new ResponseEntity((Object)this.companyService.findCompanyByStoreId(storeId), HttpStatus.OK);
    }

    @GetMapping(value={"/order/{orderId}"})
    public ResponseEntity<StatusDoPedidoView> getOrderState(@PathVariable Long orderId) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.catalogService.getOrderState(orderId));
    }

    @GetMapping(value={"/order/customer/{customerId}"})
    public ResponseEntity<StatusDoPedidoView> getOrderStateByCustomer(@PathVariable Long customerId) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.catalogService.getOrderStateByCustomer(customerId));
    }

    @GetMapping(value={"/catalog/{companyId}/configuration/pizza"})
    public ResponseEntity<ConfiguracaoDePizzaria> getPizzaConfig(@PathVariable Long companyId) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.pizzaConfigService.findByCompany(companyId));
    }

    @GetMapping(value={"/{companyId}/is-opened"})
    public ResponseEntity<Boolean> getStoreOpeningState(@PathVariable Long companyId) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.companyService.getOpeningState(companyId));
    }

    @GetMapping(value={"/{companyId}/work/state"})
    public ResponseEntity<StatusDaLojaView> getWorkingState(@PathVariable Long companyId) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.companyService.getStoreOpeningStatus(companyId));
    }

    @GetMapping(value={"/{companyId}/work/state/order/{orderId}"})
    public ResponseEntity<StatusDaLojaView> getWorkingState(@PathVariable Long companyId, @PathVariable Long orderId) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.companyService.getStoreOpeningStatus(companyId));
    }

    @GetMapping(value={"/catalog/{companyId}/categories"})
    public ResponseEntity<List<CategoriaDoProduto>> listCategories(@PathVariable Long companyId) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.catalogService.listCategoriesByCompany(companyId));
    }

    @GetMapping(value={"/catalog/{companyId}/products/category/{categoryId}"})
    public ResponseEntity<List<ProdutoDoCatalogo>> listCatalogProductsByCategory(@PathVariable Long categoryId) {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.catalogService.listCatalogProductsByCategory(categoryId));
    }

    @GetMapping(value={"/catalog/{companyId}/spotlight/categories"})
    public ResponseEntity<List<CategoriaDoProduto>> listSpotlightCategoriesByCompany(@PathVariable Long companyId) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.catalogService.listSpotlightCategoryByCompany(companyId));
    }

    @GetMapping(value={"/catalog/{companyId}/spotlight/products"})
    public ResponseEntity<List<EmpresaProdutoEmDestaqueView>> listSpotlightProductsByCompany(@PathVariable Long companyId) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.catalogService.listSpotlightProductsByCompany(companyId));
    }

    @GetMapping(value={"/catalog/{companyId}/category/{categoryId}/subcategories"})
    public ResponseEntity<List<CategoriaDoProduto>> listSubcategories(@PathVariable Long categoryId) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.catalogService.listSubCategoriesByCategory(categoryId));
    }

    @GetMapping(value={"/catalog/{companyId}/spotlight/products/temp"})
    public ResponseEntity<List<ProdutoView>> listTempSpotlightProductsByCompany(@PathVariable Long companyId) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.catalogService.listTempSpotlightProductsByCompany(companyId));
    }

    @GetMapping(value={"/catalog/{companyId}/spotlight/promotions"})
    public ResponseEntity<List<PromocaoView>> listSpotlightPromotionsByCompany(@PathVariable Long companyId) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.catalogService.listSpotlightPromotionsByCompany(companyId));
    }

    @GetMapping(value={"/catalog/{companyId}/products/filter"})
    public ResponseEntity<Page<ProdutoDoCatalogo>> paginateCatalogProduct(@PathVariable(value="companyId") Long companyId, @RequestParam String search, @RequestParam Integer numeroPagina, @RequestParam(value="sortBy") List<String> sortBy, @RequestParam(value="sortDirection") String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.catalogService.paginateCatalogProduct(search, numeroPagina.intValue(), sortBy, sortDirection, Integer.valueOf(20)));
    }
}

