/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.LogDeAcessoService;
import com.escolpi.omni.api.service.ProdutoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/vinculo/pdv/{empresaId}"})
public class ManterVinculoDeProdutosComPdvResource
extends BaseResource {
    private Entidade entidade = Entidade.PRODUTO;
    @Autowired
    private ProdutoService service;
    @Autowired
    private LogDeAcessoService logService;

    @PostMapping
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_CATEGORIA_PRODUTO_EDITAR') and #oauth2.hasScope('write')")
    public void linkProductsToPdv(@PathVariable(value="empresaId") Long empresaId, @RequestBody List<Produto> products) throws ApiException {
        try {
            this.service.linkProducts(empresaId, products);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }
}

