/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.TarifaDeEntregaPorRaio;
import com.escolpi.omni.api.resource.impl.BaseCrudResource;
import com.escolpi.omni.api.service.LogDeAcessoService;
import com.escolpi.omni.api.service.TarifaDeEntregaPorRaioService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/tarifa-entrega-por-raio/{empresaId}"})
public class ManterTarifaDeEntregaPorRaioResource
implements BaseCrudResource<TarifaDeEntregaPorRaio, Long> {
    private Entidade entidade = Entidade.TARIFA_DE_ENTREGA_POR_RAIO;
    @Autowired
    private LogDeAcessoService logService;
    @Autowired
    private TarifaDeEntregaPorRaioService service;

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFA_ENTREGA_POR_RAIO_EXCLUIR') and #oauth2.hasScope('write')")
    public void delete(@PathVariable Long empresaId, @PathVariable Long id) throws ApiException {
        try {
            this.service.delete(id);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.EXCLUSAO, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/filter"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFA_ENTREGA_POR_RAIO_LISTAR') and #oauth2.hasScope('read')")
    public Page<TarifaDeEntregaPorRaio> filter(@PathVariable Long empresaId, @RequestParam String search, @RequestParam Integer numeroPagina, @RequestParam List<String> sortBy, @RequestParam String sortDirection, @RequestParam Integer entriesByPage) throws ApiException {
        return this.service.filter(search, numeroPagina.intValue(), sortBy, sortDirection, entriesByPage);
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFA_ENTREGA_POR_RAIO_OBTER') and #oauth2.hasScope('read')")
    public TarifaDeEntregaPorRaio get(@PathVariable Long empresaId, @PathVariable Long id) throws ApiException {
        try {
            return this.service.findById(id);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFA_ENTREGA_POR_RAIO_LISTAR') and #oauth2.hasScope('read')")
    public List<TarifaDeEntregaPorRaio> list(@PathVariable Long empresaId) throws ApiException {
        try {
            return this.service.findAll(empresaId);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @PostMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFA_ENTREGA_POR_RAIO_CRIAR') and #oauth2.hasScope('write')")
    public void save(@PathVariable Long empresaId, @RequestBody TarifaDeEntregaPorRaio entity) throws ApiException {
        try {
            this.service.save(entity);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.INCLUSAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFA_ENTREGA_POR_RAIO_EDITAR') and #oauth2.hasScope('write')")
    public void update(@PathVariable Long empresaId, @RequestBody TarifaDeEntregaPorRaio entity) throws ApiException {
        try {
            this.service.save(entity);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }
}

