/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.TarifaDeEntregaExclusiva;
import com.escolpi.omni.api.resource.impl.BaseCrudResource;
import com.escolpi.omni.api.service.LogDeAcessoService;
import com.escolpi.omni.api.service.TarifaDeEntregaExclusivaService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/tarifa-entrega-exclusiva/{empresaId}"})
public class ManterTarifaDeEntregaExclusivaResource
implements BaseCrudResource<TarifaDeEntregaExclusiva, Long> {
    private Entidade entidade = Entidade.TARIFA_DE_ENTREGA_EXCLUSIVA;
    @Autowired
    private LogDeAcessoService logService;
    @Autowired
    private TarifaDeEntregaExclusivaService service;

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFA_ENTREGA_EXCLUSIVA_EXCLUIR') and #oauth2.hasScope('write')")
    public void delete(@PathVariable Long empresaId, @PathVariable Long id) throws ApiException {
        try {
            this.service.delete(id);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.EXCLUSAO, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/filter"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFA_ENTREGA_EXCLUSIVA_LISTAR') and #oauth2.hasScope('read')")
    public Page<TarifaDeEntregaExclusiva> filter(@PathVariable Long empresaId, @RequestParam String search, @RequestParam Integer numeroPagina, @RequestParam List<String> sortBy, @RequestParam String sortDirection, @RequestParam Integer entriesByPage) throws ApiException {
        return this.service.filter(search, numeroPagina.intValue(), sortBy, sortDirection, entriesByPage);
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFA_ENTREGA_EXCLUSIVA_OBTER') and #oauth2.hasScope('read')")
    public TarifaDeEntregaExclusiva get(@PathVariable Long empresaId, @PathVariable Long id) throws ApiException {
        try {
            return this.service.findById(id);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @GetMapping
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFA_ENTREGA_EXCLUSIVA_LISTAR') and #oauth2.hasScope('read')")
    public List<TarifaDeEntregaExclusiva> list(@PathVariable Long empresaId) throws ApiException {
        return this.service.findAll(empresaId);
    }

    @PostMapping
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFA_ENTREGA_EXCLUSIVA_CRIAR') and #oauth2.hasScope('write')")
    public void save(@PathVariable Long empresaId, @RequestBody TarifaDeEntregaExclusiva entity) throws ApiException {
        try {
            this.service.save(entity);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.INCLUSAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFA_ENTREGA_EXCLUSIVA_EDITAR') and #oauth2.hasScope('write')")
    public void update(@PathVariable Long empresaId, @RequestBody TarifaDeEntregaExclusiva entity) throws ApiException {
        try {
            this.service.save(entity);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.INCLUSAO, e.getMessage());
            throw e;
        }
    }
}

