/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Emblema;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.resource.impl.BaseCrudResource;
import com.escolpi.omni.api.service.EmblemaService;
import com.escolpi.omni.api.service.LogDeAcessoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/emblemas/{empresaId}"})
public class ManterEmblemaResource
extends BaseResource
implements BaseCrudResource<Emblema, Long> {
    private Entidade entidade = Entidade.EMBLEMA;
    @Autowired
    private EmblemaService emblemaService;
    @Autowired
    private LogDeAcessoService logService;

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMBLEMA_EXCLUIR') and #oauth2.hasScope('write')")
    public void delete(@PathVariable(value="empresaId") Long empresaId, Long id) throws ApiException {
        try {
            this.emblemaService.delete(id);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.EXCLUSAO, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMBLEMA_OBTER') and #oauth2.hasScope('read')")
    public Emblema get(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="id") Long id) throws ApiException {
        try {
            return this.emblemaService.findById(id);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/filter"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMBLEMA_LISTAR') and #oauth2.hasScope('read')")
    public Page<Emblema> filter(@PathVariable(value="empresaId") Long empresaId, @RequestParam(value="search") String searchCriteria, @RequestParam(value="numeroPagina") Integer numeroPagina, @RequestParam(value="sortBy") List<String> sortBy, @RequestParam(value="sortDirection") String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        return this.emblemaService.filter(searchCriteria, numeroPagina.intValue(), sortBy, sortDirection, entriesByPage);
    }

    @GetMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMBLEMA_LISTAR') and #oauth2.hasScope('read')")
    public List<Emblema> list(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return this.emblemaService.findAll(empresaId);
    }

    public void save(@PathVariable(value="empresaId") Long empresaId, @RequestBody Emblema entity) throws ApiException {
    }

    public void update(@PathVariable(value="empresaId") Long empresaId, @RequestBody Emblema entity) throws ApiException {
    }
}

