/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.TarifaDeEntregaPorRaio;
import com.escolpi.omni.api.model.entity.TarifacaoDeEntrega;
import com.escolpi.omni.api.service.PedidoService;
import com.escolpi.omni.api.service.TarifacaoDeEntregaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tarifacoes-de-entrega/{empresaId}"})
public class TarifacaoDeEntregaResource {
    @Autowired
    PedidoService pedidoService;
    @Autowired
    private TarifacaoDeEntregaService service;

    @GetMapping(value={"/{id}"})
    public TarifacaoDeEntrega obter(@PathVariable(value="empresaId") Long empresaId, @PathVariable Long id) throws ApiException {
        return this.pedidoService.getDeliveryFee(empresaId, id);
    }

    @GetMapping(value={"/atendimento/bairro"})
    public TarifacaoDeEntrega obterPorMunicipioEBairro(@PathVariable Long empresaId, @RequestParam Long municipioId, @RequestParam String bairro) throws ApiException {
        return this.pedidoService.getDeliveryFeeByCityAndNeighborhood(empresaId, municipioId, bairro, null);
    }

    @GetMapping(value={"/atendimento/bairro-e-cep"})
    public TarifacaoDeEntrega obterPorMunicipioEBairro(@PathVariable Long empresaId, @RequestParam Long municipioId, @RequestParam String bairro, @RequestParam String cep) throws ApiException {
        return this.pedidoService.getDeliveryFeeByCityAndNeighborhood(empresaId, municipioId, bairro, cep);
    }

    @GetMapping(value={"/distance"})
    public TarifaDeEntregaPorRaio getDeliveryFeeByDistance(@PathVariable(value="empresaId") Long companyId, @RequestParam(value="distance") Integer distance) throws ApiException {
        return this.service.getDeliveryFeeByDistance(companyId, distance);
    }
}

