/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.service.TokenTemporarioService;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/secure"})
@RestController
public class SecurityResource {
    @Autowired
    private TokenTemporarioService service;
    @Autowired
    private BCryptPasswordEncoder encoder;

    @PostMapping(value={"/{companyId}"})
    public ResponseEntity<String> getAuthToken(@PathVariable Long companyId, @RequestBody String securePassword) throws ApiException {
        LocalDateTime now = LocalDateTime.ofInstant(Instant.now(), ZoneId.of(ZoneId.systemDefault().getId()));
        String token = String.format("%s:%s:%s", companyId, now.toEpochSecond(ZoneOffset.UTC), securePassword);
        String generated = this.encoder.encode((CharSequence)token);
        this.service.generateToken(companyId, generated);
        return ResponseEntity.ok((Object)generated);
    }
}

