/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Promocao;
import com.escolpi.omni.api.service.PromocaoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/promocoes/{empresaId}"})
public class PromocaoResource {
    @Autowired
    private PromocaoService service;

    @GetMapping
    public List<Promocao> list(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return this.service.getPromotionCatalogList(empresaId);
    }

    @GetMapping(value={"/catalogo"})
    public List<Promocao> listPromotionCatalog(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return this.service.getPromotionCatalogList(empresaId);
    }

    @GetMapping(value={"/catalogo/{promocaoId}"})
    public Promocao getSelectedPromotionFromCatalog(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="promocaoId") Long promocaoId) throws ApiException {
        return this.service.getSelectedPromotionFromCatalog(empresaId, promocaoId);
    }

    @GetMapping(value={"/{promocaoId}"})
    public Promocao get(@PathVariable(value="promocaoId") Long promocaoId) throws ApiException {
        return this.service.findActivePromotionById(promocaoId);
    }
}

