/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import br.com.uol.pagseguro.api.PagSeguroEnv;
import br.com.uol.pagseguro.api.common.domain.TransactionStatus;
import br.com.uol.pagseguro.api.exception.PagSeguroUnauthorizedException;
import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.FormaDeEntrega;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.enumeration.SituacaoDoPedido;
import com.escolpi.omni.api.enumeration.StatusDaTransacaoCielo;
import com.escolpi.omni.api.enumeration.TipoPagamento;
import com.escolpi.omni.api.enumeration.TipoPagamentoTransacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.Pagamento;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.CieloService;
import com.escolpi.omni.api.service.LogDeAcessoService;
import com.escolpi.omni.api.service.PagSeguroService;
import com.escolpi.omni.api.service.PagamentoService;
import com.escolpi.omni.api.service.PedidoService;
import com.escolpi.omni.api.util.NullUtil;
import java.io.IOException;
import java.math.BigDecimal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/payments/{empresaId}"})
public class PagamentoResource
extends BaseResource {
    private Entidade entidade = Entidade.PAG_SEGURO;
    @Autowired
    private CieloService cieloService;
    @Autowired
    private PagamentoService pagamentoService;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private LogDeAcessoService logService;
    @Autowired
    private PagSeguroService pagSeguroService;

    @GetMapping(value={"/transactions/cielo/payment/check-aprovement/{transactionCode}"})
    public boolean checkApprovementOnCielo(@PathVariable String transactionCode) throws ApiException, IOException {
        int status = this.cieloService.getTransactionStatus(transactionCode);
        return status == StatusDaTransacaoCielo.AUTHORIZED.getStatus() || status == StatusDaTransacaoCielo.PAYMENT_CONFIRMED.getStatus();
    }

    @GetMapping(value={"/transactions/pagseguro/payment/check-aprovement/{transactionCode}"})
    public boolean checkApprovmentOnPagSeguro(@PathVariable(value="empresaId") Long companyId, @PathVariable String transactionCode) throws ApiException, IOException {
        TransactionStatus.Status status = this.pagSeguroService.getTransactionStatus(new Empresa(companyId), transactionCode);
        if (this.pagSeguroService.getEnviroment().equals((Object)PagSeguroEnv.SANDBOX)) {
            return status.equals((Object)TransactionStatus.Status.APPROVED) || status.equals((Object)TransactionStatus.Status.WAITING_PAYMENT);
        }
        return status.equals((Object)TransactionStatus.Status.APPROVED);
    }

    @PostMapping(value={"/criar-sessao"}, produces={"text/plain"})
    public String createSession(@PathVariable(value="empresaId") Long empresaId) throws ApiException, IOException {
        try {
            String sessionId = this.pagSeguroService.createSession(empresaId).getId();
            return sessionId;
        }
        catch (PagSeguroUnauthorizedException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            return null;
        }
    }

    @GetMapping(value={"/transactions/cielo/get-brand/{cardNumber}"})
    public String findBrandByCardNumber(@PathVariable String cardNumber) throws ApiException, IOException {
        try {
            return this.cieloService.findBrandByCardNumber(cardNumber);
        }
        catch (Exception e) {
            return null;
        }
    }

    @GetMapping(value={"/{orderId}"})
    public Pagamento findByOrderId(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="orderId") Long pedidoId) throws ApiException {
        return this.pagamentoService.findByOrderId(pedidoId);
    }

    @PostMapping(value={"/transactions/cielo/payment/{transactionType}"})
    public String processPaymentWithCielo(@PathVariable(value="empresaId") Long companyId, @PathVariable(value="transactionType") String selectedTransactionType, @RequestBody Pedido order) throws ApiException, IOException {
        this.correctOrderItem(order);
        TipoPagamento transactionType = TipoPagamentoTransacao.CREDITO.getDescricao().equals(selectedTransactionType) ? TipoPagamento.CREDITO : TipoPagamento.DEBITO;
        return this.cieloService.convertAndSendPaymentOrder(order, transactionType);
    }

    @PostMapping(value={"/transactions/pagseguro/payment"})
    public String processPaymentWithPagSeguro(@PathVariable(value="empresaId") Long companyId, @RequestBody Pedido order) throws ApiException, IOException {
        try {
            this.correctOrderItem(order);
            return this.pagSeguroService.processPayment(companyId, order);
        }
        catch (PagSeguroUnauthorizedException e) {
            this.logService.save(companyId, this.entidade, Operacao.PAGAMENTO_ONLINE, e.getCause().getMessage());
            throw new ApiException("msg.confirm.036");
        }
        catch (Exception e) {
            this.logService.save(companyId, this.entidade, Operacao.PAGAMENTO_ONLINE, e.getMessage());
            throw new ApiException("msg.confirm.036");
        }
    }

    @PostMapping(value={"/transactions/cielo/{transactionType}/send-order/{transactionCode}"})
    public void sendOrderByCielo(@PathVariable(value="empresaId") Long companyId, @PathVariable(value="transactionType") String selectedTransactionType, @PathVariable String transactionCode, @RequestBody Pedido order) throws ApiException, IOException {
        try {
            TipoPagamento transactionType = TipoPagamento.CREDITO.getDescricao().equals(selectedTransactionType) ? TipoPagamento.CREDITO : TipoPagamento.DEBITO;
            this.setOrderStatusByCieloTransactionCode(transactionCode, order);
            this.pedidoService.saveOrder(order, companyId, true);
            this.cieloService.savePayment(order, transactionCode, transactionType);
        }
        catch (Exception e) {
            this.logService.save(companyId, this.entidade, Operacao.PAGAMENTO_ONLINE, e.getCause().getMessage());
        }
    }

    @PostMapping(value={"/transactions/pagseguro/send-order/{transactionCode}"})
    public void sendOrderByPagSeguro(@PathVariable(value="empresaId") Long companyId, @PathVariable String transactionCode, @RequestBody Pedido order) throws ApiException {
        try {
            this.setORderStatusByPagSeguroTransactionCode(transactionCode, order);
            this.pedidoService.saveOrder(order, companyId, true);
            this.pagSeguroService.savePayment(order, transactionCode);
        }
        catch (Exception e) {
            this.logService.save(companyId, this.entidade, Operacao.PAGAMENTO_ONLINE, e.getCause().getMessage());
        }
    }

    private void setOrderStatusByCieloTransactionCode(String transactionCode, Pedido order) throws IOException {
        int status = this.cieloService.getTransactionStatus(transactionCode);
        StatusDaTransacaoCielo transactionStatus = StatusDaTransacaoCielo.get((int)status);
        if (transactionStatus.equals((Object)StatusDaTransacaoCielo.AUTHORIZED) || transactionStatus.equals((Object)StatusDaTransacaoCielo.PAYMENT_CONFIRMED)) {
            order.setSituacao(SituacaoDoPedido.CONFIRMADO);
        } else if (transactionStatus.equals((Object)StatusDaTransacaoCielo.ABORTED) || transactionStatus.equals((Object)StatusDaTransacaoCielo.DENIED) || transactionStatus.equals((Object)StatusDaTransacaoCielo.NOT_FINISHED)) {
            order.setSituacao(SituacaoDoPedido.PAGAMENTO_RECUSADO);
        } else {
            order.setSituacao(SituacaoDoPedido.AGUARDANDO_PAGAMENTO);
        }
    }

    private void setORderStatusByPagSeguroTransactionCode(String transactionCode, Pedido order) throws ApiException {
        TransactionStatus.Status status = this.pagSeguroService.getTransactionStatus(order.getEmpresa(), transactionCode);
        if (status.equals((Object)TransactionStatus.Status.APPROVED)) {
            order.setSituacao(SituacaoDoPedido.CONFIRMADO);
        } else if (status.equals((Object)TransactionStatus.Status.RETURNED) || status.equals((Object)TransactionStatus.Status.CANCELLED) || status.equals((Object)TransactionStatus.Status.CONTESTATION) || status.equals((Object)TransactionStatus.Status.IN_DISPUTE) || status.equals((Object)TransactionStatus.Status.IN_REVIEW) || status.equals((Object)TransactionStatus.Status.PROCESSING_REFUND) || status.equals((Object)TransactionStatus.Status.PROCESSING_REFUND) || status.equals((Object)TransactionStatus.Status.RETURNED) || status.equals((Object)TransactionStatus.Status.UNRECOGNIZED)) {
            order.setSituacao(SituacaoDoPedido.PAGAMENTO_RECUSADO);
        } else {
            order.setSituacao(SituacaoDoPedido.AGUARDANDO_PAGAMENTO);
        }
    }

    private void correctOrderItem(Pedido order) {
        if (order.getFormaEntrega().equals((Object)FormaDeEntrega.RETIRAR_NO_LOCAL)) {
            if (NullUtil.isNotNull((Object)order.getEnderecoEntrega())) {
                order.setEnderecoEntrega(null);
            }
            if (NullUtil.isNotNullOrZero((BigDecimal)order.getTaxaDeEntrega())) {
                order.setTotalDoPedido(order.getTotalDoPedido().subtract(order.getTaxaDeEntrega()));
            }
        }
    }
}

