/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.EnderecoDeEntrega;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.EnderecoDeEntregaService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cliente/enderecos/{empresaId}"})
public class EnderecoDeEntregaResource
extends BaseResource {
    @Autowired
    private EnderecoDeEntregaService enderecoDeEntregaService;

    @GetMapping(value={"/{enderecoId}/obter"})
    public EnderecoDeEntrega obter(@PathVariable(value="enderecoId") Long enderecoId) throws ApiException {
        return this.enderecoDeEntregaService.obter(enderecoId);
    }

    @GetMapping(value={"/{clienteId}"})
    @PreAuthorize(value="hasAuthority('ROLE_ENDERECO_LISTAR') and #oauth2.hasScope('read')")
    public List<EnderecoDeEntrega> obterEnderecoDeEntregaPorUsuario(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="clienteId") Long clienteId) {
        return this.enderecoDeEntregaService.listarEnderecoDeEntregaPorUsuario(clienteId);
    }

    @GetMapping(value={"/{usuarioId}/endereco-principal"})
    @PreAuthorize(value="hasAuthority('ROLE_ENDERECO_OBTER') and #oauth2.hasScope('read')")
    public EnderecoDeEntrega obterEnderecoPrincipal(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="usuarioId") Long usuarioId) throws ApiException {
        return this.enderecoDeEntregaService.getMainDeliveryAddressOrFirst(usuarioId);
    }

    @PostMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ENDERECO_CRIAR') and #oauth2.hasScope('write')")
    public EnderecoDeEntrega inserir(@PathVariable(value="empresaId") Long empresaId, @RequestBody EnderecoDeEntrega enderecoDeEntrega) throws ApiException {
        return this.enderecoDeEntregaService.salvar(enderecoDeEntrega);
    }

    @PutMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ENDERECO_EDITAR') and #oauth2.hasScope('write')")
    public void alterar(@PathVariable(value="empresaId") Long empresaId, @RequestBody EnderecoDeEntrega enderecoDeEntrega) throws ApiException {
        this.enderecoDeEntregaService.salvar(enderecoDeEntrega);
    }

    @DeleteMapping(value={"/{enderecoId}"})
    @PreAuthorize(value="hasAuthority('ROLE_ENDERECO_EXCLUIR') and #oauth2.hasScope('write')")
    public void excluirEnderecoPorId(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="enderecoId") Long enderecoId) throws ApiException {
        this.enderecoDeEntregaService.excluirEnderecoDeEntrega(enderecoId);
    }
}

