/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.TokenTemporario;
import com.escolpi.omni.api.model.entity.dto.EmpresaDto;
import com.escolpi.omni.api.model.projection.StatusDaLojaView;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.EmpresaService;
import com.escolpi.omni.api.service.TokenTemporarioService;
import com.escolpi.omni.api.util.StringUtil;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/empresas/{companyId}"})
public class EmpresaResource
extends BaseResource {
    @Autowired
    private EmpresaService companyService;
    @Autowired
    private TokenTemporarioService secureTokenService;

    @GetMapping(value={"/exists"})
    public ResponseEntity<Boolean> companyExists(@PathVariable Long companyId) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.companyService.companyExists(companyId));
    }

    @DeleteMapping
    public ResponseEntity<Object> delete(@PathVariable Long companyId, HttpServletRequest request) throws ApiException {
        try {
            String receivedToken = request.getHeader("pdag-secure-token");
            if (StringUtil.isBlank((String)receivedToken)) {
                throw new ApiException("erro.token.nao.autorizado");
            }
            TokenTemporario secureToken = (TokenTemporario)this.secureTokenService.find(companyId, receivedToken).orElseThrow(() -> new ApiException("erro.token", new String[]{"n\u00e3o encontrado"}));
            this.secureTokenService.validateToken(secureToken, receivedToken);
            this.companyService.delete(companyId);
            this.companyService.deleteCompanyFiles(companyId);
            return ResponseEntity.ok().body((Object)true);
        }
        catch (Exception e) {
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)e);
        }
    }

    @GetMapping(value={"/atualizar"})
    @Deprecated
    public ResponseEntity<StatusDaLojaView> obterDadosAtualizados(@PathVariable Long companyId, @RequestParam(value="clienteId") Long clienteId) throws ApiException {
        StatusDaLojaView storeStatus = this.companyService.getStoreOpeningStatus(companyId);
        return new ResponseEntity((Object)storeStatus, HttpStatus.OK);
    }

    @Deprecated
    @GetMapping(value={"/atualizar/sem-cadastro/{orderId}"})
    public ResponseEntity<StatusDaLojaView> obterDadosAtualizadosSemCadastro(@PathVariable Long companyId, @PathVariable Long orderId) throws ApiException {
        StatusDaLojaView storeStatus = this.companyService.getStoreOpeningStatus(companyId);
        return new ResponseEntity((Object)storeStatus, HttpStatus.OK);
    }

    @Deprecated
    @GetMapping
    public EmpresaDto obterEmpresa(@PathVariable Long companyId) throws ApiException {
        return this.companyService.obterCadastroCompletoDaEmpresa(companyId);
    }

    @GetMapping(value={"/obter-filiais"})
    public List<EmpresaDto> obterFiliais(@PathVariable Long companyId) throws ApiException {
        return this.companyService.obterFiliais(companyId);
    }

    @Deprecated
    @GetMapping(value={"/em-funcionamento"})
    public boolean obterSituacaoFuncionamento(@PathVariable Long companyId) throws ApiException {
        return this.companyService.obterSituacaoDeFuncionamento(companyId);
    }

    @GetMapping(value={"/ultimo-acesso"})
    public Date obterUltimoAcesso(@PathVariable Long companyId) throws ApiException {
        return this.companyService.obterHorarioDoUltimoAcesso(companyId);
    }
}

