/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.repository;

import com.escolpi.omni.api.model.entity.ValorDaPersonalizacao;
import com.escolpi.omni.api.model.projection.RegistroView;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ValorDaPersonalizacaoRepository
extends JpaRepository<ValorDaPersonalizacao, Long> {
    public static final String ENTITY_NAME = "Valor da Personaliza\u00e7\u00e3o";

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.RegistroView(vp.personalizacao.id, vp.personalizacao.descricao) FROM ValorDaPersonalizacao vp WHERE vp.id = ?1")
    public Optional<RegistroView> findCustomizationByValueId(Long var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.RegistroView(vp.personalizacaoDeProduto.id, vp.personalizacaoDeProduto.descricao) FROM ValorDaPersonalizacao vp WHERE vp.id = ?1")
    public Optional<RegistroView> findCustomizationProductByValueId(Long var1);

    public List<ValorDaPersonalizacao> findByPersonalizacaoIdAndExcluidoIsFalseOrderByDescricaoAsc(@Param(value="personalizacaoId") Long var1);

    public List<ValorDaPersonalizacao> findByPersonalizacaoDeProdutoIdAndExcluidoIsFalseAndEmFaltaIsFalse(Long var1);

    public List<ValorDaPersonalizacao> findByPersonalizacaoDeProdutoIdAndExcluidoIsFalseOrderByDescricaoAsc(Long var1);

    public List<ValorDaPersonalizacao> findByProdutoIdAndExcluidoIsFalse(Long var1);

    @Query(value="SELECT COUNT(op) FROM ItemDoPedido ip INNER JOIN ip.opcionais op WHERE op.valorDaPersonalizacao.excluido = TRUE")
    public Long countValoresDaPersonalizacaoUtilizados();

    @Query(value="SELECT COUNT(p) FROM ValorDaPersonalizacao vp WHERE vp.personalizacao.id = :personalizacaoId AND vp.personalizacao.excluido = TRUE")
    public Long countValoresDaPersonalizacaoComPersonalizacoesNaoUtilizadas(@Param(value="personalizacaoId") Long var1);

    @Query(value="FROM ValorDaPersonalizacao vp WHERE vp.id IN (:customizationValueIds) AND vp.emFalta IS FALSE AND vp.estoqueIlimitado IS FALSE AND vp.estoque <= 0 ")
    public List<ValorDaPersonalizacao> listUnavaiableCustomizationValues(@Param(value="customizationValueIds") List<Long> var1);

    @Query(value="SELECT op.valorDaPersonalizacao FROM ItemDoPedido ip INNER JOIN ip.opcionais op WHERE op.valorDaPersonalizacao.excluido = TRUE")
    public List<ValorDaPersonalizacao> listarValoresDaPersonalizacaoExcluidas();
}

