/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.repository;

import com.escolpi.omni.api.model.entity.CategoriaDoProduto;
import com.escolpi.omni.api.model.projection.AutocompleteView;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface CategoriaDoProdutoRepository
extends JpaRepository<CategoriaDoProduto, Long>,
JpaSpecificationExecutor<CategoriaDoProduto> {
    public static final String ENTITY_NAME = "Categoria do Produto";

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.AutocompleteView(c.descricao, c.id) FROM CategoriaDoProduto c WHERE c.empresa.id = :empresaId AND c.excluida IS FALSE AND UNACCENT(c.descricao) LIKE CONCAT('%', UNACCENT(:descricao), '%') ORDER BY c.descricao")
    public List<AutocompleteView> autoCompleteByDescription(@Param(value="empresaId") Long var1, @Param(value="descricao") String var2);

    public Integer countByComposicaoIsTrueAndEmpresaId(Long var1);

    public Long countByDescricaoAndEmpresaId(String var1, Long var2);

    public Long countByDescricaoAndEmpresaIdAndIdNotAndExcluidaIsFalseAndAtivoIsTrue(String var1, Long var2, Long var3);

    @Query(value="FROM CategoriaDoProduto c WHERE c.empresa.id = :companyId AND c.excluida IS FALSE AND c.id IN (SELECT p.categoria.id FROM Produto p WHERE p.empresa.id = :companyId AND excluido IS FALSE GROUP BY p.categoria.id)")
    public List<CategoriaDoProduto> findAllExceptMasterAndEmptyCategories(@Param(value="companyId") Long var1);

    @Query(value="FROM CategoriaDoProduto c WHERE c.id IN (SELECT categoriaPai FROM CategoriaDoProduto cp WHERE cp.empresa.id = :empresaId AND cp.excluida IS FALSE)")
    public List<CategoriaDoProduto> findAllParentCategoriesByEmpresaId(@Param(value="empresaId") Long var1);

    @Query(value="SELECT DISTINCT(c) FROM CategoriaDoProduto c INNER JOIN Produto p ON c.id = p.categoria.id WHERE c.categoriaPai.id = :categoriaId AND c.ativo IS TRUE AND c.excluida IS FALSE")
    public List<CategoriaDoProduto> findByCategoriaPaiIdAndAtivoIsTrueAndExcluidaIsFalse(@Param(value="categoriaId") Long var1);

    public List<CategoriaDoProduto> findByEmpresaIdAndExcluidaIsFalseOrderByDescricao(Long var1);

    @Query(value="FROM CategoriaDoProduto c WHERE c.empresa.id = :empresaId AND c.excluida IS FALSE AND c.categoriaPai.id IS NULL AND c.id NOT IN (SELECT p.categoria.id FROM Produto p WHERE p.empresa.id = :empresaId AND p.excluido IS FALSE GROUP BY p.categoria.id) ORDER BY c.descricao")
    public List<CategoriaDoProduto> findByEmpresaIdAndExcluidaIsFalseAndCategoriaPaiIsNullOrderByDescricao(@Param(value="empresaId") Long var1);

    public List<CategoriaDoProduto> findByEmpresaIdAndAtivoIsFalse(Long var1);

    public List<CategoriaDoProduto> findByEmpresaIdAndAtivoIsTrue(Long var1);

    @Query(value="FROM CategoriaDoProduto c WHERE c.empresa.id = :companyId AND c.ativo IS TRUE AND c.destaque IS TRUE AND c.excluida IS FALSE AND c.disponibilidades LIKE CONCAT('%', :weekDay, '%') ")
    public List<CategoriaDoProduto> listSpotlightCategoryByCompany(@Param(value="companyId") Long var1, @Param(value="weekDay") String var2);

    @Query(value="FROM CategoriaDoProduto c WHERE c.empresa.id = :empresaId AND c.ativo IS TRUE AND c.excluida IS FALSE ORDER BY c.ordem, c.descricao")
    public List<CategoriaDoProduto> listAllCategoriesByCompany(@Param(value="empresaId") Long var1);

    @Query(value="FROM CategoriaDoProduto c WHERE c.empresa.id = :empresaId AND c.excluida IS FALSE AND c.ativo IS TRUE AND (SELECT COUNT (p) FROM Produto p WHERE p.excluido IS FALSE AND p.categoria.id = c.id AND c.categoriaPai IS NULL) > 0 OR c.empresa.id = :empresaId AND c.excluida IS FALSE AND (SELECT COUNT(cp) FROM CategoriaDoProduto cp WHERE c.id = cp.categoriaPai AND cp.ativo IS TRUE AND cp.excluida IS FALSE AND (SELECT COUNT(p) FROM Produto p WHERE p.categoria.id = cp.id AND p.excluido IS FALSE) > 0) > 0 ORDER BY c.ordem, c.descricao")
    public List<CategoriaDoProduto> listCategoriesByCompany(@Param(value="empresaId") Long var1);

    @Deprecated
    @Query(value="FROM CategoriaDoProduto c WHERE c.empresa.id = :empresaId AND c.excluida IS FALSE AND c.ativo IS TRUE AND (SELECT COUNT (p) FROM Produto p WHERE p.excluido IS FALSE AND p.categoria.id = c.id AND c.categoriaPai IS NULL) > 0 OR c.empresa.id = :empresaId AND c.excluida IS FALSE AND (SELECT COUNT(cp) FROM CategoriaDoProduto cp WHERE c.id = cp.categoriaPai AND cp.ativo IS TRUE AND cp.excluida IS FALSE AND (SELECT COUNT(p) FROM Produto p WHERE p.categoria.id = cp.id AND p.excluido IS FALSE) > 0) > 0 ORDER BY c.ordem, c.descricao")
    public List<CategoriaDoProduto> listCategoriesWithoutExclusivesByCompany(@Param(value="empresaId") Long var1);

    @Query(value="FROM CategoriaDoProduto c WHERE c.empresa.id = :companyId AND c.ativo IS TRUE AND c.excluida IS FALSE AND c.categoriaPai IS NULL AND c.disponibilidades LIKE CONCAT('%', :weekDay, '%') ORDER BY c.ordem, c.descricao")
    public List<CategoriaDoProduto> listCategories(@Param(value="companyId") Long var1, @Param(value="weekDay") String var2);

    @Query(value="FROM CategoriaDoProduto c WHERE c.categoriaPai.id = :categoryId AND c.excluida IS FALSE ORDER BY c.ordem, c.descricao")
    public List<CategoriaDoProduto> listSubCategories(Long var1);

    @Query(value="FROM CategoriaDoProduto c WHERE c.empresa.id = :empresaId AND c.excluida IS FALSE AND (SELECT COUNT(cp) FROM CategoriaDoProduto cp WHERE cp.empresa.id = :empresaId AND cp.categoriaPai.id = c.id AND cp.excluida IS FALSE) = 0 ORDER BY c.descricao")
    public List<CategoriaDoProduto> findSubcategories(@Param(value="empresaId") Long var1);

    @Query(value="FROM CategoriaDoProduto c WHERE c.categoriaPai.id = :categoriaId AND c.excluida IS FALSE AND c.categoriaPai.excluida IS FALSE ORDER BY c.descricao")
    public List<CategoriaDoProduto> findSubcategoriesByParent(@Param(value="categoriaId") Long var1);

    public CategoriaDoProduto findTop1ByEmpresaIdOrderByIdDesc(Long var1);

    public CategoriaDoProduto findTopByEmpresaIdAndDescricaoOrderByIdDesc(Long var1, String var2);

    @Query(value="FROM CategoriaDoProduto c WHERE c.empresa.id = :empresaId AND c.excluida IS FALSE AND UNACCENT(c.descricao) = UNACCENT(:descricao) ORDER BY c.descricao")
    public Optional<CategoriaDoProduto> findByDescricaoAndExcluidaIsFalse(Long var1, String var2);
}

