/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.specification;

import com.escolpi.omni.api.domain.SearchCriteria;
import com.escolpi.omni.api.model.entity.TarifacaoDeEntrega;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class TarifacaoDeEntregaSpecification
implements Specification<TarifacaoDeEntrega> {
    private static final long serialVersionUID = 8832919897651241124L;
    private SearchCriteria criteria;

    public TarifacaoDeEntregaSpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    public Predicate toPredicate(Root<TarifacaoDeEntrega> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        if (this.criteria.getKey().equals("empresaId")) {
            return builder.equal((Expression)root.get("empresa").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("municipioId")) {
            return builder.equal((Expression)root.get("municipio").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getOperation().equalsIgnoreCase(">")) {
            if (this.criteria.getKey().equals("menorValorTarifacao")) {
                return builder.greaterThanOrEqualTo((Expression)root.get("valor"), (Comparable)((Object)this.criteria.getValue().toString().replace(",", ".")));
            }
            return builder.greaterThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (this.criteria.getOperation().equalsIgnoreCase("<")) {
            if (this.criteria.getKey().equals("maiorValorTarifacao")) {
                return builder.lessThanOrEqualTo((Expression)root.get("valor"), (Comparable)((Object)this.criteria.getValue().toString().replace(",", ".")));
            }
            return builder.lessThanOrEqualTo((Expression)root.get(this.criteria.getKey()), (Comparable)((Object)this.criteria.getValue().toString()));
        }
        if (this.criteria.getOperation().equalsIgnoreCase(":")) {
            if (root.get(this.criteria.getKey()).getJavaType() == String.class) {
                return builder.like(builder.function("unaccent", String.class, new Expression[]{root.get(this.criteria.getKey())}), "%" + this.criteria.getValue().toString().toUpperCase() + "%");
            }
            return builder.equal((Expression)root.get(this.criteria.getKey()), this.criteria.getValue());
        }
        return null;
    }
}

