/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.specification;

import com.escolpi.omni.api.domain.SearchCriteria;
import com.escolpi.omni.api.enumeration.FormaDeEntrega;
import com.escolpi.omni.api.enumeration.SituacaoDoPedido;
import com.escolpi.omni.api.model.entity.PedidoResumido;
import com.escolpi.omni.api.util.DateUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class PedidoResumidoSpecification
implements Specification<PedidoResumido> {
    private static final long serialVersionUID = 9049088115665458176L;
    private SearchCriteria criteria;

    public PedidoResumidoSpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    public Predicate toPredicate(Root<PedidoResumido> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        if (this.criteria.getKey().equals("empresaId")) {
            return builder.equal((Expression)root.get("empresa").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("clienteId")) {
            return builder.equal((Expression)root.get("cliente").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("clienteNome")) {
            return builder.or((Expression)builder.like(builder.function("unaccent", String.class, new Expression[]{builder.upper((Expression)root.get("cliente").get("nome"))}), "%" + this.criteria.getValue().toString().toUpperCase() + "%"), (Expression)builder.like(builder.function("unaccent", String.class, new Expression[]{builder.upper((Expression)root.get("nomeClienteMesa"))}), "%" + this.criteria.getValue().toString().toUpperCase() + "%"));
        }
        if (this.criteria.getKey().equals("mesa")) {
            return builder.like(builder.function("unaccent", String.class, new Expression[]{builder.upper((Expression)root.get("mesa"))}), "%" + this.criteria.getValue().toString().toUpperCase() + "%");
        }
        if (this.criteria.getKey().equals("dataExpedienteInicio")) {
            return builder.greaterThanOrEqualTo((Expression)root.get("dataAtualizacaoPedido"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        if (this.criteria.getKey().equals("dataExpedienteFim")) {
            return builder.lessThanOrEqualTo((Expression)root.get("dataAtualizacaoPedido"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        if (this.criteria.getKey().equals("formaEntrega")) {
            return builder.equal((Expression)root.get("formaEntrega"), (Object)FormaDeEntrega.valueOf((String)this.criteria.getValue().toString()));
        }
        if (this.criteria.getKey().equals("situacao")) {
            return builder.equal((Expression)root.get("situacao"), (Object)SituacaoDoPedido.valueOf((String)this.criteria.getValue().toString()));
        }
        if (this.criteria.getKey().equals("rodizio")) {
            return builder.equal((Expression)root.get("rodizio"), this.criteria.getValue());
        }
        return null;
    }
}

