/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.entity;

import com.escolpi.omni.api.enumeration.FormaDeEntrega;
import com.escolpi.omni.api.enumeration.FormaDePagamento;
import com.escolpi.omni.api.enumeration.LojaDeOrigem;
import com.escolpi.omni.api.enumeration.Origem;
import com.escolpi.omni.api.enumeration.SituacaoDoPedido;
import com.escolpi.omni.api.model.entity.CartaoDoCliente;
import com.escolpi.omni.api.model.entity.CestaDePromocao;
import com.escolpi.omni.api.model.entity.Cliente;
import com.escolpi.omni.api.model.entity.CupomDeDesconto;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.EnderecoDeEntrega;
import com.escolpi.omni.api.model.entity.ItemDoPedido;
import com.escolpi.omni.api.model.entity.OpcaoDePagamentoComCartao;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.model.entity.TarifacaoDeEntrega;
import com.escolpi.omni.api.model.entity.Usuario;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name="pedidos")
@SequenceGenerator(name="pedidos_gen", sequenceName="pedidos_seq", initialValue=1, allocationSize=1)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Pedido
implements Serializable {
    private static final long serialVersionUID = -7536538128066648628L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="pedidos_gen")
    @Column(name="id")
    private Long id;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="cupom_desconto_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"empresa"})
    private CupomDeDesconto cupomDeDesconto;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="empresa_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"descontoPagamentoEmDinheiro", "controleEstoque", "nomeFantasia", "matriz", "municipio", "segmento", "usuario", "razaoSocial", "cnpj", "logotipo", "logotipoStore", "planoDeFundoStore", "nomeAbreviado", "telefonePrincipal", "telefoneSecundario", "urlSite", "cep", "logradouro", "numero", "complemento", "bairro", "contato", "emailContato", "fcmTokenServidor", "tempoDeEntrega", "tempoDeRetirada", "urlFacebook", "urlInstagram", "urlTwitter", "urlYoutube", "indWhatsapp", "urlAppAndroid", "urlAppIos", "urlStore", "versao", "versaoAndroid", "valorIsencaoEntrega", "aberto", "versaoIOS", "sobre", "aceitaPedidosAuto", "aceitaComandasAuto", "valorTarifaUnica", "dataDeCadastro", "dataInicioDeUtilizacao", "fusoHorario", "imprimePedidosAuto", "emailPagSeguro", "tokenPagSeguro", "ativo", "parcelaMinima", "maximoDeParcelas", "tokenFcm", "idStore", "quantidadeImpressoes", "fazDelivery", "fazRetirada", "imprimePedidosDistribuidosAuto", "emTeste", "valorMinimoParaEntrega", "latitude", "longitude", "facebookPixelId", "porcentagemDoCashback", "versaoVendas", "versaoVendasAndroid", "versaoVendasIos", "valorPlano", "limitePedidos", "valorPedidoExcedente", "diaVencimentoMensalidade", "porcentagemOutraPlataforma", "porcentagemDeComissao", "plano", "receberInformativos", "endereco"})
    private Empresa empresa;
    @Column(name="taxa_de_entrega")
    private BigDecimal taxaDeEntrega;
    @Column(name="valor_desconto_pagamento_dinheiro")
    private BigDecimal valorDescontoPagamentoEmDinheiro;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="cliente_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"usuario", "empresa", "cpf", "dataCadastro", "dataNascimento", "dataHoraAtualizacao", "ativo", "enderecosDeEntrega", "pagamentoOnlineBloqueado"})
    private Cliente cliente;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="endereco_entrega_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"cliente", "municipio.id", "municipio.ibgeId"})
    private EnderecoDeEntrega enderecoEntrega;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="opcao_pagamento_cartao_id", referencedColumnName="id")
    private OpcaoDePagamentoComCartao opcaoPagamentoCartao;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="dthr_pedido")
    private Date dataHoraPedido;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="forma_entrega")
    private FormaDeEntrega formaEntrega;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="forma_pagamento")
    private FormaDePagamento formaPagamento;
    @Column(name="valor_troco", length=8, precision=2)
    private BigDecimal valorTroco;
    @Column(name="cpf_cnpj_nota")
    private String cpfCnpjNota;
    @Column(name="mesa")
    private String mesa;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="situacao")
    private SituacaoDoPedido situacao;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="dt_atualizacao_pedido")
    private Date dataAtualizacaoPedido;
    @Column(name="feedback", length=1024)
    private String feedback;
    @Column(name="classificacao")
    private Integer classificacao;
    @Column(name="sugestao_melhoria")
    private String sugestaoMelhoria;
    @Enumerated(value=EnumType.ORDINAL)
    @Column(name="origem")
    private Origem origem;
    @Column(name="resposta_feedback", length=1024)
    private String respostaFeedback;
    @Column(name="ind_util")
    private Boolean feedbackUtil;
    @Column(name="dthr_agendamento")
    private Date dataHoraAgendamento;
    @Column(name="total_pedido")
    private BigDecimal totalDoPedido;
    @Column(name="nome_cliente_mesa")
    private String nomeClienteMesa;
    @Column(name="ind_teste")
    private Boolean teste;
    @Column(name="qtde_parcela")
    private Integer parcelas;
    @Column(name="valor_parcela")
    private BigDecimal valorDaParcela;
    @Column(name="loja_origem")
    private LojaDeOrigem lojaDeOrigem;
    @Column(name="id_externo")
    private String idExterno;
    @Column(name="nome_cliente_externo")
    private String nomeClienteExterno;
    @Column(name="endereco_entrega_externo")
    private String enderecoEntregaExterno;
    @Column(name="telefone_cliente_externo")
    private String telefoneClienteExterno;
    @OneToOne
    @JoinColumn(name="id_usuario_cancelamento")
    private Usuario usuarioCancelamento;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="dthr_cancelamento")
    private Date dataHoraCancelamento;
    @Column(name="credito_cashback")
    private BigDecimal creditoCashback;
    @Column(name="debito_cashback")
    private BigDecimal debitoCashback;
    @Column(name="ind_rodizio")
    private Boolean rodizio;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="rodizio_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"categoria", "categoriaDoRodizio", "empresa", "codigoAtosBroto", "codigoAtosBrotoMedio", "codigoAtosBrotoGrande", "codigoAtosBrotoGigante", "descricao", "valorTamanhoBroto", "valorTamanhoMedio", "valorTamanhoGrande", "valorTamanhoGigante", "valorDesconto", "labelTamanhoBroto", "labelTamanhoMedio", "labelTamanhoGrande", "labelTamanhoGigante", "emFalta", "vendaPorFracao", "vendaPorTamanho", "caminhoFoto", "dataHoraUltimaAtualizacao", "excluido", "pesoMedio", "fotoExterna", "disponibilidades", "estoque", "estoqueIlimitado", "limiteSelecaoTamanhoBroto", "limiteSelecaoTamanhoMedio", "limiteSelecaoTamanhoGrande", "limiteSelecaoTamanhoGigante", "exibeNaTelaInicial", "vendaPorAtacado", "qtdeMinVendaPorAtacado", "valorAtacado", "rodizio", "disponivelParaORodizio", "editarFoto", "miniatura", "emblema"})
    private Produto produtoDeRodizio;
    @Column(name="qtde_rodizio_completo")
    private Integer qtdeRodizioCompleto;
    @Column(name="qtde_rodizio_meio")
    private Integer qtdeMeioRodizio;
    @Column(name="valor_rodizio_completo")
    private BigDecimal valorRodizioCompleto;
    @Column(name="valor_rodizio_meio")
    private BigDecimal valorMeioRodizio;
    @Column(name="rodizio_fechado")
    private Boolean rodizioFechado;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="vendedor_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"empresa", "senha", "confirmacaoSenha", "demonstracao", "bloqueado", "excluido"})
    private Usuario vendedor;
    @Column(name="detalhe_pagamento")
    private String detalheDoPagamento;
    @Column(name="observacoes")
    private String observacoes;
    @Column(name="ind_frete")
    private Boolean comFrete;
    @Column(name="nome_empresa_frete")
    private String nomeDaEmpresaDoFrete;
    @Column(name="url_logo_empresa_frete")
    private String urlDoLogoDaEmpresaDoFrete;
    @Column(name="nome_servico_frete")
    private String nomeDoServicoDoFrete;
    @Column(name="valor_desconto_frete")
    private BigDecimal valorDeDescontoDoFrete;
    @Column(name="dias_estimativa_entrega_frete")
    private Integer estimativaDeEntrega;
    @Column(name="taxa_de_comissao")
    private BigDecimal taxaDeComissao;
    @Column(name="taxa_adicional")
    private BigDecimal taxaAdicional;
    @Column(name="ind_pedido_excedente")
    private Boolean pedidoExcedente;
    @Column(name="desconto_externo")
    private String descontoExterno;
    @Column(name="ind_cliente_sem_endereco")
    private Boolean clienteSemCadastro;
    @Column(name="nome_cliente_sem_cadastro")
    private String nomeClienteSemCadastro;
    @Column(name="telefone_cliente_sem_cadastro")
    private String telefoneClienteSemCadastro;
    @Column(name="endereco_entrega_cliente_sem_cadastro")
    private String enderecoDeEntregaClienteSemCadastro;
    @Column(name="ind_importado")
    private Boolean importado;
    @OneToMany(mappedBy="pedido", fetch=FetchType.LAZY)
    @OrderBy(value="id")
    private Set<ItemDoPedido> itensDoPedido;
    @OneToMany(mappedBy="pedido", fetch=FetchType.LAZY)
    @JsonIgnoreProperties(value={"pedido"})
    @OrderBy(value="id")
    private Set<CestaDePromocao> cestasDePromocao;
    @Transient
    private CartaoDoCliente cartaoDoCliente;
    @Transient
    private BigDecimal totalItensPedido;
    @Transient
    private TarifacaoDeEntrega tarifacaoEntrega;
    @Transient
    private String nomeUsuarioCancelamento;
    @Transient
    private Long cashbackId;
    @Transient
    private Long codigoDeConfirmacaoDePagamento;

    public Pedido() {
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public Pedido(Long id) {
        this.id = id;
    }

    @Transient
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public CupomDeDesconto getCupomDeDesconto() {
        return this.cupomDeDesconto;
    }

    public void setCupomDeDesconto(CupomDeDesconto cupomDeDesconto) {
        this.cupomDeDesconto = cupomDeDesconto;
    }

    public Empresa getEmpresa() {
        return this.empresa;
    }

    public BigDecimal getTaxaDeEntrega() {
        return this.taxaDeEntrega;
    }

    public void setTaxaDeEntrega(BigDecimal taxaDeEntrega) {
        this.taxaDeEntrega = taxaDeEntrega;
    }

    public BigDecimal getValorDescontoPagamentoEmDinheiro() {
        return this.valorDescontoPagamentoEmDinheiro;
    }

    public void setValorDescontoPagamentoEmDinheiro(BigDecimal valorDescontoPagamentoEmDinheiro) {
        this.valorDescontoPagamentoEmDinheiro = valorDescontoPagamentoEmDinheiro;
    }

    public Cliente getCliente() {
        return this.cliente;
    }

    public void setCliente(Cliente cliente) {
        this.cliente = cliente;
    }

    public EnderecoDeEntrega getEnderecoEntrega() {
        return this.enderecoEntrega;
    }

    public void setEnderecoEntrega(EnderecoDeEntrega enderecoEntrega) {
        this.enderecoEntrega = enderecoEntrega;
    }

    public Date getDataHoraPedido() {
        return this.dataHoraPedido;
    }

    public void setDataHoraPedido(Date dataHoraPedido) {
        this.dataHoraPedido = dataHoraPedido;
    }

    public FormaDeEntrega getFormaEntrega() {
        return this.formaEntrega;
    }

    public void setFormaEntrega(FormaDeEntrega formaEntrega) {
        this.formaEntrega = formaEntrega;
    }

    public FormaDePagamento getFormaPagamento() {
        return this.formaPagamento;
    }

    public void setFormaPagamento(FormaDePagamento formaPagamento) {
        this.formaPagamento = formaPagamento;
    }

    public OpcaoDePagamentoComCartao getOpcaoPagamentoCartao() {
        return this.opcaoPagamentoCartao;
    }

    public void setOpcaoPagamentoCartao(OpcaoDePagamentoComCartao opcaoPagamentoCartao) {
        this.opcaoPagamentoCartao = opcaoPagamentoCartao;
    }

    public BigDecimal getValorTroco() {
        return this.valorTroco;
    }

    public void setValorTroco(BigDecimal valorTroco) {
        this.valorTroco = valorTroco;
    }

    public String getCpfCnpjNota() {
        return this.cpfCnpjNota;
    }

    public void setCpfCnpjNota(String cpfCnpjNota) {
        this.cpfCnpjNota = cpfCnpjNota;
    }

    public String getMesa() {
        return this.mesa;
    }

    public void setMesa(String mesa) {
        this.mesa = mesa;
    }

    public SituacaoDoPedido getSituacao() {
        return this.situacao;
    }

    public void setSituacao(SituacaoDoPedido situacao) {
        this.situacao = situacao;
    }

    public Date getDataAtualizacaoPedido() {
        return this.dataAtualizacaoPedido;
    }

    public void setDataAtualizacaoPedido(Date dataAtualizacaoPedido) {
        this.dataAtualizacaoPedido = dataAtualizacaoPedido;
    }

    public String getFeedback() {
        return this.feedback;
    }

    public void setFeedback(String feedback) {
        this.feedback = feedback;
    }

    public Set<ItemDoPedido> getItensDoPedido() {
        return this.itensDoPedido;
    }

    public void setItensDoPedido(Set<ItemDoPedido> itensDoPedido) {
        this.itensDoPedido = itensDoPedido;
    }

    public BigDecimal getTotalItensPedido() {
        return this.totalItensPedido;
    }

    public void setTotalItensPedido(BigDecimal totalItensPedido) {
        this.totalItensPedido = totalItensPedido;
    }

    public CartaoDoCliente getCartaoDoCliente() {
        return this.cartaoDoCliente;
    }

    public void setCartaoDoCliente(CartaoDoCliente cartaoDoCliente) {
        this.cartaoDoCliente = cartaoDoCliente;
    }

    public Integer getClassificacao() {
        return this.classificacao;
    }

    public void setClassificacao(Integer classificacao) {
        this.classificacao = classificacao;
    }

    public String getSugestaoMelhoria() {
        return this.sugestaoMelhoria;
    }

    public void setSugestaoMelhoria(String sugestaoMelhoria) {
        this.sugestaoMelhoria = sugestaoMelhoria;
    }

    public Origem getOrigem() {
        return this.origem;
    }

    public void setOrigem(Origem origem) {
        this.origem = origem;
    }

    public String getRespostaFeedback() {
        return this.respostaFeedback;
    }

    public void setRespostaFeedback(String respostaFeedback) {
        this.respostaFeedback = respostaFeedback;
    }

    public Boolean getFeedbackUtil() {
        return this.feedbackUtil;
    }

    public void setFeedbackUtil(Boolean feedbackUtil) {
        this.feedbackUtil = feedbackUtil;
    }

    public Date getDataHoraAgendamento() {
        return this.dataHoraAgendamento;
    }

    public void setDataHoraAgendamento(Date dthrAgendamento) {
        this.dataHoraAgendamento = dthrAgendamento;
    }

    public BigDecimal getTotalDoPedido() {
        return this.totalDoPedido;
    }

    public void setTotalDoPedido(BigDecimal totalDoPedido) {
        this.totalDoPedido = totalDoPedido;
    }

    public String getNomeClienteMesa() {
        return this.nomeClienteMesa;
    }

    public void setNomeClienteMesa(String nomeClienteMesa) {
        this.nomeClienteMesa = nomeClienteMesa;
    }

    public Boolean getTeste() {
        return this.teste;
    }

    public void setTeste(Boolean teste) {
        this.teste = teste;
    }

    public Usuario getUsuarioCancelamento() {
        return this.usuarioCancelamento;
    }

    public void setUsuarioCancelamento(Usuario usuarioCancelamento) {
        this.usuarioCancelamento = usuarioCancelamento;
    }

    public Date getDataHoraCancelamento() {
        return this.dataHoraCancelamento;
    }

    public void setDataHoraCancelamento(Date dataHoraCancelamento) {
        this.dataHoraCancelamento = dataHoraCancelamento;
    }

    public BigDecimal getCreditoCashback() {
        return this.creditoCashback;
    }

    public void setCreditoCashback(BigDecimal creditoCashBack) {
        this.creditoCashback = creditoCashBack;
    }

    public BigDecimal getDebitoCashback() {
        return this.debitoCashback;
    }

    public void setDebitoCashback(BigDecimal debitoCashBack) {
        this.debitoCashback = debitoCashBack;
    }

    public Boolean getRodizio() {
        return this.rodizio;
    }

    public void setRodizio(Boolean possuiRodizio) {
        this.rodizio = possuiRodizio;
    }

    public Produto getProdutoDeRodizio() {
        return this.produtoDeRodizio;
    }

    public void setProdutoDeRodizio(Produto produtoDeRodizio) {
        this.produtoDeRodizio = produtoDeRodizio;
    }

    public Integer getQtdeRodizioCompleto() {
        return this.qtdeRodizioCompleto;
    }

    public void setQtdeRodizioCompleto(Integer qtdeRodizioCompleto) {
        this.qtdeRodizioCompleto = qtdeRodizioCompleto;
    }

    public Integer getQtdeMeioRodizio() {
        return this.qtdeMeioRodizio;
    }

    public void setQtdeMeioRodizio(Integer qtdeMeioRodizio) {
        this.qtdeMeioRodizio = qtdeMeioRodizio;
    }

    public BigDecimal getValorRodizioCompleto() {
        return this.valorRodizioCompleto;
    }

    public void setValorRodizioCompleto(BigDecimal valorRodizioCompleto) {
        this.valorRodizioCompleto = valorRodizioCompleto;
    }

    public BigDecimal getValorMeioRodizio() {
        return this.valorMeioRodizio;
    }

    public void setValorMeioRodizio(BigDecimal valorMeioRodizio) {
        this.valorMeioRodizio = valorMeioRodizio;
    }

    public Boolean getRodizioFechado() {
        return this.rodizioFechado;
    }

    public void setRodizioFechado(Boolean rodizioFechado) {
        this.rodizioFechado = rodizioFechado;
    }

    public Usuario getVendedor() {
        return this.vendedor;
    }

    public void setVendedor(Usuario vendedor) {
        this.vendedor = vendedor;
    }

    public String getDetalheDoPagamento() {
        return this.detalheDoPagamento;
    }

    public void setDetalheDoPagamento(String detalheDoPagamento) {
        this.detalheDoPagamento = detalheDoPagamento;
    }

    public String getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(String observacoes) {
        this.observacoes = observacoes;
    }

    public Boolean getComFrete() {
        return this.comFrete;
    }

    public void setComFrete(Boolean comFrete) {
        this.comFrete = comFrete;
    }

    public String getNomeDaEmpresaDoFrete() {
        return this.nomeDaEmpresaDoFrete;
    }

    public void setNomeDaEmpresaDoFrete(String nomeDaEmpresaDoFrete) {
        this.nomeDaEmpresaDoFrete = nomeDaEmpresaDoFrete;
    }

    public String getUrlDoLogoDaEmpresaDoFrete() {
        return this.urlDoLogoDaEmpresaDoFrete;
    }

    public void setUrlDoLogoDaEmpresaDoFrete(String urlDoLogoDaEmpresaDoFrete) {
        this.urlDoLogoDaEmpresaDoFrete = urlDoLogoDaEmpresaDoFrete;
    }

    public String getNomeDoServicoDoFrete() {
        return this.nomeDoServicoDoFrete;
    }

    public void setNomeDoServicoDoFrete(String nomeDoServicoDoFrete) {
        this.nomeDoServicoDoFrete = nomeDoServicoDoFrete;
    }

    public BigDecimal getValorDeDescontoDoFrete() {
        return this.valorDeDescontoDoFrete;
    }

    public void setValorDeDescontoDoFrete(BigDecimal valorDeDescontoDoFrete) {
        this.valorDeDescontoDoFrete = valorDeDescontoDoFrete;
    }

    public Integer getEstimativaDeEntrega() {
        return this.estimativaDeEntrega;
    }

    public void setEstimativaDeEntrega(Integer estimativaDeEntrega) {
        this.estimativaDeEntrega = estimativaDeEntrega;
    }

    public BigDecimal getTaxaDeComissao() {
        return this.taxaDeComissao;
    }

    public void setTaxaDeComissao(BigDecimal taxaDeComissao) {
        this.taxaDeComissao = taxaDeComissao;
    }

    public BigDecimal getTaxaAdicional() {
        return this.taxaAdicional;
    }

    public void setTaxaAdicional(BigDecimal taxaAdicional) {
        this.taxaAdicional = taxaAdicional;
    }

    public Boolean getPedidoExcedente() {
        return this.pedidoExcedente;
    }

    public void setPedidoExcedente(Boolean pedidoExcedente) {
        this.pedidoExcedente = pedidoExcedente;
    }

    public String getDescontoExterno() {
        return this.descontoExterno;
    }

    public void setDescontoExterno(String descontoExterno) {
        this.descontoExterno = descontoExterno;
    }

    public Boolean getClienteSemCadastro() {
        return this.clienteSemCadastro;
    }

    public void setClienteSemCadastro(Boolean clienteSemCadastro) {
        this.clienteSemCadastro = clienteSemCadastro;
    }

    public String getNomeClienteSemCadastro() {
        return this.nomeClienteSemCadastro;
    }

    public void setNomeClienteSemCadastro(String nomeClienteSemCadastro) {
        this.nomeClienteSemCadastro = nomeClienteSemCadastro;
    }

    public String getTelefoneClienteSemCadastro() {
        return this.telefoneClienteSemCadastro;
    }

    public void setTelefoneClienteSemCadastro(String telefoneClienteSemCadastro) {
        this.telefoneClienteSemCadastro = telefoneClienteSemCadastro;
    }

    public String getEnderecoDeEntregaClienteSemCadastro() {
        return this.enderecoDeEntregaClienteSemCadastro;
    }

    public void setEnderecoDeEntregaClienteSemCadastro(String enderecoDeEntregaClienteSemCadastro) {
        this.enderecoDeEntregaClienteSemCadastro = enderecoDeEntregaClienteSemCadastro;
    }

    public Boolean getImportado() {
        return this.importado;
    }

    public void setImportado(Boolean importado) {
        this.importado = importado;
    }

    public BigDecimal getValorDaParcela() {
        return this.valorDaParcela;
    }

    public void setValorDaParcela(BigDecimal valorDaParcela) {
        this.valorDaParcela = valorDaParcela;
    }

    public LojaDeOrigem getLojaDeOrigem() {
        return this.lojaDeOrigem;
    }

    public void setLojaDeOrigem(LojaDeOrigem lojaDeOrigem) {
        this.lojaDeOrigem = lojaDeOrigem;
    }

    public String getIdExterno() {
        return this.idExterno;
    }

    public void setIdExterno(String idExterno) {
        this.idExterno = idExterno;
    }

    public String getNomeClienteExterno() {
        return this.nomeClienteExterno;
    }

    public void setNomeClienteExterno(String nomeClienteExterno) {
        this.nomeClienteExterno = nomeClienteExterno;
    }

    public String getEnderecoEntregaExterno() {
        return this.enderecoEntregaExterno;
    }

    public void setEnderecoEntregaExterno(String enderecoEntregaExterno) {
        this.enderecoEntregaExterno = enderecoEntregaExterno;
    }

    public String getTelefoneClienteExterno() {
        return this.telefoneClienteExterno;
    }

    public void setTelefoneClienteExterno(String telefoneClienteExterno) {
        this.telefoneClienteExterno = telefoneClienteExterno;
    }

    public Set<CestaDePromocao> getCestasDePromocao() {
        return this.cestasDePromocao;
    }

    public void setCestasDePromocao(Set<CestaDePromocao> cestasDePromocao) {
        this.cestasDePromocao = cestasDePromocao;
    }

    public TarifacaoDeEntrega getTarifacaoEntrega() {
        return this.tarifacaoEntrega;
    }

    public void setTarifacaoEntrega(TarifacaoDeEntrega tarifacaoEntrega) {
        this.tarifacaoEntrega = tarifacaoEntrega;
    }

    public Integer getParcelas() {
        return this.parcelas;
    }

    public void setParcelas(Integer parcelas) {
        this.parcelas = parcelas;
    }

    public String getNomeUsuarioCancelamento() {
        return this.nomeUsuarioCancelamento;
    }

    public void setNomeUsuarioCancelamento(String nomeUsuarioCancelamento) {
        this.nomeUsuarioCancelamento = nomeUsuarioCancelamento;
    }

    public Long getCashbackId() {
        return this.cashbackId;
    }

    public void setCashbackId(Long cashbackId) {
        this.cashbackId = cashbackId;
    }

    public Long getCodigoDeConfirmacaoDePagamento() {
        return this.codigoDeConfirmacaoDePagamento;
    }

    public void setCodigoDeConfirmacaoDePagamento(Long codigoDeConfirmacaoDePagamento) {
        this.codigoDeConfirmacaoDePagamento = codigoDeConfirmacaoDePagamento;
    }
}

