/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.entity;

import com.escolpi.omni.api.enumeration.TipoDeExtratoDeCashback;
import com.escolpi.omni.api.model.entity.Cashback;
import com.escolpi.omni.api.model.entity.Pedido;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name="extratos_cashbacks")
@SequenceGenerator(name="extratos_cashbacks_gen", sequenceName="extratos_cashbacks_seq", initialValue=1, allocationSize=1)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ExtratoDeCashback
implements Serializable {
    private static final long serialVersionUID = -6656518375216855032L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="extratos_cashbacks_gen")
    @Column(name="id")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="cashback_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"empresa", "cliente"})
    private Cashback cashback;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pedido_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"cupomDeDesconto", "empresa", "taxaDeEntrega", "valorDescontoPagamentoEmDinheiro", "cliente", "enderecoEntrega", "opcaoPagamentoCartao", "dataHoraPedido", "formaEntrega", "formaPagamento", "valorTroco", "cpfCnpjNota", "mesa", "situacao", "dataAtualizacaoPedido", "feedback", "classificacao", "sugestaoMelhoria", "origem", "respostaFeedback", "feedbackUtil", "dataHoraAgendamento", "totalDoPedido", "nomeClienteMesa", "teste", "parcelas", "valorDaParcela", "lojaDeOrigem", "idExterno", "nomeClienteExterno", "enderecoEntregaExterno", "telefoneClienteExterno", "usuarioCancelamento", "dataHoraCancelamento", "creditoCashback", "debitoCashback", "rodizio", "produtoDeRodizio", "qtdeRodizioCompleto", "qtdeMeioRodizio", "valorRodizioCompleto", "valorMeioRodizio", "rodizioFechado", "vendedor", "detalheDoPagamento", "observacoes", "comFrete", "nomeDaEmpresaDoFrete", "urlDoLogoDaEmpresaDoFrete", "nomeDoServicoDoFrete", "valorDeDescontoDoFrete", "estimativaDeEntrega", "taxaDeComissao", "taxaAdicional", "pedidoExcedente", "descontoExterno", "clienteSemCadastro", "nomeClienteSemCadastro", "telefoneClienteSemCadastro", "enderecoDeEntregaClienteSemCadastro"})
    private Pedido pedido;
    @Column(name="tipo_lancamento")
    private TipoDeExtratoDeCashback tipoDeLancamento;
    @Column(name="descricao")
    private String descricao;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="dthr_lancamento")
    private Date dataHoraDoLancamento;
    @Column(name="valor")
    private BigDecimal valor;

    public ExtratoDeCashback() {
    }

    public ExtratoDeCashback(Cashback cashback) {
        this.cashback = cashback;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Cashback getCashback() {
        return this.cashback;
    }

    public void setCashback(Cashback cashback) {
        this.cashback = cashback;
    }

    public Pedido getPedido() {
        return this.pedido;
    }

    public void setPedido(Pedido pedido) {
        this.pedido = pedido;
    }

    public TipoDeExtratoDeCashback getTipoDeLancamento() {
        return this.tipoDeLancamento;
    }

    public void setTipoDeLancamento(TipoDeExtratoDeCashback tipoDeLancamento) {
        this.tipoDeLancamento = tipoDeLancamento;
    }

    public String getDescricao() {
        return this.descricao;
    }

    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    public Date getDataHoraDoLancamento() {
        return this.dataHoraDoLancamento;
    }

    public void setDataHoraDoLancamento(Date dataHoraDoLancamento) {
        this.dataHoraDoLancamento = dataHoraDoLancamento;
    }

    public BigDecimal getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }
}

