/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.entity;

import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.Plano;
import com.escolpi.omni.api.model.entity.dto.CartaoDeCredito;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name="contratacoes")
@SequenceGenerator(name="contratacoes_gen", sequenceName="contratacoes_seq", initialValue=1, allocationSize=1)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Contratacao
implements Serializable {
    private static final long serialVersionUID = -4587828552403616322L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="contratacoes_gen")
    @Column(name="id")
    private Long id;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="empresa_id")
    @JsonIgnoreProperties(value={"matriz", "municipio", "segmento", "usuario", "razaoSocial", "cnpj", "logotipo", "logotipoStore", "planoDeFundoStore", "nomeAbreviado", "telefonePrincipal", "telefoneSecundario", "urlSite", "cep", "logradouro", "numero", "complemento", "bairro", "contato", "emailContato", "fcmTokenServidor", "tempoDeEntrega", "tempoDeRetirada", "urlFacebook", "urlInstagram", "urlTwitter", "urlYoutube", "indWhatsapp", "urlAppAndroid", "urlAppIos", "urlStore", "versao", "versaoAndroid", "valorIsencaoEntrega", "aberto", "versaoIOS", "sobre", "aceitaPedidosAuto", "aceitaComandasAuto", "valorTarifaUnica", "dataDeCadastro", "dataInicioDeUtilizacao", "fusoHorario", "imprimePedidosAuto", "emailPagSeguro", "tokenPagSeguro", "ativo", "parcelaMinima", "maximoDeParcelas", "tokenFcm", "idStore", "quantidadeImpressoes", "fazDelivery", "fazRetirada", "imprimePedidosDistribuidosAuto", "emTeste", "valorMinimoParaEntrega", "latitude", "longitude", "facebookPixelId", "porcentagemDoCashback", "versaoVendas", "versaoVendasAndroid", "versaoVendasIos", "valorPlano", "limitePedidos", "valorPedidoExcedente", "diaVencimentoMensalidade", "porcentagemOutraPlataforma", "porcentagemDeComissao", "plano", "receberInformativos", "endereco"})
    private Empresa empresa;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="plano_id", referencedColumnName="id")
    private Plano plano;
    @Column(name="qtde_parcelas")
    private Integer parcelas;
    @Column(name="valor_parcela")
    private BigDecimal valorDaParcela;
    @Column(name="valor_contratado")
    private BigDecimal valorContratado;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="dthr_inicio_contrato")
    private Date inicioDoContrato;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="dthr_fim_contrato")
    private Date fimDoContrato;
    @Transient
    private CartaoDeCredito cartaoDaEmpresa;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Empresa getEmpresa() {
        return this.empresa;
    }

    public void setEmpresa(Empresa empresa) {
        this.empresa = empresa;
    }

    public Plano getPlano() {
        return this.plano;
    }

    public void setPlano(Plano plano) {
        this.plano = plano;
    }

    public Integer getParcelas() {
        return this.parcelas;
    }

    public void setParcelas(Integer parcelas) {
        this.parcelas = parcelas;
    }

    public BigDecimal getValorDaParcela() {
        return this.valorDaParcela;
    }

    public void setValorDaParcela(BigDecimal valorDaParcela) {
        this.valorDaParcela = valorDaParcela;
    }

    public BigDecimal getValorContratado() {
        return this.valorContratado;
    }

    public void setValorContratado(BigDecimal valorContratado) {
        this.valorContratado = valorContratado;
    }

    public Date getInicioDoContrato() {
        return this.inicioDoContrato;
    }

    public void setInicioDoContrato(Date inicioDoContrato) {
        this.inicioDoContrato = inicioDoContrato;
    }

    public Date getFimDoContrato() {
        return this.fimDoContrato;
    }

    public void setFimDoContrato(Date fimDoContrato) {
        this.fimDoContrato = fimDoContrato;
    }

    public CartaoDeCredito getCartaoDaEmpresa() {
        return this.cartaoDaEmpresa;
    }

    public void setCartaoDaEmpresa(CartaoDeCredito cartaoDaEmpresa) {
        this.cartaoDaEmpresa = cartaoDaEmpresa;
    }
}

