/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.entity;

import com.escolpi.omni.api.model.entity.ItemDoPedidoPorPromocao;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.model.entity.Promocao;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;

@Entity
@Table(name="cestas_promocoes")
@SequenceGenerator(name="cestas_promocoes_gen", sequenceName="cestas_promocoes_seq", initialValue=1, allocationSize=1)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CestaDePromocao
implements Serializable {
    private static final long serialVersionUID = 5489847120178314069L;
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="cestas_promocoes_gen")
    @Column(name="id")
    private Long id;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pedido_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"cupomDeDesconto", "empresa", "taxaDeEntrega", "valorDescontoPagamentoEmDinheiro", "cliente", "enderecoEntrega", "opcaoPagamentoCartao", "dataHoraPedido", "formaEntrega", "formaPagamento", "valorTroco", "cpfCnpjNota", "mesa", "situacao", "dataAtualizacaoPedido", "feedback", "classificacao", "sugestaoMelhoria", "origem", "respostaFeedback", "feedbackUtil", "dataHoraAgendamento", "totalDoPedido", "nomeClienteMesa", "teste", "parcelas", "valorDaParcela", "lojaDeOrigem", "idExterno", "nomeClienteExterno", "enderecoEntregaExterno", "telefoneClienteExterno", "usuarioCancelamento", "dataHoraCancelamento", "creditoCashback", "debitoCashback", "rodizio", "produtoDeRodizio", "qtdeRodizioCompleto", "qtdeMeioRodizio", "valorRodizioCompleto", "valorMeioRodizio", "rodizioFechado", "vendedor", "detalheDoPagamento", "observacoes", "comFrete", "nomeDaEmpresaDoFrete", "urlDoLogoDaEmpresaDoFrete", "nomeDoServicoDoFrete", "valorDeDescontoDoFrete", "estimativaDeEntrega", "taxaDeComissao", "taxaAdicional", "pedidoExcedente", "descontoExterno", "clienteSemCadastro", "nomeClienteSemCadastro", "telefoneClienteSemCadastro", "enderecoDeEntregaClienteSemCadastro"})
    private Pedido pedido;
    @OneToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="promocao_id", referencedColumnName="id")
    @JsonIgnoreProperties(value={"empresa", "caminhoFoto", "dtInicioValidade", "dtFimValidade", "aceitaCupomDeDesconto", "ativo", "excluida", "disponibilidades", "regrasDeCompra", "foto"})
    private Promocao promocao;
    @Column(name="quantidade")
    private Integer quantidade;
    @Column(name="valor")
    private BigDecimal valor;
    @Column(name="observacoes")
    private String observacoes;
    @OneToMany(mappedBy="cesta", fetch=FetchType.LAZY)
    @OrderBy(value="id DESC")
    Set<ItemDoPedidoPorPromocao> itens;

    public CestaDePromocao(Long id) {
        this.id = id;
    }

    public CestaDePromocao() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Pedido getPedido() {
        return this.pedido;
    }

    public void setPedido(Pedido pedido) {
        this.pedido = pedido;
    }

    public Promocao getPromocao() {
        return this.promocao;
    }

    public void setPromocao(Promocao promocao) {
        this.promocao = promocao;
    }

    public Integer getQuantidade() {
        return this.quantidade;
    }

    public void setQuantidade(Integer quantidade) {
        this.quantidade = quantidade;
    }

    public BigDecimal getValor() {
        return this.valor;
    }

    public void setValor(BigDecimal valor) {
        this.valor = valor;
    }

    public String getObservacoes() {
        return this.observacoes;
    }

    public void setObservacoes(String observacoes) {
        this.observacoes = observacoes;
    }

    public Set<ItemDoPedidoPorPromocao> getItens() {
        return this.itens;
    }

    public void setItens(Set<ItemDoPedidoPorPromocao> itens) {
        this.itens = itens;
    }
}

