/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.config;

import java.util.concurrent.Executor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@EnableAsync
public class AsyncConfig {
    public static final int ASYNC_TIMEOUT = 3;

    @Bean(name={"notifyCustomerScrapExecutor"})
    Executor getCustomerScrapAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setAwaitTerminationSeconds(3);
        executor.setKeepAliveSeconds(3);
        executor.setMaxPoolSize(20);
        executor.initialize();
        return executor;
    }

    @Bean(name={"orderExecutor"})
    Executor orderExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setCorePoolSize(2);
        executor.setMaxPoolSize(2);
        executor.setQueueCapacity(100);
        executor.setThreadNamePrefix("OrderThread-");
        executor.initialize();
        return executor;
    }

    @Bean(name={"notifyOrderExecutor"})
    Executor getNotifyOrderUpdateAsyncExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setAwaitTerminationSeconds(3);
        executor.setKeepAliveSeconds(3);
        executor.setMaxPoolSize(100);
        executor.initialize();
        return executor;
    }

    @Bean(name={"messengerExecutor"})
    Executor messengerExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setAwaitTerminationSeconds(3);
        executor.setKeepAliveSeconds(3);
        executor.setMaxPoolSize(100);
        executor.initialize();
        return executor;
    }
}

