/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.util;

import com.escolpi.omni.api.domain.Message;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);

    public static byte[] decodeBase64(String base64File) {
        String encoded = base64File.substring(base64File.lastIndexOf("base64,") + 7, base64File.length());
        return Base64.getDecoder().decode(encoded);
    }

    public static void deleteDirectory(String path) throws IOException, ApiException {
        Path dirPath = Paths.get(path, new String[0]);
        if (!Files.exists(dirPath, new LinkOption[0])) {
            throw new ApiException("erro.api.padrao", new String[]{"O arquivo do caminho " + path + " n\u00e3o foi encontrado."});
        }
        Files.walk(dirPath, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
    }

    public static void deleteAllFiles(String path) throws ApiException {
        Path filePath = Paths.get(path, new String[0]);
        if (!Files.exists(filePath, new LinkOption[0])) {
            throw new ApiException("erro.api.padrao", new String[]{"O arquivo do caminho " + path + " n\u00e3o foi encontrado."});
        }
        List<File> files = Arrays.asList(filePath.toFile().listFiles());
        if (files.size() == 0) {
            return;
        }
        files.forEach(file -> file.delete());
    }

    public static void deleteFile(String path) throws ApiException {
        Path filePath = Paths.get(path, new String[0]);
        if (Files.exists(filePath, new LinkOption[0])) {
            try {
                System.gc();
                Files.delete(filePath);
            }
            catch (IOException e) {
                throw new ApiException("erro.api.padrao", new String[]{"O arquivo do caminho " + path + " n\u00e3o foi exclu\u00eddo: " + e.getMessage()});
            }
        }
    }

    public static String encodeToBase64(File file) throws ApiException {
        try {
            if (file == null) {
                return null;
            }
            FileInputStream stream = new FileInputStream(file);
            byte[] encodedBytes = Base64.getEncoder().encode(IOUtils.toByteArray((InputStream)stream));
            String ext = StringUtil.obterExtensao((String)file.getName());
            ext = ext.substring(1, ext.length()).toLowerCase();
            return "data:image/" + ext + ";base64," + new String(encodedBytes, "UTF-8");
        }
        catch (Exception e) {
            LOGGER.warn(Message.getInstance().getMessage("erro.api.padrao", new String[]{" ao obter arquivo codificado: " + e.getMessage()}));
            return null;
        }
    }

    public static boolean fileExists(String path) {
        return Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    public static Path getDir(String path) {
        Path currPath = Paths.get(path, new String[0]);
        if (NullUtil.isNull((Object)currPath)) {
            return null;
        }
        return Files.exists(currPath, new LinkOption[0]) ? currPath : null;
    }

    public static File getFile(String path) {
        File file = FileUtil.getDir((String)path).toFile();
        if (!file.isDirectory()) {
            return FileUtil.getDir((String)path).toFile();
        }
        return null;
    }

    public static Path makeDir(String path) {
        Path newPath = Paths.get(path, new String[0]);
        try {
            Files.createDirectory(newPath, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            LOGGER.warn(Message.getInstance().getMessage("erro.diretorio.existe"));
        }
        catch (IOException e) {
            LOGGER.error(Message.getInstance().getMessage("erro.api.padrao", new String[]{e.getMessage()}));
        }
        return newPath;
    }
}

