/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.EmpresaEntity;
import com.escolpi.omni.api.model.entity.TokenTemporario;
import com.escolpi.omni.api.repository.TokenTemporarioRepository;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.NullUtil;
import java.util.Date;
import java.util.Optional;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TokenTemporarioService {
    @Autowired
    private TokenTemporarioRepository repository;

    @Transactional
    public void delete(Long id) {
        this.repository.deleteById((Object)id);
    }

    public Optional<TokenTemporario> find(Long companyId, String token) throws ApiException {
        return this.repository.findByEmpresaIdAndToken(companyId, token);
    }

    public Optional<TokenTemporario> findByCompanyId(Long companyId) throws ApiException {
        return this.repository.findByEmpresaId(companyId);
    }

    @Transactional
    public TokenTemporario generateToken(Long companyId, String token) throws ApiException {
        Date now = new Date();
        Optional tokenOptional = this.findByCompanyId(companyId);
        if (tokenOptional.isPresent()) {
            TokenTemporario edit = (TokenTemporario)tokenOptional.get();
            edit.setToken(token);
            edit.setDataCriacao(now);
            edit.setExpiraEm(DateUtil.addMinutes((Date)now, (int)5));
            return (TokenTemporario)this.repository.save((Object)edit);
        }
        TokenTemporario newToken = new TokenTemporario();
        newToken.setEmpresa(new EmpresaEntity(companyId));
        newToken.setToken(token);
        newToken.setDataCriacao(now);
        newToken.setExpiraEm(DateUtil.addMinutes((Date)now, (int)5));
        return (TokenTemporario)this.repository.save((Object)newToken);
    }

    public void validateToken(TokenTemporario secureToken, String receivedToken) throws ApiException {
        if (NullUtil.isNull((Object)receivedToken)) {
            throw new ApiException("erro.token", new String[]{"n\u00e3o informado"});
        }
        if (!receivedToken.equals(secureToken.getToken())) {
            throw new ApiException("erro.token", new String[]{"inv\u00e1lido"});
        }
        if (!DateUtil.pertenceAoPeriodoComHoras((Date)new Date(), (Date)secureToken.getDataCriacao(), (Date)secureToken.getExpiraEm()).booleanValue()) {
            throw new ApiException("erro.token", new String[]{"expirado"});
        }
    }
}

