/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Personalizacao;
import com.escolpi.omni.api.model.entity.ValorDaPersonalizacao;
import com.escolpi.omni.api.model.projection.AutocompleteView;
import com.escolpi.omni.api.model.specification.builder.PersonalizacaoSpecificationBuilder;
import com.escolpi.omni.api.repository.PersonalizacaoRepository;
import com.escolpi.omni.api.repository.ValorDaPersonalizacaoRepository;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PersonalizacaoService
implements BaseCrudService<Personalizacao, Long> {
    @Autowired
    private PersonalizacaoRepository repository;
    @Autowired
    private ValorDaPersonalizacaoRepository valorRepository;

    public boolean customizationByCategoryHasSubProduct(Long categoryId) {
        return this.repository.countByCategoriaIdAndSubProdutoIsTrue(categoryId) > 0;
    }

    @Transactional
    public void delete(Long id) throws ApiException {
        Personalizacao delete = this.findById(id);
        delete.getValoresDaPersonalizacao().forEach(valor -> valor.setExcluido(Boolean.TRUE));
        delete.setExcluido(Boolean.valueOf(delete.getExcluido() == false));
        this.repository.save((Object)delete);
        List customizations = this.repository.findByProximaPersonalizacaoIdAndExcluidoIsFalse(delete.getId());
        customizations.forEach(customization -> {
            customization.setProximaPersonalizacaoId(null);
            this.repository.save(customization);
        });
    }

    public Page<Personalizacao> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) {
        PersonalizacaoSpecificationBuilder builder = new PersonalizacaoSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        Page datasource = this.repository.findAll(spec, (Pageable)pageable);
        datasource.getContent().forEach(personalizacao -> personalizacao.setProximaPersonalizacao(this.getNextCustomization(personalizacao)));
        return datasource;
    }

    public List<Personalizacao> findAll(Long empresaId) {
        List personalizacoes = this.repository.findByCategoriaEmpresaId(empresaId);
        personalizacoes.forEach(personalizacao -> personalizacao.setProximaPersonalizacao(this.getNextCustomization(personalizacao)));
        return personalizacoes;
    }

    public Personalizacao findById(Long id) throws ApiException {
        Personalizacao personalizacao = (Personalizacao)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Personaliza\u00e7\u00e3o", id.toString()}));
        personalizacao.setValoresDaPersonalizacao(new HashSet());
        personalizacao.setProximaPersonalizacao(this.getNextCustomization(personalizacao));
        List valores = this.valorRepository.findByPersonalizacaoIdAndExcluidoIsFalseOrderByDescricaoAsc(personalizacao.getId());
        valores.stream().filter(valor -> valor.getExcluido() == false).forEach(valor -> personalizacao.getValoresDaPersonalizacao().add(valor));
        return personalizacao;
    }

    public Personalizacao findById(Long id, Long empresaId) throws ApiException {
        Personalizacao personalizacao = (Personalizacao)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Personaliza\u00e7\u00e3o", id.toString()}));
        personalizacao.setProximaPersonalizacao(this.getNextCustomization(personalizacao));
        HashSet valores = new HashSet();
        personalizacao.getValoresDaPersonalizacao().stream().filter(valor -> valor.getExcluido() == false).forEach(valor -> valores.add(valor));
        personalizacao.setValoresDaPersonalizacao(valores);
        return personalizacao;
    }

    @Transactional
    public void save(Personalizacao customization) throws ApiException {
        this.validate(customization);
        if (NullUtil.isNotNullOrZero((Number)customization.getId())) {
            Personalizacao edit = this.populateCustomization(customization);
            this.repository.save((Object)edit);
            edit.setValoresDaPersonalizacao(customization.getValoresDaPersonalizacao());
            this.saveCustomizationValues(edit);
        } else {
            this.repository.save((Object)customization);
            this.saveCustomizationValues(customization);
        }
    }

    public List<AutocompleteView> searchByAutocomplete(Long empresaId, Long categoriaId, String descricao) throws ApiException {
        return this.repository.findByAutocomplete(empresaId, categoriaId, descricao);
    }

    public void validate(Personalizacao entity) throws ApiException {
        if (StringUtil.isBlank((String)entity.getDescricao())) {
            throw new ApiException("msg.erro.001", new String[]{"Descri\u00e7\u00e3o"});
        }
        if (NullUtil.isNull((Object)entity.getCategoria()) || NullUtil.isNullOrZero((Number)entity.getCategoria().getId())) {
            throw new ApiException("msg.erro.001", new String[]{"Categoria"});
        }
        if (NullUtil.isNull((Object)entity.getMultiOpcional())) {
            throw new ApiException("msg.erro.001", new String[]{"Permite Selecionar mais de uma op\u00e7\u00e3o"});
        }
        if (NullUtil.isNull((Object)entity.getSubProduto())) {
            throw new ApiException("msg.erro.001", new String[]{"\u00c9 uma personaliza\u00e7\u00e3o de produtos?"});
        }
        if (NullUtil.isNull((Object)entity.getExcluido())) {
            throw new ApiException("msg.erro.001", new String[]{"Exclu\u00eddo"});
        }
        if (NullUtil.isNotNullOrZero((Number)entity.getId())) {
            if (NullUtil.isNotNullOrZero((Number)entity.getProximaPersonalizacaoId()) && entity.getId().equals(entity.getProximaPersonalizacaoId())) {
                throw new ApiException("msg.erro.105");
            }
        } else if ((long)this.repository.countByCategoriaIdAndDescricaoIgnoreCaseAndExcluidoIsFalse(entity.getCategoria().getId(), entity.getDescricao()) > 0L) {
            throw new ApiException("erro.entidade.existente.f", new String[]{"Personaliza\u00e7\u00e3o"});
        }
        if (CollectionUtils.isEmpty((Collection)entity.getValoresDaPersonalizacao())) {
            throw new ApiException(entity.getMultiOpcional() == false ? "msg.erro.042" : "msg.erro.041");
        }
        if (!entity.getMultiOpcional().booleanValue() && !entity.getSubProdutoFracionado().booleanValue() && CollectionUtils.isEmpty((Collection)entity.getValoresDaPersonalizacao())) {
            throw new ApiException("msg.erro.042");
        }
        for (ValorDaPersonalizacao valor : entity.getValoresDaPersonalizacao()) {
            if (entity.getSubProduto().booleanValue()) {
                if (NullUtil.isNull((Object)valor.getEmFalta())) {
                    valor.setEmFalta(Boolean.valueOf(false));
                }
                if (!NullUtil.isNull((Object)valor.getProduto()) && !NullUtil.isNullOrZero((Number)valor.getProduto().getId())) continue;
                throw new ApiException("msg.erro.001", new String[]{"Produto"});
            }
            if (StringUtil.isBlank((String)valor.getDescricao())) {
                throw new ApiException("msg.erro.001", new String[]{"Descri\u00e7\u00e3o"});
            }
            if (entity.getSubProdutoFracionado().booleanValue() || !NullUtil.isNull((Object)valor.getValor())) continue;
            throw new ApiException("msg.erro.001", new String[]{"Valor"});
        }
    }

    private Personalizacao getNextCustomization(Personalizacao personalizacao) {
        Personalizacao proximaPersonalizacao = null;
        if (NullUtil.isNotNullOrZero((Number)personalizacao.getProximaPersonalizacaoId())) {
            proximaPersonalizacao = this.repository.findById((Object)personalizacao.getProximaPersonalizacaoId()).orElse(null);
        }
        return proximaPersonalizacao;
    }

    private Personalizacao populateCustomization(Personalizacao customization) throws ApiException {
        Personalizacao edit = (Personalizacao)this.repository.findById((Object)customization.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Personaliza\u00e7\u00e3o", customization.getId().toString()}));
        edit.setDescricao(customization.getDescricao());
        edit.setCategoria(customization.getCategoria());
        edit.setProximaPersonalizacaoId(NullUtil.isNotNull((Object)customization.getProximaPersonalizacaoId()) ? customization.getProximaPersonalizacaoId() : null);
        edit.setMultiOpcional(customization.getMultiOpcional());
        edit.setSubProduto(customization.getSubProduto());
        edit.setSubProdutoFracionado(customization.getSubProdutoFracionado());
        edit.setQuantidadePermitida(customization.getQuantidadePermitida());
        edit.setQuantidadeMinimaPermitida(customization.getQuantidadeMinimaPermitida());
        edit.setExcluido(NullUtil.isNotNull((Object)customization.getExcluido()) ? customization.getExcluido() : Boolean.FALSE);
        edit.setObrigatoria(NullUtil.isNotNull((Object)customization.getObrigatoria()) ? customization.getObrigatoria() : Boolean.FALSE);
        edit.setQuantitativa(Boolean.valueOf(NullUtil.isNotNull((Object)customization.getQuantitativa()) ? customization.getQuantitativa() : false));
        edit.setQuantidadeMinima(customization.getQuantidadeMinima());
        edit.setQuantidadeMaxima(customization.getQuantidadeMaxima());
        edit.setQuantidadeMaximaDeOpcoes(customization.getQuantidadeMaximaDeOpcoes());
        return edit;
    }

    @Transactional
    private void saveCustomizationValues(Personalizacao customization) {
        List currentValues = this.valorRepository.findByPersonalizacaoIdAndExcluidoIsFalseOrderByDescricaoAsc(customization.getId()).stream().map(value -> value.getId()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(currentValues)) {
            customization.getValoresDaPersonalizacao().forEach(value -> {
                value.setPersonalizacao(customization);
                this.valorRepository.save(value);
            });
        } else {
            Set<Object> removeEntries = new HashSet();
            Set ids = customization.getValoresDaPersonalizacao().stream().filter(value -> NullUtil.isNotNullOrZero((Number)value.getId())).map(value -> value.getId()).collect(Collectors.toSet());
            removeEntries = currentValues.stream().filter(id -> !ids.contains(id)).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(removeEntries)) {
                removeEntries.forEach(valueId -> {
                    ValorDaPersonalizacao value = (ValorDaPersonalizacao)this.valorRepository.findById(valueId).get();
                    value.setExcluido(Boolean.valueOf(true));
                    this.valorRepository.save((Object)value);
                });
            }
            customization.getValoresDaPersonalizacao().forEach(value -> {
                if (NullUtil.isNull((Object)value.getPersonalizacao()) || NullUtil.isNull((Object)value.getPersonalizacao().getId())) {
                    value.setPersonalizacao(customization);
                    value.setExcluido(Boolean.valueOf(false));
                }
                this.valorRepository.save(value);
            });
        }
    }
}

