/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.util.NumberUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class GoogleMapsService {
    @Autowired
    private EmpresaRepository companyRepository;
    public static final long EARTH_RADIUS = 6371L;

    public double getDistanceFromAddressCordinates(Long companyId, String address) throws ApiException {
        Empresa company = (Empresa)this.companyRepository.findById((Object)companyId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", companyId.toString()}));
        String url = String.format("https://maps.googleapis.com/maps/api/geocode/json?address=%s&key=%s", address, "AIzaSyC-RNeDiv9-CfMnmmQRummyrM-OMF_LLSY");
        RestTemplate restTemplate = new RestTemplate();
        MultiValueMap headers = this.getGoogleMapsApiHeaders();
        HttpEntity request = new HttpEntity(headers);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.GET, request, String.class, (Map)headers);
        ObjectMapper mapper = new ObjectMapper();
        try {
            JsonNode responseBody = mapper.readTree((String)response.getBody());
            if (!responseBody.get("status").asText().equals("OK")) {
                throw new ApiException("erro.googlemaps");
            }
            JsonNode mapsData = responseBody.get("results");
            Iterator iterator = responseBody.get("results").iterator();
            if (iterator.hasNext()) {
                JsonNode jsonNode;
                mapsData = jsonNode = (JsonNode)iterator.next();
            }
            double latitude = mapsData.path("geometry").get("location").get("lat").asDouble();
            double longitude = mapsData.path("geometry").get("location").get("lng").asDouble();
            return this.calculateAndGetDistance(latitude, longitude, Double.valueOf(company.getLatitude()).doubleValue(), Double.valueOf(company.getLongitude()).doubleValue(), "spherical");
        }
        catch (IOException e) {
            throw new ApiException("erro.googlemaps", new String[]{e.getMessage()});
        }
    }

    private double calculateAndGetDistance(double customerLatitude, double customerLongitude, double companyLatitude, double companyLongitude, String algorithm) {
        double distance = 0.0;
        double distLongitude = 0.0;
        double dLatitude = 0.0;
        if (algorithm.equals("haversine")) {
            dLatitude = NumberUtil.parseDegreesToRad((Double)(companyLatitude - customerLatitude));
            distLongitude = NumberUtil.parseDegreesToRad((Double)(companyLongitude - customerLongitude));
            customerLatitude = NumberUtil.parseDegreesToRad((Double)customerLatitude);
            companyLatitude = NumberUtil.parseDegreesToRad((Double)companyLatitude);
            double a = Math.sin(dLatitude / 2.0) * Math.sin(dLatitude / 2.0) + Math.sin(distLongitude / 2.0) * Math.sin(distLongitude / 2.0) * Math.cos(customerLatitude) * Math.cos(companyLatitude);
            Double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
            distance = 6371.0 * c;
        } else if (algorithm.equals("rectangle")) {
            double x = NumberUtil.parseDegreesToRad((Double)(companyLongitude - customerLongitude)) * Math.cos(NumberUtil.parseDegreesToRad((Double)(customerLatitude + companyLatitude)) / 2.0);
            double y = NumberUtil.parseDegreesToRad((Double)(companyLatitude - customerLatitude));
            distance = Math.sqrt(x * x + y * y) * 6371.0;
        } else if (algorithm.equals("spherical")) {
            distLongitude = NumberUtil.parseDegreesToRad((Double)(companyLongitude - customerLongitude));
            customerLatitude = NumberUtil.parseDegreesToRad((Double)customerLatitude);
            companyLatitude = NumberUtil.parseDegreesToRad((Double)companyLatitude);
            distance = Math.acos(Math.sin(customerLatitude) * Math.sin(companyLatitude) + Math.cos(customerLatitude) * Math.cos(companyLatitude) * Math.cos(distLongitude)) * 6371.0;
        }
        return NumberUtil.round((double)distance, (int)3);
    }

    private MultiValueMap<String, String> getGoogleMapsApiHeaders() {
        LinkedMultiValueMap headers = new LinkedMultiValueMap();
        headers.add((Object)"Content-Type", (Object)"application/json");
        return headers;
    }
}

