/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.domain.Domains;
import com.escolpi.omni.api.enumeration.ControleEstoque;
import com.escolpi.omni.api.enumeration.FuncaoCartao;
import com.escolpi.omni.api.enumeration.FusoHorario;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CategoriaDoProduto;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.EmpresaConfiguracao;
import com.escolpi.omni.api.model.entity.EmpresaProdutoEmDestaque;
import com.escolpi.omni.api.model.entity.OpcaoDePagamentoComCartao;
import com.escolpi.omni.api.model.entity.Perfil;
import com.escolpi.omni.api.model.entity.PreCadastroDaEmpresa;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.model.entity.Usuario;
import com.escolpi.omni.api.model.entity.id.EmpresaId;
import com.escolpi.omni.api.repository.CategoriaDoProdutoRepository;
import com.escolpi.omni.api.repository.ConfiguracaoRepository;
import com.escolpi.omni.api.repository.EmpresaConfiguracaoRepository;
import com.escolpi.omni.api.repository.EmpresaProdutoEmDestaqueRepository;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.repository.OpcaoDePagamentoComCartaoRepository;
import com.escolpi.omni.api.repository.PerfilRepository;
import com.escolpi.omni.api.repository.UsuarioRepository;
import com.escolpi.omni.api.service.EmblemaService;
import com.escolpi.omni.api.service.EmpresaProdutoEmDestaqueService;
import com.escolpi.omni.api.service.EmpresaService;
import com.escolpi.omni.api.service.FileService;
import com.escolpi.omni.api.service.MunicipioService;
import com.escolpi.omni.api.service.PlanoService;
import com.escolpi.omni.api.service.ProdutoService;
import com.escolpi.omni.api.service.SegmentoService;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;

@Service
public class FactoryService {
    private static final String DEFAULT_LOGO_STORE_NAME = "logo-store.png";
    private static final String DEFAULT_LOGO_NAME = "logo.jpg";
    private static final String DEFAULT_LATITUDE = "-22.98533739183495";
    private final String DEFAULT_LONGITUDE = "-49.86687138649489";
    @Autowired
    private BCryptPasswordEncoder encoder;
    @Autowired
    private CategoriaDoProdutoRepository categoryRepository;
    @Autowired
    private EmpresaRepository companyRepository;
    @Autowired
    private ConfiguracaoRepository configRepository;
    @Autowired
    private EmpresaConfiguracaoRepository companyConfigRepository;
    @Autowired
    private EmpresaProdutoEmDestaqueRepository spotlightProductRepository;
    @Autowired
    private EmpresaProdutoEmDestaqueService spotlightProductService;
    @Autowired
    private OpcaoDePagamentoComCartaoRepository paymentOptionRepository;
    @Autowired
    private PerfilRepository profileRepository;
    @Autowired
    private UsuarioRepository userRepository;
    @Autowired
    private MunicipioService cityService;
    @Autowired
    private EmpresaService companyService;
    @Autowired
    private EmblemaService emblemService;
    @Autowired
    private FileService fileService;
    @Autowired
    private PlanoService planService;
    @Autowired
    private ProdutoService productService;
    @Autowired
    private SegmentoService segmentService;

    @Transactional
    public Empresa buildCompany(PreCadastroDaEmpresa preRegistration) throws ApiException, IOException {
        Empresa company = new Empresa();
        company.setContato(preRegistration.getContato());
        company.setEmailContato(preRegistration.getEmailContato());
        company.setTelefonePrincipal(preRegistration.getTelefoneContato());
        company.setPlano(this.planService.findById(preRegistration.getPlano().getId()));
        company.setCnpj(StringUtil.removerMascara((String)preRegistration.getCnpjCpf()));
        company.setNomeFantasia(preRegistration.getNomeFantasia());
        company.setNomeAbreviado(preRegistration.getNomeAbreviado());
        company.setSegmento(this.segmentService.findById(preRegistration.getSegmento().getId()));
        company.setCep(StringUtil.removerMascara((String)preRegistration.getCep()));
        company.setLogradouro(preRegistration.getLogradouro());
        company.setMunicipio(this.cityService.findByIbgeId(preRegistration.getMunicipio().getIbgeId()));
        company.setNumero(preRegistration.getNumero());
        company.setBairro(preRegistration.getBairro());
        company.setComplemento(preRegistration.getComplemento());
        company.setConfirmacaoSenha(preRegistration.getSenha());
        company.setUsuario(this.buildCompanyUser(preRegistration));
        company.setReceberInformativos(preRegistration.getReceberInformativos());
        company.setAtivo(Boolean.valueOf(true));
        this.setCompanyDefaultSettings(company);
        this.companyRepository.save((Object)company);
        this.buildCompanyStore(company);
        this.setCompanySettings(company);
        return company;
    }

    @Transactional
    private void setCompanySettings(Empresa company) {
        List settings = this.configRepository.findAll();
        settings.forEach(config -> {
            EmpresaConfiguracao companySetting = new EmpresaConfiguracao();
            companySetting.setEmpresa(company);
            companySetting.setConfiguracao(config);
            this.companyConfigRepository.save((Object)companySetting);
        });
    }

    @Transactional
    private void buildCompanyStore(Empresa company) throws ApiException, IOException {
        this.createCompanyFolder(company.getId());
        String galeryPath = "galeria" + File.separator + "produtos";
        String spotlightPath = "galeria" + File.separator + "destaques";
        String productImagePath = this.fileService.getCompanyPath(company.getId().toString(), galeryPath, Boolean.valueOf(false));
        String spotlightImagePath = this.fileService.getCompanyPath(company.getId().toString(), spotlightPath, Boolean.valueOf(false));
        int totalItemsPerComponent = 3;
        for (int companyCounter = 1; companyCounter <= totalItemsPerComponent; ++companyCounter) {
            CategoriaDoProduto category = new CategoriaDoProduto();
            category.setEmpresa(new EmpresaId(company.getId()));
            category.setDescricao(String.format("Categoria Teste %s", companyCounter));
            category.setEmblema(this.emblemService.findById(Domains.DEFAULT_EMBLEM_ID));
            category.setAtivo(Boolean.valueOf(true));
            category.setOrdem(Integer.valueOf(companyCounter - 1));
            category.setComposicao(Boolean.valueOf(false));
            category.setDestaque(Boolean.valueOf(false));
            category.setExcluida(Boolean.valueOf(false));
            this.categoryRepository.save((Object)category);
            for (int productCounter = 1; productCounter <= totalItemsPerComponent; ++productCounter) {
                Produto product = new Produto();
                product.setEmpresa(company);
                product.setNome(String.format("Produto Teste %s.%s", productCounter, productCounter));
                product.setDescricao("Descri\u00e7\u00e3o do produto aqui.");
                product.setCategoria(category);
                product.setDisponibilidades("1,2,3,4,5,6,7");
                product.setEmFalta(Boolean.valueOf(false));
                product.setExibeNaTelaInicial(Boolean.valueOf(true));
                product.setOpcionaisPorProduto(Boolean.valueOf(false));
                product.setApenasOpcionaisPorProduto(Boolean.valueOf(false));
                product.setVendaPorFracao(Boolean.valueOf(false));
                product.setValor(new BigDecimal(15.99));
                product.setVendaPorAtacado(Boolean.valueOf(false));
                product.setVendaPorTamanho(Boolean.valueOf(false));
                product.setFotoExterna(Boolean.valueOf(false));
                product.setEstoqueIlimitado(Boolean.valueOf(true));
                product.setCaminhoFoto(String.format("%s.jpg", new Date().getTime()));
                product.setCaminhoFoto(this.productService.generatePictureName(product));
                this.fileService.copyFile(this.fileService.getDefaultsPath() + File.separator + "produto.jpg", productImagePath + File.separator + product.getCaminhoFoto());
                this.fileService.copyFile(this.fileService.getDefaultsPath() + File.separator + "_produto.jpg", productImagePath + File.separator + "_" + product.getCaminhoFoto());
                this.productService.save(product);
                if (product.getId() % 2L != 0L) continue;
                EmpresaProdutoEmDestaque spotlight = new EmpresaProdutoEmDestaque();
                spotlight.setProduto(product);
                spotlight.setTitulo("Exemplo Destaque");
                spotlight.setExibir(Boolean.valueOf(true));
                spotlight.setExibirPreco(Boolean.valueOf(false));
                spotlight.setPromocional(Boolean.valueOf(false));
                spotlight.setFotoExterna(Boolean.valueOf(false));
                spotlight.setCaminhoFoto(String.format("%s.jpg", new Date().getTime()));
                spotlight.setCaminhoFoto(this.spotlightProductService.gerarNomeImagem(product.getId(), spotlight.getCaminhoFoto()));
                this.fileService.copyFile(this.fileService.getDefaultsPath() + File.separator + "destaque.jpg", spotlightImagePath + File.separator + spotlight.getCaminhoFoto());
                this.fileService.copyFile(this.fileService.getDefaultsPath() + File.separator + "_destaque.jpg", spotlightImagePath + File.separator + "_" + spotlight.getCaminhoFoto());
                this.spotlightProductRepository.save((Object)spotlight);
            }
        }
        this.buildDefaultPaymentOptions(company);
    }

    @Transactional
    public Usuario buildCompanyUser(PreCadastroDaEmpresa preRegistration) throws ApiException {
        Long totalUser = this.userRepository.countByLoginAndPerfil(Domains.PROFILE_COMPANY_ID, preRegistration.getEmailContato());
        if (totalUser >= 1L) {
            throw new ApiException("erro.entidade.existente.m", new String[]{"Login"});
        }
        Usuario user = new Usuario();
        user.setLogin(preRegistration.getEmailContato());
        user.setDemonstracao(false);
        user.setSenha(this.encoder.encode((CharSequence)preRegistration.getSenha()));
        user.setPerfil((Perfil)this.profileRepository.findById((Object)Domains.PROFILE_COMPANY_ID).get());
        user.setTelefone(preRegistration.getTelefoneContato());
        return (Usuario)this.userRepository.save((Object)user);
    }

    private String generateStoreName(String storeId, Integer complement) throws ApiException {
        storeId = StringUtil.removerAcentos((String)storeId);
        if (NullUtil.isNotNull((Object)complement)) {
            storeId = storeId + complement;
        }
        if (NullUtil.isNotNull((Object)this.companyService.findByIdStore(storeId))) {
            complement = 0;
            storeId = this.generateStoreName(storeId, Integer.valueOf(complement + 1));
        }
        return storeId;
    }

    @Transactional
    private void buildDefaultPaymentOptions(Empresa company) {
        OpcaoDePagamentoComCartao debitCard = new OpcaoDePagamentoComCartao();
        debitCard.setEmpresa(company);
        debitCard.setDescricao("Cart\u00e3o de D\u00e9bito");
        debitCard.setFuncao(FuncaoCartao.DEBITO);
        debitCard.setExcluida(Boolean.valueOf(false));
        debitCard.setTemDetalhes(Boolean.valueOf(false));
        this.paymentOptionRepository.save((Object)debitCard);
        OpcaoDePagamentoComCartao creditCard = new OpcaoDePagamentoComCartao();
        creditCard.setEmpresa(company);
        creditCard.setDescricao("Cart\u00e3o de Cr\u00e9dito");
        creditCard.setFuncao(FuncaoCartao.CREDITO);
        creditCard.setExcluida(Boolean.valueOf(false));
        creditCard.setTemDetalhes(Boolean.valueOf(false));
        this.paymentOptionRepository.save((Object)creditCard);
    }

    private void createCompanyFolder(Long companyId) throws ApiException, IOException {
        this.fileService.copyDirectory(this.fileService.getCompanyPath("0999", "", Boolean.valueOf(true)), this.fileService.getCompanyPath(String.valueOf(companyId), "", Boolean.valueOf(false)));
    }

    private void setCompanyDefaultSettings(Empresa company) throws ApiException {
        company.setAberto(Boolean.valueOf(false));
        company.setAceitaComandasAuto(Boolean.valueOf(false));
        company.setAceitaPedidosAuto(Boolean.valueOf(false));
        company.setControleEstoque(ControleEstoque.SEM_CONTROLE);
        company.setDataDeCadastro(new Date());
        company.setDataInicioDeUtilizacao(new Date());
        company.setDescontoPagamentoEmDinheiro(Boolean.valueOf(false));
        company.setDiaVencimentoMensalidade(Integer.valueOf(1));
        company.setFazDelivery(Boolean.valueOf(true));
        company.setFazRetirada(Boolean.valueOf(true));
        company.setEmTeste(Boolean.valueOf(false));
        company.setEmailContato(company.getUsuario().getLogin());
        company.setFusoHorario(FusoHorario.getTimezone((String)company.getMunicipio().getUf()));
        company.setIdStore(company.getNomeAbreviado().trim().toLowerCase().replaceAll(" ", ""));
        company.setIdStore(this.generateStoreName(company.getIdStore(), null));
        company.setImprimePedidosAuto(Boolean.valueOf(false));
        company.setImprimePedidosDistribuidosAuto(Boolean.valueOf(false));
        company.setWhatsapp(Boolean.valueOf(false));
        company.setLatitude(DEFAULT_LATITUDE);
        company.setLimitePedidos(Integer.valueOf(50));
        company.setLogotipo(DEFAULT_LOGO_NAME);
        company.setLogotipoStore(DEFAULT_LOGO_STORE_NAME);
        company.setLongitude("-49.86687138649489");
        company.setMaximoDeParcelas(Integer.valueOf(1));
        company.setParcelaMinima(new BigDecimal(1));
        company.setPorcentagemOutraPlataforma(Double.valueOf(25.0));
        company.setQuantidadeImpressoes(Integer.valueOf(1));
        company.setTempoDeEntrega(Integer.valueOf(60));
        company.setTempoDeRetirada(Integer.valueOf(60));
        company.setValorDescontoPagamentoEmDinheiro(BigDecimal.ZERO);
        company.setValorPedidoExcedente(new BigDecimal(2));
        company.setValorPlano(new BigDecimal(0));
        company.setVersao("3.0.2");
        company.setVersaoAndroid("3.0.2");
        company.setVersaoIOS("3.0.2");
    }
}

