/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Cliente;
import com.escolpi.omni.api.model.entity.EnderecoDeEntrega;
import com.escolpi.omni.api.model.entity.Municipio;
import com.escolpi.omni.api.repository.ClienteRepository;
import com.escolpi.omni.api.repository.EnderecoDeEntregaRepository;
import com.escolpi.omni.api.repository.MunicipioRepository;
import com.escolpi.omni.api.repository.PedidoRepository;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class EnderecoDeEntregaService {
    @Autowired
    private EnderecoDeEntregaRepository enderecoDeEntregaRepository;
    @Autowired
    private MunicipioRepository municipioRepository;
    @Autowired
    private PedidoRepository pedidoRepository;
    @Autowired
    private ClienteRepository clienteRepository;

    public List<EnderecoDeEntrega> listarEnderecoDeEntregaPorUsuario(Long clienteId) {
        return this.enderecoDeEntregaRepository.findByClienteIdAndExcluidoIsFalseOrderByEnderecoPrincipalDesc(clienteId);
    }

    @Transactional
    public EnderecoDeEntrega salvar(EnderecoDeEntrega endereco) throws ApiException {
        this.validate(endereco);
        List enderecos = this.enderecoDeEntregaRepository.findByClienteIdAndExcluidoIsFalseOrderByEnderecoPrincipalDesc(endereco.getCliente().getId());
        for (EnderecoDeEntrega end : enderecos) {
            if (!end.getExcluido().equals(false) || !end.getCep().equals(StringUtil.removerMascara((String)endereco.getCep())) || !end.getNumero().equals(endereco.getNumero()) || end.getId().equals(endereco.getId())) continue;
            throw new ApiException("msg.erro.027");
        }
        Municipio municipio = (Municipio)this.municipioRepository.findByNomeIgnoreCaseAndUfIgnoreCase(endereco.getMunicipio().getNome(), endereco.getMunicipio().getUf()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Munic\u00edpio", endereco.getMunicipio().getNome()}));
        endereco.setCep(StringUtil.removerMascara((String)endereco.getCep()));
        endereco.setBairro(StringUtil.capitalizar((String)endereco.getBairro()));
        endereco.setComplemento(StringUtil.capitalizar((String)endereco.getComplemento()));
        endereco.setDescricao(StringUtil.capitalizar((String)endereco.getDescricao()));
        endereco.setLogradouro(StringUtil.capitalizar((String)endereco.getLogradouro()));
        endereco.setPontoDeReferencia(StringUtil.capitalizar((String)endereco.getPontoDeReferencia()));
        if (NullUtil.isNotNull((Object)endereco.getId())) {
            EnderecoDeEntrega edicao = (EnderecoDeEntrega)this.enderecoDeEntregaRepository.findById((Object)endereco.getId()).get();
            edicao.setLogradouro(endereco.getLogradouro());
            edicao.setCep(endereco.getCep());
            edicao.setNumero(endereco.getNumero());
            edicao.setComplemento(endereco.getComplemento());
            edicao.setMunicipio((Municipio)this.municipioRepository.findByIbgeId(endereco.getMunicipio().getIbgeId()).get());
            edicao.setBairro(endereco.getBairro());
            edicao.setPontoDeReferencia(endereco.getPontoDeReferencia());
            edicao.setDescricao(endereco.getDescricao());
            edicao.setEnderecoPrincipal(Boolean.valueOf(false));
            endereco.setCliente((Cliente)this.clienteRepository.findById((Object)endereco.getCliente().getId()).get());
            this.enderecoDeEntregaRepository.save((Object)edicao);
            return edicao;
        }
        endereco.setCliente((Cliente)this.clienteRepository.findById((Object)endereco.getCliente().getId()).get());
        endereco.setMunicipio(municipio);
        endereco.setExcluido(Boolean.valueOf(false));
        endereco.setEnderecoPrincipal(Boolean.valueOf(false));
        return (EnderecoDeEntrega)this.enderecoDeEntregaRepository.save((Object)endereco);
    }

    @Transactional
    public void excluirEnderecoDeEntrega(Long enderecoId) throws ApiException {
        Cliente cliente = (Cliente)this.enderecoDeEntregaRepository.findClienteById(enderecoId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Cliente", "{Endere\u00e7o" + enderecoId.toString() + "}"}));
        if (this.pedidoRepository.countByEnderecoEntregaId(enderecoId) > 0L) {
            EnderecoDeEntrega endereco = (EnderecoDeEntrega)this.enderecoDeEntregaRepository.findById((Object)enderecoId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Endere\u00e7o de Entrega", enderecoId.toString()}));
            endereco.setExcluido(Boolean.valueOf(true));
            endereco.setEnderecoPrincipal(Boolean.valueOf(false));
            this.enderecoDeEntregaRepository.save((Object)endereco);
        } else {
            this.enderecoDeEntregaRepository.deleteById((Object)enderecoId);
        }
        this.atualizarEnderecoPrincipal(cliente);
    }

    public EnderecoDeEntrega obter(Long id) throws ApiException {
        return (EnderecoDeEntrega)this.enderecoDeEntregaRepository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Endere\u00e7o de Entrega", id.toString()}));
    }

    public EnderecoDeEntrega obterUltimoEnderecoRegistroPorCliente(Long clienteId) throws ApiException {
        return this.enderecoDeEntregaRepository.findTopByClienteIdOrderByIdDesc(clienteId).orElse(null);
    }

    public EnderecoDeEntrega getMainDeliveryAddressOrFirst(Long clienteId) throws ApiException {
        List enderecos;
        EnderecoDeEntrega enderecoPrincipal = this.enderecoDeEntregaRepository.findEnderecoPrincipal(clienteId).orElse(null);
        if (NullUtil.isNull((Object)enderecoPrincipal) && !CollectionUtils.isEmpty((Collection)(enderecos = this.enderecoDeEntregaRepository.findByClienteIdOrderByIdDesc(clienteId)))) {
            enderecoPrincipal = (EnderecoDeEntrega)enderecos.get(0);
        }
        return enderecoPrincipal;
    }

    @Transactional
    private void atualizarEnderecoPrincipal(Cliente cliente) {
        List enderecos = this.listarEnderecoDeEntregaPorUsuario(cliente.getId());
        if (enderecos.size() > 0 && enderecos.stream().noneMatch(end -> end.getEnderecoPrincipal() == true)) {
            EnderecoDeEntrega endereco = (EnderecoDeEntrega)this.enderecoDeEntregaRepository.findById((Object)((EnderecoDeEntrega)enderecos.get(0)).getId()).get();
            endereco.setEnderecoPrincipal(Boolean.TRUE);
            this.enderecoDeEntregaRepository.save((Object)endereco);
        }
    }

    private void validate(EnderecoDeEntrega entity) throws ApiException {
        if (!NullUtil.isNotNull((Object)entity.getMunicipio())) {
            throw new ApiException("msg.erro.001", new String[]{"Municipio"});
        }
        if (!NullUtil.isNotNull((Object)entity.getMunicipio()) || !NullUtil.isNotNull((Object)entity.getMunicipio().getIbgeId())) {
            throw new ApiException("msg.erro.172");
        }
        if (!NullUtil.isNotNull((Object)entity.getCliente())) {
            throw new ApiException("msg.erro.001", new String[]{"Cliente"});
        }
        if (!NullUtil.isNotNull((Object)entity.getCliente()) || !NullUtil.isNotNull((Object)entity.getCliente().getId())) {
            throw new ApiException("msg.erro.001", new String[]{"Cliente"});
        }
        if (!NullUtil.isNotNull((Object)entity.getLogradouro())) {
            throw new ApiException("msg.erro.001", new String[]{"Logradouro"});
        }
        if (!NullUtil.isNotNull((Object)entity.getNumero())) {
            throw new ApiException("msg.erro.001", new String[]{"N\u00famero"});
        }
        if (!NullUtil.isNotNull((Object)entity.getCep())) {
            throw new ApiException("msg.erro.001", new String[]{"CEP"});
        }
        if (!NullUtil.isNotNull((Object)entity.getBairro())) {
            throw new ApiException("msg.erro.001", new String[]{"Bairro"});
        }
    }
}

