/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.FormaDePagamento;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Contratacao;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.EmpresaConfiguracao;
import com.escolpi.omni.api.model.entity.HorarioDeFuncionamento;
import com.escolpi.omni.api.model.entity.IdentificacaoDaEmpresa;
import com.escolpi.omni.api.model.entity.LogDeAcesso;
import com.escolpi.omni.api.model.entity.Municipio;
import com.escolpi.omni.api.model.entity.MunicipioAtendido;
import com.escolpi.omni.api.model.entity.PreCadastroDaEmpresa;
import com.escolpi.omni.api.model.entity.Segmento;
import com.escolpi.omni.api.model.entity.Usuario;
import com.escolpi.omni.api.model.entity.api.OpcaoDePagamentoApi;
import com.escolpi.omni.api.model.entity.dto.CartaoDeCredito;
import com.escolpi.omni.api.model.entity.dto.EmpresaDto;
import com.escolpi.omni.api.model.projection.AutocompleteView;
import com.escolpi.omni.api.model.projection.ConfiguracaoView;
import com.escolpi.omni.api.model.projection.EmpresaView;
import com.escolpi.omni.api.model.projection.StatusDaLojaView;
import com.escolpi.omni.api.repository.BairroNaoAtendidoRepository;
import com.escolpi.omni.api.repository.ContratacaoRepository;
import com.escolpi.omni.api.repository.EmpresaConfiguracaoRepository;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.repository.HorarioDeFuncionamentoRepository;
import com.escolpi.omni.api.repository.IdentificacaoDaEmpresaRepository;
import com.escolpi.omni.api.repository.LogDeAcessoRepository;
import com.escolpi.omni.api.repository.MunicipioAtendidoRepository;
import com.escolpi.omni.api.repository.MunicipioRepository;
import com.escolpi.omni.api.repository.OpcaoDePagamentoComCartaoRepository;
import com.escolpi.omni.api.repository.PreCadastroDaEmpresaRepository;
import com.escolpi.omni.api.repository.SegmentoRepository;
import com.escolpi.omni.api.repository.TarifacaoDeEntregaRepository;
import com.escolpi.omni.api.repository.UsuarioRepository;
import com.escolpi.omni.api.service.EmpresaConfiguracaoService;
import com.escolpi.omni.api.service.FileService;
import com.escolpi.omni.api.service.ParceiroService;
import com.escolpi.omni.api.service.PlanoService;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CollectionUtil;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.FileUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class EmpresaService
implements BaseCrudService<Empresa, Long> {
    @Autowired
    private BCryptPasswordEncoder encoder;
    @Autowired
    private BairroNaoAtendidoRepository bairroNaoAtendidoRepository;
    @Autowired
    private MunicipioRepository cityRepository;
    @Autowired
    private EmpresaConfiguracaoRepository empresaConfiguracaoRepository;
    @Autowired
    private IdentificacaoDaEmpresaRepository companyIdentifyRepository;
    @Autowired
    private EmpresaRepository repository;
    @Autowired
    private PreCadastroDaEmpresaRepository companyPreRegistrationRepository;
    @Autowired
    private EmpresaConfiguracaoService empresaConfiguracaoService;
    @Autowired
    private MunicipioAtendidoRepository municipioAtendidoRepository;
    @Autowired
    private ContratacaoRepository contractRepository;
    @Autowired
    private FileService fileService;
    @Autowired
    private HorarioDeFuncionamentoRepository horarioDeFuncionamentoRepository;
    @Autowired
    private LogDeAcessoRepository logDeAcessoRepository;
    @Autowired
    private MunicipioRepository municipioRepository;
    @Autowired
    private OpcaoDePagamentoComCartaoRepository opcaoDePagamentoComCartaoRepository;
    @Autowired
    private TarifacaoDeEntregaRepository tarifacaoRepository;
    @Autowired
    private UsuarioRepository userRepository;
    @Autowired
    private ParceiroService partnerService;
    @Autowired
    private SegmentoRepository segmentRepository;
    @Autowired
    private PlanoService planService;

    public List<AutocompleteView> autocompleteByFancyName(String fancyName) {
        return this.repository.findByAutocomplete(fancyName);
    }

    public void attachCity(Long empresaId, MunicipioAtendido municipio) throws ApiException {
        if (this.municipioAtendidoRepository.countByEmpresaIdAndMunicipioId(empresaId, municipio.getMunicipio().getId()) > 0L) {
            throw new ApiException("erro.entidade.existente.m", new String[]{"Munic\u00edpio Atendido"});
        }
        Empresa empresa = this.findById(empresaId);
        if (empresa.getMunicipio().getId().equals(municipio.getMunicipio().getId())) {
            throw new ApiException("msg.erro.094");
        }
        if (NullUtil.isNull((Object)municipio.getTaxaDeEntrega())) {
            throw new ApiException("msg.erro.104");
        }
        MunicipioAtendido municipioAtendido = new MunicipioAtendido();
        municipioAtendido.getEmpresa().setId(empresaId);
        municipioAtendido.getMunicipio().setId(municipio.getMunicipio().getId());
        municipioAtendido.setTaxaDeEntrega(municipio.getTaxaDeEntrega());
        this.municipioAtendidoRepository.save((Object)municipioAtendido);
    }

    @Transactional
    public Empresa changeLockingState(Long id) throws ApiException {
        Empresa edit;
        edit.setAtivo(Boolean.valueOf((edit = this.findById(id)).getAtivo() == false));
        edit.getUsuario().setBloqueado(Boolean.valueOf(edit.getUsuario().getBloqueado() == false));
        edit.setAberto(Boolean.valueOf(edit.getUsuario().getBloqueado() == false));
        this.repository.save((Object)edit);
        this.userRepository.save((Object)edit.getUsuario());
        LogDeAcesso log = new LogDeAcesso();
        log.setEmpresa(edit);
        log.setEntidade(Entidade.EMPRESA);
        log.setOperacao(Operacao.ALTERACAO);
        log.setUsuario(edit.getUsuario());
        log.setMensagem(String.format("Empresa %s %s com sucesso!", edit.getNomeFantasia(), edit.getUsuario().getBloqueado() != false ? "bloqueada" : "desbloqueada"));
        this.logDeAcessoRepository.save((Object)log);
        return edit;
    }

    @Transactional
    public EmpresaView changeOpeningState(Long id) throws ApiException {
        EmpresaView edit;
        edit.setAberto(Boolean.valueOf((edit = (EmpresaView)this.repository.findToClose(id).get()).getAberto() == false));
        edit.setUsuario(new Usuario((Long)this.repository.getCompanyUserId(edit.getId()).get()));
        this.repository.changeOpeningState(id, edit.getAberto().booleanValue());
        LogDeAcesso log = new LogDeAcesso();
        log.setEmpresa(new Empresa(edit.getId()));
        log.setEntidade(Entidade.EMPRESA);
        log.setOperacao(Operacao.ALTERACAO);
        log.setUsuario(edit.getUsuario());
        log.setMensagem(String.format("Empresa %s %s com sucesso!", edit.getNomeFantasia(), edit.getAberto() != false ? "aberta" : "fechada"));
        this.logDeAcessoRepository.save((Object)log);
        return edit;
    }

    @Transactional
    public Empresa changeTestingState(Long id) throws ApiException {
        Empresa edit;
        edit.setEmTeste(Boolean.valueOf((edit = this.findById(id)).getEmTeste() == false));
        this.repository.save((Object)edit);
        LogDeAcesso log = new LogDeAcesso();
        log.setEmpresa(edit);
        log.setEntidade(Entidade.EMPRESA);
        log.setOperacao(Operacao.ALTERACAO);
        log.setUsuario(edit.getUsuario());
        log.setMensagem(String.format("Empresa %s %s com sucesso!", edit.getNomeFantasia(), edit.getEmTeste() != false ? "com modo teste" : "sem modo teste"));
        this.logDeAcessoRepository.save((Object)log);
        return edit;
    }

    public boolean companyIsLocked(Long companyId) throws ApiException {
        boolean isActive = this.repository.getCompanyActivationStatus(companyId).orElse(false);
        return !isActive;
    }

    public boolean companyExists(Long id) throws ApiException {
        return this.repository.findById((Object)id).isPresent();
    }

    public boolean companyExists(String cpfCnpj) throws IOException {
        Empresa company = this.repository.findByCnpj(cpfCnpj).orElse(null);
        return NullUtil.isNotNull((Object)company);
    }

    @Transactional
    public void createContractToFreePlan(Empresa company) {
        Contratacao contract = new Contratacao();
        contract.setEmpresa(company);
        contract.setPlano(company.getPlano());
        contract.setParcelas(Integer.valueOf(0));
        contract.setValorContratado(new BigDecimal(0.0));
        contract.setValorDaParcela(new BigDecimal(0.0));
        contract.setInicioDoContrato(new Date());
        contract.setFimDoContrato(DateUtil.addDay((Date)contract.getInicioDoContrato(), (int)365));
        this.contractRepository.save((Object)contract);
    }

    @Transactional
    public Contratacao createContractToPaidPlan(CartaoDeCredito creditCard) throws ApiException {
        Contratacao edit = this.contractRepository.findCurrentContract(creditCard.getEmpresaId()).orElse(null);
        if (NullUtil.isNotNull((Object)edit)) {
            edit.setParcelas(creditCard.getParcelas());
            edit.setValorDaParcela(creditCard.getValorDaParcela());
            edit.setValorContratado(creditCard.getTotalDaCompra());
            edit.setInicioDoContrato(new Date());
            edit.setFimDoContrato(DateUtil.addDay((Date)edit.getInicioDoContrato(), (int)365));
            return (Contratacao)this.contractRepository.save((Object)edit);
        }
        Empresa company = (Empresa)this.repository.findById((Object)creditCard.getEmpresaId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", creditCard.getEmpresaId().toString()}));
        Contratacao contract = new Contratacao();
        contract.setEmpresa(company);
        contract.setPlano(company.getPlano());
        contract.setParcelas(creditCard.getParcelas());
        contract.setValorDaParcela(creditCard.getValorDaParcela());
        contract.setValorContratado(creditCard.getTotalDaCompra());
        contract.setInicioDoContrato(new Date());
        contract.setFimDoContrato(DateUtil.addDay((Date)contract.getInicioDoContrato(), (int)365));
        return (Contratacao)this.contractRepository.save((Object)contract);
    }

    @Transactional
    public void detachCity(Long empresaId, Long municipioAtendidoId) throws ApiException {
        MunicipioAtendido exclusao = (MunicipioAtendido)this.municipioAtendidoRepository.findById((Object)municipioAtendidoId).orElseThrow(() -> new ApiException("msg.erro.entidade.nao.encontrado", new String[]{"Munic\u00edpio Atendido", municipioAtendidoId.toString()}));
        if (this.municipioAtendidoRepository.countById(municipioAtendidoId) == 0L) {
            throw new ApiException("erro.entidade.nao.encontrado", new String[]{"Munic\u00edpio Atendido", municipioAtendidoId.toString()});
        }
        List bairrosNaoAtendidos = this.bairroNaoAtendidoRepository.findByEmpresaIdAndMunicipioId(empresaId, exclusao.getMunicipio().getId());
        bairrosNaoAtendidos.forEach(bairro -> this.bairroNaoAtendidoRepository.deleteById((Object)bairro.getId()));
        List tarifacoes = this.tarifacaoRepository.findByEmpresaIdAndMunicipioId(empresaId, exclusao.getMunicipio().getId());
        tarifacoes.forEach(tarifacao -> this.tarifacaoRepository.deleteById((Object)tarifacao.getId()));
        this.municipioAtendidoRepository.deleteById((Object)municipioAtendidoId);
    }

    public void detachAllCity(Long empresaId) throws ApiException {
        List municipios = this.findByEmpresaId(empresaId);
        municipios.forEach(municipio -> this.municipioAtendidoRepository.delete(municipio));
    }

    public EmpresaConfiguracao findCompanyConfigById(Long companyId, String configName) throws ApiException {
        EmpresaConfiguracao config = (EmpresaConfiguracao)this.empresaConfiguracaoRepository.findByEmpresaIdAndConfiguracaoNome(companyId, configName).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Configura\u00e7\u00e3o da Empresa", "{ Empresa " + companyId + " | Configura\u00e7\u00e3o " + configName + " }"}));
        config.setEmpresa(new Empresa(config.getEmpresa().getId()));
        if (StringUtil.isBlank((String)config.getValor())) {
            config.setValor(config.getConfiguracao().getValorPadrao());
        }
        return config;
    }

    public ConfiguracaoView findCompanyConfigById(String storeId, String configName) throws ApiException {
        return (ConfiguracaoView)this.empresaConfiguracaoRepository.findByStoreIdAndConfigName(storeId, configName).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Configura\u00e7\u00e3o da Empresa"}));
    }

    public PreCadastroDaEmpresa findCompanyPreRegistration(Long id) throws ApiException {
        return (PreCadastroDaEmpresa)this.companyPreRegistrationRepository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Pr\u00e9-cadastro da Empresa", id.toString()}));
    }

    public List<MunicipioAtendido> findByEmpresaId(Long empresaId) {
        return this.municipioAtendidoRepository.findByEmpresaIdOrderByMunicipioNome(empresaId);
    }

    public Empresa findById(Long id) throws ApiException {
        return (Empresa)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", id.toString()}));
    }

    public Empresa findByIdWithMedias(Long id) throws ApiException {
        Empresa company = this.findById(id);
        String path = this.fileService.getCompanyPath(company.getId().toString(), null, Boolean.valueOf(true));
        if (StringUtil.isNotBlank((String)path)) {
            File backgruondStoreFile;
            File logoStoreFile;
            File logoFile;
            if (StringUtil.isNotBlank((String)company.getLogotipo()) && NullUtil.isNotNull((Object)(logoFile = this.obterArquivoDoLogotipo(company, false)))) {
                company.setFoto(FileUtil.encodeToBase64((File)logoFile));
            }
            if (StringUtil.isNotBlank((String)company.getLogotipoStore()) && NullUtil.isNotNull((Object)(logoStoreFile = this.fileService.getFile(path.concat("/".concat(company.getLogotipoStore())))))) {
                company.setFotoStore(FileUtil.encodeToBase64((File)logoStoreFile));
            }
            if (StringUtil.isNotBlank((String)company.getPlanoDeFundoStore()) && NullUtil.isNotNull((Object)(backgruondStoreFile = this.fileService.getFile(path.concat(File.separator.concat(company.getPlanoDeFundoStore())))))) {
                company.setPlanoDeFundoNaLoja(FileUtil.encodeToBase64((File)backgruondStoreFile));
            }
        }
        return company;
    }

    public EmpresaView findByIdStore(String storeId) {
        return this.repository.findByIdStore(storeId).orElse(null);
    }

    public EmpresaView findCompanyByStoreId(String storeId) throws ApiException {
        EmpresaView company = this.repository.findByIdStore(storeId).orElse(null);
        if (NullUtil.isNull((Object)company)) {
            return null;
        }
        if (StringUtil.isNotBlank((String)company.getLogotipoStore())) {
            company.setLogotipoStore(this.fileService.getCompanyUrl(company.getId(), null).concat("/").concat(company.getLogotipoStore()));
        }
        if (StringUtil.isNotBlank((String)company.getPlanoDeFundoStore())) {
            company.setPlanoDeFundoStore(this.fileService.getCompanyUrl(company.getId(), null).concat("/").concat(company.getPlanoDeFundoStore()));
        }
        company.setSegmento(new Segmento(company.getSegmento().getId(), company.getSegmento().getDescricao(), company.getSegmento().getCaminhoFoto()));
        company.getSegmento().setCaminhoFoto("https://imagens3.pedidoagora.com.br/".concat("segmentos/").concat(company.getSegmento().getCaminhoFoto()));
        company.setConfiguracoesDaEmpresa(this.empresaConfiguracaoRepository.getCompanyConfigs(company.getId()));
        company.getConfiguracoesDaEmpresa().stream().filter(config -> StringUtil.isBlank((String)config.getValor())).forEach(config -> config.setValor(config.getValorPadrao()));
        return company;
    }

    @Deprecated
    public EmpresaView getCompanyByStoreId(String storeId) throws ApiException {
        EmpresaView company = this.repository.findByIdStore(storeId).orElse(null);
        if (NullUtil.isNull((Object)company)) {
            return null;
        }
        if (StringUtil.isNotBlank((String)company.getLogotipoStore())) {
            company.setLogotipoStore(this.fileService.getCompanyUrl(company.getId(), null).concat("/").concat(company.getLogotipoStore()));
        }
        if (StringUtil.isNotBlank((String)company.getPlanoDeFundoStore())) {
            company.setPlanoDeFundoStore(this.fileService.getCompanyUrl(company.getId(), null).concat("/").concat(company.getPlanoDeFundoStore()));
        }
        company.setSegmento(new Segmento(company.getSegmento().getId(), company.getSegmento().getDescricao(), company.getSegmento().getCaminhoFoto()));
        company.getSegmento().setCaminhoFoto("https://imagens3.pedidoagora.com.br/".concat("segmentos/").concat(company.getSegmento().getCaminhoFoto()));
        company.setConfiguracoesDaEmpresa(this.empresaConfiguracaoRepository.getCompanyConfigs(company.getId()));
        company.getConfiguracoesDaEmpresa().stream().filter(config -> StringUtil.isBlank((String)config.getValor())).forEach(config -> config.setValor(config.getValorPadrao()));
        company.setUsuario(new Usuario(company.getUsuario().getId(), company.getUsuario().isDemonstracao()));
        return company;
    }

    public EmpresaConfiguracao getCompanyConfig(Long id, String configName) {
        return this.empresaConfiguracaoRepository.findByEmpresaIdAndConfiguracaoNome(id, configName).orElse(null);
    }

    public boolean getOpeningState(Long id) throws ApiException {
        return this.repository.getCompanyOpeningStatus(id).orElse(false);
    }

    public StatusDaLojaView getStoreOpeningStatus(Long companyId) throws ApiException {
        return (StatusDaLojaView)this.repository.getStoreOpeningStatus(companyId).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa"}));
    }

    public List<EmpresaConfiguracao> listCompanyConfigs(Long companyId) {
        return this.empresaConfiguracaoRepository.findByEmpresaIdOrderByConfiguracaoId(companyId);
    }

    public List<HorarioDeFuncionamento> listarHorariosDeFuncionamentoPorEmpresa(Long empresaId) {
        List horariosDeFuncionamento = this.horarioDeFuncionamentoRepository.findHorarioDeFuncionamentoByEmpresaOrderByDiaDaSemana(empresaId);
        ArrayList<HorarioDeFuncionamento> horariosDisponiveis = new ArrayList<HorarioDeFuncionamento>();
        for (int i = 0; i < horariosDeFuncionamento.size(); ++i) {
            HorarioDeFuncionamento hf;
            HorarioDeFuncionamento horario = (HorarioDeFuncionamento)horariosDeFuncionamento.get(i);
            boolean horarioExtendido = DateUtil.eHorarioDaMadrugada((Date)horario.getHoraAbertura());
            if (i == 0 && horarioExtendido) continue;
            if (CollectionUtil.eUltimoElementoDaLista((int)i, (Collection)horariosDeFuncionamento)) {
                if (DateUtil.eHorarioDaMadrugada((Date)((HorarioDeFuncionamento)horariosDeFuncionamento.get(0)).getHoraAbertura())) {
                    hf = new HorarioDeFuncionamento();
                    hf.setAbreNoDia(horario.getAbreNoDia());
                    hf.setDiaDaSemana(horario.getDiaDaSemana());
                    hf.setEmpresa(horario.getEmpresa());
                    hf.setHoraAbertura(horario.getHoraAbertura());
                    hf.setHoraFechamento(((HorarioDeFuncionamento)horariosDeFuncionamento.get(0)).getHoraFechamento());
                    horariosDisponiveis.add(hf);
                    continue;
                }
                horariosDisponiveis.add(horario);
                continue;
            }
            if (CollectionUtil.eUltimoElementoDaLista((int)i, (Collection)horariosDeFuncionamento) || DateUtil.eHorarioDaMadrugada((Date)horario.getHoraAbertura())) continue;
            if (DateUtil.eHorarioDaMadrugada((Date)((HorarioDeFuncionamento)horariosDeFuncionamento.get(i + 1)).getHoraAbertura())) {
                hf = new HorarioDeFuncionamento();
                hf.setHoraAbertura(horario.getHoraAbertura());
                hf.setHoraFechamento(((HorarioDeFuncionamento)horariosDeFuncionamento.get(i + 1)).getHoraFechamento());
                hf.setAbreNoDia(horario.getAbreNoDia());
                hf.setDiaDaSemana(horario.getDiaDaSemana());
                hf.setEmpresa(horario.getEmpresa());
                horariosDisponiveis.add(hf);
                ++i;
                continue;
            }
            horariosDisponiveis.add(horario);
        }
        return horariosDisponiveis;
    }

    public List<OpcaoDePagamentoApi> listarOpcoesDePagamentoDaEmpresa(Long empresaId) throws ApiException {
        ArrayList<OpcaoDePagamentoApi> opcoes = new ArrayList<OpcaoDePagamentoApi>();
        List opcoesComCartao = this.opcaoDePagamentoComCartaoRepository.findByEmpresaIdAndExcluidaIsFalse(empresaId);
        EmpresaConfiguracao configuracao = this.empresaConfiguracaoRepository.findByEmpresaIdAndConfiguracaoNome(empresaId, "label-opcao-pgto-dinheiro").orElse(null);
        if (NullUtil.isNotNull((Object)configuracao)) {
            opcoes.add(new OpcaoDePagamentoApi(StringUtil.isBlank((String)configuracao.getValor()) ? configuracao.getConfiguracao().getValorPadrao() : configuracao.getValor(), FormaDePagamento.DINHEIRO));
        }
        opcoesComCartao.forEach(opcao -> opcoes.add(new OpcaoDePagamentoApi(opcao.getDescricao(), FormaDePagamento.MAQUINA_MOVEL)));
        return opcoes;
    }

    public File obterArquivoDoLogotipo(Empresa empresa, boolean miniatura) throws ApiException {
        String path = this.fileService.getCompanyPath(empresa.getId().toString(), null, Boolean.valueOf(true));
        if (StringUtil.isNotBlank((String)path)) {
            return this.fileService.getFile(path + File.separator + (miniatura ? "_" : "") + empresa.getLogotipo());
        }
        return null;
    }

    public EmpresaDto obterCadastroCompletoDaEmpresa(Long id) throws ApiException {
        Empresa empresa = this.findById(id);
        EmpresaDto dto = this.fromEntity(empresa, true);
        dto.setHorariosDeFuncionamento(this.listarHorariosDeFuncionamentoPorEmpresa(id));
        dto.setConfiguracoesDaEmpresa(this.empresaConfiguracaoService.obterConfiguracoes(id));
        return dto;
    }

    public List<EmpresaDto> obterFiliais(Long id) throws ApiException {
        ArrayList<EmpresaDto> dtos = new ArrayList<EmpresaDto>();
        EmpresaDto matriz = this.fromEntity(this.findById(id), true);
        List filiais = this.repository.findByMatrizOrderByAbertoDesc(new Empresa(id));
        for (Empresa filial : filiais) {
            EmpresaDto dto = this.fromEntity(filial, true);
            dto.setHorariosDeFuncionamento(this.listarHorariosDeFuncionamentoPorEmpresa(id));
            dto.setConfiguracoesDaEmpresa(this.empresaConfiguracaoService.obterConfiguracoes(id));
            dto.setMatriz(matriz);
            dtos.add(dto);
        }
        return dtos;
    }

    public Empresa obterPorUsuario(Usuario usuario) throws ApiException {
        return (Empresa)this.repository.findByUsuarioId(usuario.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrada", new String[]{"Empresa", "{ Usu\u00e1rio " + usuario.getId() + " }"}));
    }

    public EmpresaDto obterPorEmail(String email) throws ApiException {
        Empresa empresa = (Empresa)this.repository.findByLogin(email).orElseThrow(() -> new ApiException("msg.erro.039"));
        return this.fromEntity(empresa, true);
    }

    @Transactional
    public void updateMedias(Empresa empresa) throws ApiException {
        String caminhoAtual;
        Empresa edicao = this.findById(empresa.getId());
        String path = this.getPathEmpresa(empresa.getId()) + File.separator;
        if (StringUtil.isNotBlank((String)empresa.getLogotipo()) && StringUtil.isNotBlank((String)empresa.getFoto())) {
            if (StringUtil.isNotBlank((String)edicao.getLogotipo())) {
                caminhoAtual = this.getPathEmpresa(edicao.getId()) + File.separator + edicao.getLogotipo();
                if (FileUtil.fileExists((String)caminhoAtual)) {
                    FileUtil.deleteFile((String)caminhoAtual);
                }
                edicao.setLogotipo("logo" + StringUtil.obterExtensao((String)empresa.getLogotipo()));
                this.fileService.saveBase64File(path + edicao.getLogotipo(), empresa.getFoto());
            } else {
                edicao.setLogotipo("logo" + StringUtil.obterExtensao((String)empresa.getLogotipo()));
                this.fileService.saveBase64File(path + edicao.getLogotipo(), empresa.getFoto());
            }
        } else if (StringUtil.isNotBlank((String)edicao.getLogotipo()) && FileUtil.fileExists((String)(caminhoAtual = this.getPathEmpresa(edicao.getId()) + File.separator + edicao.getLogotipo()))) {
            FileUtil.deleteFile((String)caminhoAtual);
            edicao.setLogotipo(null);
        }
        if (StringUtil.isNotBlank((String)empresa.getLogotipoStore()) && StringUtil.isNotBlank((String)empresa.getFotoStore())) {
            if (StringUtil.isNotBlank((String)edicao.getLogotipoStore())) {
                caminhoAtual = this.getPathEmpresa(edicao.getId()) + File.separator + edicao.getLogotipoStore();
                if (FileUtil.fileExists((String)caminhoAtual)) {
                    FileUtil.deleteFile((String)caminhoAtual);
                }
                edicao.setLogotipoStore("logo-store" + StringUtil.obterExtensao((String)empresa.getLogotipoStore()));
                this.fileService.saveBase64File(path + edicao.getLogotipoStore(), empresa.getFotoStore());
            } else {
                edicao.setLogotipoStore("logo-store" + StringUtil.obterExtensao((String)empresa.getLogotipoStore()));
                this.fileService.saveBase64File(path + edicao.getLogotipoStore(), empresa.getFotoStore());
            }
        } else if (StringUtil.isNotBlank((String)edicao.getLogotipoStore()) && FileUtil.fileExists((String)(caminhoAtual = this.getPathEmpresa(edicao.getId()) + File.separator + edicao.getLogotipoStore()))) {
            FileUtil.deleteFile((String)caminhoAtual);
            edicao.setLogotipoStore(null);
        }
        if (StringUtil.isNotBlank((String)empresa.getPlanoDeFundoStore()) && StringUtil.isNotBlank((String)empresa.getPlanoDeFundoNaLoja())) {
            if (StringUtil.isNotBlank((String)edicao.getPlanoDeFundoStore())) {
                caminhoAtual = this.getPathEmpresa(edicao.getId()) + File.separator + edicao.getPlanoDeFundoStore();
                if (FileUtil.fileExists((String)caminhoAtual)) {
                    FileUtil.deleteFile((String)caminhoAtual);
                }
                edicao.setPlanoDeFundoStore("bg-store" + StringUtil.obterExtensao((String)empresa.getPlanoDeFundoStore()));
                this.fileService.saveBase64File(path + edicao.getPlanoDeFundoStore(), empresa.getPlanoDeFundoNaLoja());
            } else {
                edicao.setPlanoDeFundoStore("bg-store" + StringUtil.obterExtensao((String)empresa.getPlanoDeFundoStore()));
                this.fileService.saveBase64File(path + edicao.getPlanoDeFundoStore(), empresa.getPlanoDeFundoNaLoja());
            }
        } else if (StringUtil.isNotBlank((String)edicao.getPlanoDeFundoStore()) && FileUtil.fileExists((String)(caminhoAtual = this.getPathEmpresa(edicao.getId()) + File.separator + edicao.getPlanoDeFundoStore()))) {
            edicao.setPlanoDeFundoStore(null);
            FileUtil.deleteFile((String)caminhoAtual);
        }
        this.repository.save((Object)edicao);
    }

    @Deprecated
    public boolean obterSituacaoDeFuncionamento(Long empresaId) throws ApiException {
        return this.findById(empresaId).getAberto();
    }

    @Transactional
    public void updateSettings(Empresa company) throws ApiException {
        this.validateSettings(company);
        Empresa edit = this.findById(company.getId());
        edit.setValorTarifaUnica(company.getValorTarifaUnica());
        edit.setValorIsencaoEntrega(company.getValorIsencaoEntrega());
        edit.setFusoHorario(company.getFusoHorario());
        edit.setAceitaPedidosAuto(company.getAceitaPedidosAuto());
        edit.setAceitaComandasAuto(company.getAceitaComandasAuto());
        edit.setImprimePedidosAuto(company.getImprimePedidosAuto());
        edit.setDescontoPagamentoEmDinheiro(company.getDescontoPagamentoEmDinheiro());
        edit.setValorDescontoPagamentoEmDinheiro(company.getValorDescontoPagamentoEmDinheiro());
        edit.setParcelaMinima(company.getParcelaMinima());
        edit.setMaximoDeParcelas(company.getMaximoDeParcelas());
        edit.setQuantidadeImpressoes(company.getQuantidadeImpressoes());
        edit.setControleEstoque(company.getControleEstoque());
        edit.setFazDelivery(company.getFazDelivery());
        edit.setFazRetirada(company.getFazRetirada());
        edit.setImprimePedidosDistribuidosAuto(company.getImprimePedidosDistribuidosAuto());
        edit.setValorMinimoParaEntrega(company.getValorMinimoParaEntrega());
        edit.setLatitude(company.getLatitude());
        edit.setLongitude(company.getLongitude());
        edit.setPorcentagemDoCashback(company.getPorcentagemDoCashback());
        edit.setPorcentagemDeComissao(company.getPorcentagemDeComissao());
        edit.setValorPlano(company.getValorPlano());
        edit.setIdStore(company.getIdStore());
        edit.setAtosBotId(company.getAtosBotId());
        edit.setServidor(company.getServidor());
        edit.setInstancia(company.getInstancia());
        edit.setWhatsapp(company.getWhatsapp());
        if (NullUtil.isNotNull((Object)company.getPlano())) {
            edit.setPlano(company.getPlano());
        }
        if (StringUtil.isNotBlank((String)company.getSenha()) && StringUtil.isNotBlank((String)company.getConfirmacaoSenha())) {
            if (!company.getSenha().equals(company.getConfirmacaoSenha())) {
                throw new ApiException("msg.erro.004");
            }
            edit.getUsuario().setSenha(this.encoder.encode((CharSequence)company.getSenha()));
            this.userRepository.save((Object)edit.getUsuario());
        }
        this.repository.save((Object)edit);
    }

    @Transactional
    public void save(Empresa company) throws ApiException {
        this.validate(company);
        Municipio municipio = (Municipio)this.municipioRepository.findByNomeIgnoreCaseAndUfIgnoreCase(company.getMunicipio().getNome().trim(), company.getMunicipio().getUf().trim()).orElseThrow(() -> new ApiException("msg.erro.entidade.nao.encontrado", new String[]{"Munic\u00edpio", company.getMunicipio().getNome()}));
        Empresa edicao = this.findById(company.getId());
        edicao.setContato(company.getContato());
        edicao.setEmailContato(company.getEmailContato());
        edicao.setRazaoSocial(company.getRazaoSocial());
        edicao.setNomeFantasia(company.getNomeFantasia());
        edicao.setNomeAbreviado(company.getNomeAbreviado());
        edicao.setTelefonePrincipal(company.getTelefonePrincipal());
        edicao.setTelefoneSecundario(company.getTelefoneSecundario());
        edicao.setUrlSite(company.getUrlSite());
        edicao.setCep(company.getCep());
        edicao.setLogradouro(company.getLogradouro());
        edicao.setNumero(company.getNumero());
        edicao.setBairro(company.getBairro());
        edicao.setComplemento(company.getComplemento());
        edicao.setMunicipio(municipio);
        edicao.setTokenFcm(company.getTokenFcm());
        edicao.setSegmento(company.getSegmento());
        edicao.setControleEstoque(company.getControleEstoque());
        edicao.setAtosBotId(company.getAtosBotId());
        if (StringUtil.isNotBlank((String)company.getUrlFacebook())) {
            edicao.setUrlFacebook(company.getUrlFacebook());
        }
        if (StringUtil.isNotBlank((String)company.getUrlInstagram())) {
            edicao.setUrlInstagram(company.getUrlInstagram());
        }
        if (StringUtil.isNotBlank((String)company.getUrlTwitter())) {
            edicao.setUrlTwitter(company.getUrlTwitter());
        }
        if (StringUtil.isNotBlank((String)company.getUrlYoutube())) {
            edicao.setUrlYoutube(company.getUrlYoutube());
        }
        if (NullUtil.isNotNull((Object)company.getWhatsapp())) {
            edicao.setWhatsapp(company.getWhatsapp());
        }
        if (StringUtil.isNotBlank((String)company.getUrlAppAndroid())) {
            edicao.setUrlAppAndroid(company.getUrlAppAndroid());
        }
        if (StringUtil.isNotBlank((String)company.getUrlAppIos())) {
            edicao.setUrlAppIos(company.getUrlAppIos());
        }
        if (StringUtil.isNotBlank((String)company.getUrlStore())) {
            edicao.setUrlStore(company.getUrlStore());
        }
        this.repository.save((Object)edicao);
    }

    @Transactional
    public PreCadastroDaEmpresa saveCompanyPreRegistration(PreCadastroDaEmpresa preRegistration, boolean finalize) throws ApiException {
        preRegistration.setFinalizado(Boolean.valueOf(finalize));
        if (NullUtil.isNotNullOrZero((Number)preRegistration.getId())) {
            PreCadastroDaEmpresa edit = this.populateCompanyPreRegistration(preRegistration);
            return (PreCadastroDaEmpresa)this.companyPreRegistrationRepository.save((Object)edit);
        }
        return (PreCadastroDaEmpresa)this.companyPreRegistrationRepository.save((Object)preRegistration);
    }

    @Transactional
    public void saveFcmToken(Long empresaId, String tokenFcm) throws ApiException {
        Empresa edicao = this.findById(empresaId);
        edicao.setTokenFcm(tokenFcm);
        this.repository.save((Object)edicao);
    }

    public Date obterHorarioDoUltimoAcesso(Long empresaId) throws ApiException {
        if (this.logDeAcessoRepository.countByEmpresaIdAndOperacao(empresaId, Operacao.LOGIN) <= 1L) {
            return null;
        }
        LogDeAcesso log = this.logDeAcessoRepository.findTopByEmpresaIdAndOperacaoOrderByDataHoraDesc(empresaId, Operacao.LOGIN).orElse(null);
        if (NullUtil.isNotNull((Object)log)) {
            return log.getDataHora();
        }
        return null;
    }

    @Transactional
    public void updateDeliveryTimes(Empresa empresa) throws ApiException {
        Empresa emp = this.findById(empresa.getId());
        emp.setTempoDeEntrega(empresa.getTempoDeEntrega());
        emp.setTempoDeRetirada(empresa.getTempoDeRetirada());
        this.repository.save((Object)emp);
    }

    public void validate(Empresa empresa) throws ApiException {
        if (NullUtil.isNull((Object)empresa)) {
            throw new ApiException("msg.erro.001", new String[]{"Empresa"});
        }
        if (NullUtil.isNull((Object)empresa.getId())) {
            throw new ApiException("msg.erro.001", new String[]{"ID da Empresa"});
        }
        Empresa edit = this.findById(empresa.getId());
        if (NullUtil.isNull((Object)empresa.getRazaoSocial()) && NullUtil.isNull((Object)edit.getRazaoSocial())) {
            throw new ApiException("msg.erro.001", new String[]{"Raz\u00e3o Social"});
        }
        if (NullUtil.isNull((Object)empresa.getNomeFantasia()) && NullUtil.isNull((Object)edit.getNomeFantasia())) {
            throw new ApiException("msg.erro.001", new String[]{"Nome Fantasia"});
        }
        if (NullUtil.isNull((Object)empresa.getCep()) && NullUtil.isNull((Object)edit.getCep())) {
            throw new ApiException("msg.erro.001", new String[]{"CEP"});
        }
        if (NullUtil.isNull((Object)empresa.getLogradouro()) && NullUtil.isNull((Object)edit.getLogradouro())) {
            throw new ApiException("msg.erro.001", new String[]{"Logradouro"});
        }
        if (NullUtil.isNull((Object)empresa.getMunicipio()) && NullUtil.isNull((Object)edit.getMunicipio())) {
            throw new ApiException("msg.erro.001", new String[]{"Municipio"});
        }
        if (NullUtil.isNull((Object)empresa.getMunicipio().getNome()) && NullUtil.isNull((Object)edit.getMunicipio().getNome())) {
            throw new ApiException("msg.erro.001", new String[]{"Nome do Munic\u00edpio"});
        }
        if (NullUtil.isNull((Object)empresa.getMunicipio().getUf()) && NullUtil.isNull((Object)edit.getMunicipio().getUf())) {
            throw new ApiException("msg.erro.001", new String[]{"UF"});
        }
        if (NullUtil.isNull((Object)empresa.getSegmento()) && NullUtil.isNull((Object)empresa.getSegmento())) {
            throw new ApiException("msg.erro.001", new String[]{"Segmento"});
        }
    }

    public void validateSettings(Empresa empresa) throws ApiException {
        if (NullUtil.isNull((Object)empresa)) {
            throw new ApiException("msg.erro.001", new String[]{"Empresa"});
        }
        if (NullUtil.isNull((Object)empresa.getId())) {
            throw new ApiException("msg.erro.001", new String[]{"ID da Empresa"});
        }
        if (!StringUtil.isBlank((String)empresa.getIdStore()) && !CollectionUtils.isEmpty((Collection)this.repository.findByIdStoreAndIdNot(empresa.getIdStore(), empresa.getId()))) {
            throw new ApiException("erro.entidade.existente.m", new String[]{"Store ID"});
        }
    }

    @Transactional
    public void delete(Long id) throws ApiException {
        this.repository.deleteCompany(id);
    }

    public void deleteCompanyFiles(Long id) throws IOException, ApiException {
        FileUtil.deleteDirectory((String)this.fileService.getCompanyPath(id.toString(), null, Boolean.valueOf(true)));
    }

    public Page<Empresa> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) {
        return null;
    }

    public List<Empresa> findAll(Long empresaId) throws ApiException {
        return null;
    }

    @Transactional
    public void updateCompanyConfigs(List<EmpresaConfiguracao> configs) throws ApiException {
        configs.forEach(config -> {
            EmpresaConfiguracao edit = (EmpresaConfiguracao)this.empresaConfiguracaoRepository.findById((Object)config.getId()).get();
            edit.setValor(config.getValor());
            this.empresaConfiguracaoRepository.save((Object)edit);
        });
    }

    private EmpresaDto fromEntity(Empresa company, boolean loadLogo) throws ApiException {
        EmpresaDto dto = new EmpresaDto();
        dto.setId(company.getId());
        dto.setBairro(company.getBairro());
        dto.setCep(company.getCep());
        dto.setComplemento(company.getComplemento());
        dto.setUsuario(company.getUsuario());
        dto.setLogradouro(company.getLogradouro());
        dto.setMunicipio(company.getMunicipio());
        dto.setNomeAbreviado(company.getNomeAbreviado());
        dto.setNomeFantasia(company.getNomeFantasia());
        dto.setNumero(company.getNumero());
        dto.setRazaoSocial(company.getRazaoSocial());
        dto.setTelefonePrincipal(company.getTelefonePrincipal());
        dto.setTelefoneSecundario(company.getTelefoneSecundario());
        dto.setUrlSite(company.getUrlSite());
        dto.setTempoDeEntrega(company.getTempoDeEntrega());
        dto.setTempoDeRetirada(company.getTempoDeRetirada());
        dto.setUrlFacebook(company.getUrlFacebook());
        dto.setUrlInstagram(company.getUrlInstagram());
        dto.setUrlTwitter(company.getUrlTwitter());
        dto.setUrlYoutube(company.getUrlYoutube());
        dto.setIndWhatsapp(company.getWhatsapp());
        dto.setUrlAppAndroid(company.getUrlAppAndroid());
        dto.setUrlAppIos(company.getUrlAppIos());
        dto.setValorIsencaoEntrega(company.getValorIsencaoEntrega());
        dto.setAberto(company.getAberto());
        dto.setVersao(company.getVersao());
        dto.setVersaoAndroid(company.getVersaoAndroid());
        dto.setVersaoIOS(company.getVersaoIOS());
        dto.setVersaoVendas(company.getVersaoVendas());
        dto.setVersaoVendasAndroid(company.getVersaoVendasAndroid());
        dto.setVersaoVendasIos(company.getVersaoVendasIos());
        dto.setSobre(company.getSobre());
        dto.setAceitaPedidosAuto(company.getAceitaPedidosAuto());
        dto.setAceitaComandasAuto(company.getAceitaComandasAuto());
        dto.setValorTarifaUnica(company.getValorTarifaUnica());
        dto.setImprimePedidosAuto(company.getImprimePedidosAuto());
        dto.setEmailPagSeguro(company.getEmailPagSeguro());
        dto.setTokenPagSeguro(company.getTokenPagSeguro());
        dto.setDescontoPagamentoEmDinheiro(company.getDescontoPagamentoEmDinheiro());
        dto.setValorDescontoPagamentoEmDinheiro(company.getValorDescontoPagamentoEmDinheiro());
        dto.setParcelaMinima(company.getParcelaMinima());
        dto.setMaximoDeParcelas(company.getMaximoDeParcelas());
        dto.setTokenFcm(company.getTokenFcm());
        dto.setFusoHorario(company.getFusoHorario());
        dto.setIdStore(company.getIdStore());
        dto.setQuantidadeImpressoes(company.getQuantidadeImpressoes());
        dto.setFazDelivery(company.getFazDelivery());
        dto.setFazRetirada(company.getFazRetirada());
        dto.setImprimePedidosDistribuidosAuto(company.getImprimePedidosDistribuidosAuto());
        dto.setControleEstoque(Integer.valueOf(company.getControleEstoque().ordinal()));
        dto.setLatitude(company.getLatitude());
        dto.setLongitude(company.getLongitude());
        dto.setEmTeste(company.getEmTeste().booleanValue());
        dto.setFacebookPixelId(company.getFacebookPixelId());
        dto.setPorcentagemDoCashback(company.getPorcentagemDoCashback());
        dto.setValorPlano(company.getValorPlano());
        dto.setLimitePedidos(company.getLimitePedidos());
        dto.setValorPedidoExcedente(company.getValorPedidoExcedente());
        dto.setDiaVencimentoMensalidade(company.getDiaVencimentoMensalidade());
        dto.setPorcentagemOutraPlataforma(company.getPorcentagemOutraPlataforma());
        dto.setPorcentagemDaComissao(company.getPorcentagemDeComissao());
        dto.setAtivo(company.getAtivo().booleanValue());
        if (NullUtil.isNotNull((Object)company.getMatriz())) {
            company.getMatriz().getSegmento().setCaminhoFoto("https://imagens3.pedidoagora.com.br/".concat("segmentos/").concat(company.getMatriz().getSegmento().getCaminhoFoto()));
            dto.setSegmento(company.getMatriz().getSegmento());
        } else {
            company.getSegmento().setCaminhoFoto("https://imagens3.pedidoagora.com.br/".concat("segmentos/").concat(company.getSegmento().getCaminhoFoto()));
            dto.setSegmento(company.getSegmento());
        }
        if (loadLogo) {
            dto.setLogotipo(this.fileService.getCompanyUrl(company.getId(), null).concat("/").concat(company.getLogotipo()));
            if (StringUtil.isNotBlank((String)company.getLogotipoStore())) {
                dto.setLogotipoStore(this.fileService.getCompanyUrl(company.getId(), null).concat("/").concat(company.getLogotipoStore()));
            }
        }
        if (StringUtil.isNotBlank((String)company.getPlanoDeFundoStore())) {
            dto.setPlanoDeFundoStore(this.fileService.getCompanyUrl(company.getId(), null).concat("/").concat(company.getPlanoDeFundoStore()));
        }
        return dto;
    }

    private String getPathEmpresa(Long empresaId) throws ApiException {
        return this.fileService.getCompanyPath(empresaId.toString(), null, Boolean.valueOf(true));
    }

    private PreCadastroDaEmpresa populateCompanyPreRegistration(PreCadastroDaEmpresa preRegistration) throws ApiException {
        PreCadastroDaEmpresa edit = (PreCadastroDaEmpresa)this.companyPreRegistrationRepository.findById((Object)preRegistration.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Pr\u00e9-cadastro da Empresa", preRegistration.getId().toString()}));
        edit.setContato(preRegistration.getContato());
        edit.setTelefoneContato(StringUtil.removerMascara((String)preRegistration.getTelefoneContato()));
        edit.setEmailContato(preRegistration.getEmailContato());
        if (NullUtil.isNotNull((Object)preRegistration.getPlano())) {
            edit.setPlano(this.planService.findById(preRegistration.getPlano().getId()));
        }
        edit.setCnpjCpf(StringUtil.removerMascara((String)preRegistration.getCnpjCpf()));
        edit.setNomeFantasia(preRegistration.getNomeFantasia());
        edit.setNomeAbreviado(preRegistration.getNomeAbreviado());
        edit.setCep(StringUtil.removerMascara((String)preRegistration.getCep()));
        edit.setLogradouro(preRegistration.getLogradouro());
        edit.setNumero(preRegistration.getNumero());
        edit.setBairro(preRegistration.getBairro());
        edit.setComplemento(preRegistration.getComplemento());
        if (NullUtil.isNotNull((Object)preRegistration.getSegmento()) && NullUtil.isNotNullOrZero((Number)preRegistration.getSegmento().getId())) {
            edit.setSegmento((Segmento)this.segmentRepository.findById((Object)preRegistration.getSegmento().getId()).get());
        }
        if (NullUtil.isNotNull((Object)preRegistration.getMunicipio()) && NullUtil.isNotNullOrZero((Number)preRegistration.getMunicipio().getIbgeId())) {
            edit.setMunicipio((Municipio)this.cityRepository.findByIbgeId(preRegistration.getMunicipio().getIbgeId()).get());
        }
        if (NullUtil.isNotNull((Object)preRegistration.getParceiro())) {
            edit.setParceiro(this.partnerService.findById(preRegistration.getParceiro().getId()));
        }
        edit.setReceberInformativos(preRegistration.getReceberInformativos());
        edit.setFinalizado(preRegistration.getFinalizado());
        edit.setSenha(preRegistration.getSenha());
        return edit;
    }

    public Optional<IdentificacaoDaEmpresa> identifyCompany(Long companyId) {
        return this.companyIdentifyRepository.findById((Object)companyId);
    }
}

