/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.service;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.EmpresaProdutoEmDestaque;
import com.escolpi.omni.api.model.specification.builder.EmpresaProdutoEmDestaqueSpecificationBuilder;
import com.escolpi.omni.api.repository.EmpresaProdutoEmDestaqueRepository;
import com.escolpi.omni.api.service.FileService;
import com.escolpi.omni.api.service.impl.BaseCrudService;
import com.escolpi.omni.api.util.CriteriaUtil;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.FileUtil;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class EmpresaProdutoEmDestaqueService
implements BaseCrudService<EmpresaProdutoEmDestaque, Long> {
    @Autowired
    private EmpresaProdutoEmDestaqueRepository repository;
    @Autowired
    private FileService fileService;

    @Transactional
    public void delete(Long id) throws ApiException {
        try {
            EmpresaProdutoEmDestaque exclusao = (EmpresaProdutoEmDestaque)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Produto em Destaque", id.toString()}));
            this.repository.deleteById((Object)id);
            String path = this.getPathDestaques(exclusao.getProduto().getEmpresa().getId()) + File.separator + exclusao.getCaminhoFoto();
            FileUtil.deleteFile((String)path);
        }
        catch (Exception e) {
            throw new ApiException("erro.api.padrao", new String[]{e.getMessage()});
        }
    }

    public Page<EmpresaProdutoEmDestaque> filter(String searchCriteria, int pageNumber, List<String> sortBy, String sortDirection, Integer entriesByPage) throws ApiException {
        EmpresaProdutoEmDestaqueSpecificationBuilder builder = new EmpresaProdutoEmDestaqueSpecificationBuilder(searchCriteria);
        Specification spec = builder.build();
        List orders = CriteriaUtil.makeOrderList(sortBy, (String)sortDirection);
        PageRequest pageable = PageRequest.of((int)pageNumber, (int)entriesByPage, (Sort)Sort.by((List)orders));
        Page page = this.repository.findAll(spec, (Pageable)pageable);
        if (!CollectionUtils.isEmpty((Collection)page.getContent())) {
            for (EmpresaProdutoEmDestaque destaque : page.getContent()) {
                if (!destaque.getFotoExterna().booleanValue()) continue;
                destaque.setFoto(destaque.getCaminhoFoto());
            }
        }
        return page;
    }

    public List<EmpresaProdutoEmDestaque> findAll(Long empresaId) throws ApiException {
        return this.repository.findByEmpresaIdAndProdutoEmFaltaIsFalseAndExibirIsTrueOrderByProdutoIdDesc(empresaId);
    }

    public EmpresaProdutoEmDestaque findById(Long id) throws ApiException {
        return (EmpresaProdutoEmDestaque)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Produto em Destaque", id.toString()}));
    }

    public EmpresaProdutoEmDestaque findById(Long id, Long empresaId) throws ApiException {
        EmpresaProdutoEmDestaque destaque = (EmpresaProdutoEmDestaque)this.repository.findById((Object)id).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Produto em Destaque", id.toString()}));
        if (StringUtil.isNotBlank((String)destaque.getCaminhoFoto()) && !destaque.getFotoExterna().booleanValue()) {
            destaque.setFoto(this.fileService.getPictureUrl(destaque, false));
        }
        if (!destaque.getProduto().getEmpresa().getId().equals(empresaId)) {
            throw new ApiException("erro.nao.vinculado", new String[]{Entidade.PRODUTO_DESTAQUE.getDescricao()});
        }
        return destaque;
    }

    public EmpresaProdutoEmDestaque findByProdutoId(Long productId) {
        return this.repository.findByProdutoId(productId).orElse(null);
    }

    @Transactional
    public void save(EmpresaProdutoEmDestaque destaque) throws ApiException {
        this.validate(destaque);
        String path = this.getPathDestaques(destaque.getProduto().getEmpresa().getId()) + File.separator;
        if (NullUtil.isNotNullOrZero((Number)destaque.getId())) {
            EmpresaProdutoEmDestaque edicao = (EmpresaProdutoEmDestaque)this.repository.findById((Object)destaque.getId()).orElseThrow(() -> new ApiException("erro.entidade.nao.encontrado", new String[]{"Produto em Destaque", destaque.getId().toString()}));
            if (destaque.getFotoExterna().booleanValue()) {
                if (FileUtil.fileExists((String)(this.getPathDestaques(edicao.getProduto().getEmpresa().getId()) + File.separator + edicao.getCaminhoFoto()))) {
                    FileUtil.deleteFile((String)(this.getPathDestaques(edicao.getProduto().getEmpresa().getId()) + File.separator + edicao.getCaminhoFoto()));
                }
            } else if (StringUtil.isNotBlank((String)destaque.getCaminhoFoto())) {
                FileUtil.deleteFile((String)(this.getPathDestaques(edicao.getProduto().getEmpresa().getId()) + File.separator + edicao.getCaminhoFoto()));
                edicao.setCaminhoFoto(this.generatePictureName(edicao));
                path = path + edicao.getCaminhoFoto();
                this.fileService.saveBase64File(path, destaque.getFoto());
                this.fileService.saveThumbnailFile(path, destaque.getFoto(), 640);
            }
            edicao.setFotoExterna(destaque.getFotoExterna());
            edicao.setExibir(destaque.getExibir());
            edicao.setExibirPreco(destaque.getExibirPreco());
            edicao.setProduto(destaque.getProduto());
            edicao.setTitulo(destaque.getTitulo());
            edicao.setPromocional(NullUtil.isNotNull((Object)destaque.getPromocional()) ? destaque.getPromocional() : Boolean.FALSE);
            this.repository.save((Object)edicao);
        } else if (destaque.getFotoExterna().booleanValue()) {
            this.repository.save((Object)destaque);
        } else {
            destaque.setCaminhoFoto(this.generatePictureName(destaque));
            this.repository.save((Object)destaque);
            path = path + destaque.getCaminhoFoto();
            this.fileService.saveBase64File(path, destaque.getFoto());
            this.fileService.saveThumbnailFile(path, destaque.getFoto(), 640);
        }
    }

    public String gerarNomeImagem(Long produtoId, String nomeArquivo) {
        return DateUtil.format((String)"yyyyMMdd", (Date)new Date()) + ("_" + produtoId) + StringUtil.obterExtensao((String)nomeArquivo).toLowerCase();
    }

    private String generatePictureName(EmpresaProdutoEmDestaque destaque) {
        return DateUtil.format((String)"yyyyMMdd", (Date)new Date()) + "_" + destaque.getProduto().getId() + StringUtil.obterExtensao((String)destaque.getCaminhoFoto());
    }

    private String getPathDestaques(Long empresaId) throws ApiException {
        return this.fileService.getCompanyGaleryPath(empresaId, "destaques");
    }

    public void validate(EmpresaProdutoEmDestaque destaque) throws ApiException {
        if (NullUtil.isNull((Object)destaque)) {
            throw new ApiException("msg.erro.001", new String[]{"Produto em Destaque"});
        }
        if (NullUtil.isNull((Object)destaque.getProduto())) {
            throw new ApiException("msg.erro.001", new String[]{"Produto"});
        }
        if (!destaque.getFotoExterna().booleanValue() && NullUtil.isNullOrZero((Number)destaque.getId()) && StringUtil.isBlank((String)destaque.getFoto())) {
            throw new ApiException("msg.erro.001", new String[]{"Foto do Destaque"});
        }
        if (NullUtil.isNotNullOrZero((Number)destaque.getId()) ? this.repository.countByProdutoIdAndIdNot(destaque.getProduto().getId(), destaque.getId()) > 0L : this.repository.countByProdutoId(destaque.getProduto().getId()) > 0L) {
            throw new ApiException("erro.entidade.existente.m", new String[]{"Produto em Destaque"});
        }
    }
}

