/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.security.service;

import com.escolpi.omni.api.domain.Message;
import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Cliente;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.Usuario;
import com.escolpi.omni.api.model.projection.EmpresaView;
import com.escolpi.omni.api.repository.ClienteRepository;
import com.escolpi.omni.api.repository.EmpresaRepository;
import com.escolpi.omni.api.service.LogDeAcessoService;
import com.escolpi.omni.api.service.UsuarioService;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import java.util.Collection;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

@Service
public class AuthService
implements UserDetailsService {
    @Autowired
    private ClienteRepository clienteRepository;
    @Autowired
    private EmpresaRepository empresaRepository;
    @Autowired
    private LogDeAcessoService logService;
    @Autowired
    private UsuarioService usuarioService;
    public static final Logger LOGGER = LoggerFactory.getLogger(AuthService.class);

    public UserDetails loadUserByUsername(String credencial) throws UsernameNotFoundException {
        if (credencial.contains(":") && credencial.split(":").length >= 3) {
            return this.loginToCustomer(credencial);
        }
        if (credencial.contains(":") && credencial.split(":").length == 2) {
            return this.loginToRoot(credencial);
        }
        if (credencial.contains("@@")) {
            return this.loginWithSeller(credencial);
        }
        return this.loginToCompany(credencial);
    }

    private Collection<? extends GrantedAuthority> getPermissoes(Usuario usuario) {
        HashSet authorities = new HashSet();
        usuario.getPerfil().getPermissoes().forEach(permissao -> authorities.add(new SimpleGrantedAuthority(permissao.getDescricao().toUpperCase())));
        return authorities;
    }

    private UserDetails loginToCustomer(String credencial) {
        String[] credenciais = credencial.split(":");
        try {
            if (StringUtil.isNumericString((String)credenciais[0])) {
                throw new UsernameNotFoundException(Message.getInstance().getMessage("erro.autenticacao.usuario.login.email"));
            }
            Cliente cliente = (Cliente)this.clienteRepository.findByLoginAndEmpresaId(credenciais[0], new Long(credenciais[1])).orElseThrow(() -> new UsernameNotFoundException(Message.getInstance().getMessage("erro.autenticacao.usuario.nao.encontrado")));
            String username = cliente.getUsuario().getLogin() + ":" + cliente.getEmpresa().getId();
            if (cliente.getUsuario().getBloqueado().booleanValue()) {
                new ApiException("erro.usuario.cliente.bloqueado");
            }
            return new User(username, cliente.getUsuario().getSenha(), this.getPermissoes(cliente.getUsuario()));
        }
        catch (UsernameNotFoundException e) {
            try {
                this.logService.save(new Long(credenciais[1]), Entidade.USUARIO, Operacao.LOGIN, e.getMessage());
            }
            catch (ApiException ex) {
                LOGGER.error(Message.getInstance().getMessage("erro.api.padrao", new String[]{ex.getMessage()}));
            }
            throw e;
        }
    }

    private UserDetails loginToCompany(String credencial) {
        EmpresaView company = new EmpresaView();
        try {
            company = (EmpresaView)this.empresaRepository.getByLogin(credencial).orElseThrow(() -> new UsernameNotFoundException(Message.getInstance().getMessage("erro.autenticacao.usuario.nao.encontrado")));
            company.setUsuario((Usuario)this.empresaRepository.getUserByCompany(company.getId()).get());
            if (!company.getAtivo().booleanValue()) {
                new ApiException("erro.usuario.empresa.bloqueada");
            }
            try {
                this.logService.save(company.getId(), Entidade.USUARIO, Operacao.LOGIN, "Empresa " + company.getNomeFantasia() + " logada com sucesso!");
            }
            catch (ApiException e) {
                LOGGER.error(Message.getInstance().getMessage("erro.api.padrao", new String[]{e.getMessage()}));
            }
            return new User(company.getUsuario().getLogin(), company.getUsuario().getSenha(), this.getPermissoes(company.getUsuario()));
        }
        catch (UsernameNotFoundException e) {
            try {
                if (NullUtil.isNotNull((Object)company) && NullUtil.isNotNullOrZero((Number)company.getId())) {
                    this.logService.save(company.getId(), Entidade.USUARIO, Operacao.LOGIN, e.getMessage());
                }
            }
            catch (ApiException ex) {
                LOGGER.error(Message.getInstance().getMessage("erro.api.padrao", new String[]{ex.getMessage()}));
            }
            throw e;
        }
    }

    private UserDetails loginToRoot(String credencial) {
        Usuario root;
        Empresa empresa;
        String[] credenciais = credencial.split(":");
        try {
            empresa = (Empresa)this.empresaRepository.findById((Object)new Long(credenciais[1])).get();
            root = this.usuarioService.findRootByLogin(credenciais[0]);
        }
        catch (ApiException e) {
            throw new UsernameNotFoundException(e.getMessage());
        }
        try {
            this.logService.save(empresa.getId(), Entidade.USUARIO, Operacao.LOGIN, "Administrador logado na empresa " + empresa.getNomeFantasia() + " logada com sucesso!");
        }
        catch (ApiException e) {
            LOGGER.error(Message.getInstance().getMessage("erro.api.padrao", new String[]{e.getMessage()}));
        }
        return new User(root.getLogin(), root.getSenha(), this.getPermissoes(root));
    }

    private UserDetails loginWithSeller(String credencial) {
        try {
            String login = credencial.split("@@")[0];
            Usuario vendor = StringUtil.isNumericString((String)login) ? this.usuarioService.findVendorByCompanyTelephone(new Long(credencial.split("@@")[1]), credencial.split("@@")[0]) : this.usuarioService.findVendorByLoginAndCompany(new Long(credencial.split("@@")[1]), credencial.split("@@")[0]);
            return new User(vendor.getLogin(), vendor.getSenha(), this.getPermissoes(vendor));
        }
        catch (ApiException e) {
            throw new UsernameNotFoundException(e.getMessage());
        }
    }
}

