/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.scheduled;

import com.escolpi.omni.api.enumeration.SituacaoDoPedido;
import com.escolpi.omni.api.repository.ClienteRepository;
import com.escolpi.omni.api.repository.ItemDoPedidoRepository;
import com.escolpi.omni.api.repository.PedidoRepository;
import com.escolpi.omni.api.repository.PersonalizacaoRepository;
import com.escolpi.omni.api.repository.ValorDaPersonalizacaoRepository;
import com.escolpi.omni.api.util.DateUtil;
import com.escolpi.omni.api.util.LoggerUtil;
import java.time.LocalDate;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class PedidoSchedule {
    @Autowired
    private ClienteRepository usuarioRepository;
    @Autowired
    private ItemDoPedidoRepository itemDoPedidoRepository;
    @Autowired
    private PedidoRepository pedidoRepository;
    @Autowired
    private PersonalizacaoRepository personalizacaoRepository;
    @Autowired
    private ValorDaPersonalizacaoRepository valorDaPersonalizacaoRepository;

    public void excluirHistoricoDePedidosApos90Dias() {
        LoggerUtil.log((String)"*** EXCLUIR PEDIDOS ENCERRADOS OU CANCELADOS NOS \u00daLTIMOS 90 DIAS***");
        Date diasDeDiferenca = DateUtil.obterDiferencaEmDias((LocalDate)LocalDate.now(), (int)90);
        SituacaoDoPedido[] situacoes = new SituacaoDoPedido[]{SituacaoDoPedido.FINALIZADO, SituacaoDoPedido.CANCELADO};
        this.usuarioRepository.findAll().forEach(cliente -> {
            LoggerUtil.info((String)String.format("Obtendo hist\u00f3rico de pedidos do cliente %s <%s>...", cliente.getNome(), cliente.getUsuario().getLogin()));
            Long totalNoHistorico = this.pedidoRepository.countEncerradosOuCanceladosNosUltimos90Dias(cliente.getId(), diasDeDiferenca, situacoes);
            if (totalNoHistorico.intValue() > 15) {
                this.pedidoRepository.findEncerradosOuCanceladosNosUltimos90Dias(cliente.getId(), diasDeDiferenca, (Pageable)PageRequest.of((int)0, (int)15), situacoes).forEach(pedido -> {
                    LoggerUtil.log((String)String.format("Excluindo o pedido n\u00ba %s realizado em <%s>...", pedido.getId(), DateUtil.format((String)"dd/MM/yyyy '\u00e0s' HH:mm:ss", (Date)pedido.getDataAtualizacaoPedido())));
                    this.itemDoPedidoRepository.findByPedidoId(pedido.getId()).forEach(item -> this.itemDoPedidoRepository.deleteById((Object)item.getId()));
                    this.pedidoRepository.deleteById((Object)pedido.getId());
                    LoggerUtil.success((String)String.format("Pedido n\u00ba %s exclu\u00eddo com sucesso!", pedido.getId()));
                });
                LoggerUtil.info((String)"Obtendo valores de personaliza\u00e7\u00e3o n\u00e3o utilizadas para exclus\u00e3o...");
                if (this.valorDaPersonalizacaoRepository.countValoresDaPersonalizacaoUtilizados() > 0L) {
                    this.valorDaPersonalizacaoRepository.listarValoresDaPersonalizacaoExcluidas().forEach(valor -> {
                        this.valorDaPersonalizacaoRepository.deleteById((Object)valor.getId());
                        LoggerUtil.info((String)"Obtendo personaliza\u00e7\u00f5es n\u00e3o utilizadas para exclus\u00e3o...");
                        if (this.valorDaPersonalizacaoRepository.countValoresDaPersonalizacaoComPersonalizacoesNaoUtilizadas(valor.getPersonalizacao().getId()) > 0L) {
                            this.personalizacaoRepository.deleteById((Object)valor.getPersonalizacao().getId());
                        } else {
                            LoggerUtil.info((String)"Nenhuma personaliza\u00e7\u00e3o n\u00e3o utilizada encontrada para excluir.");
                        }
                    });
                    LoggerUtil.info((String)"Obtendo personaliza\u00e7\u00f5es n\u00e3o utilizadas para exclus\u00e3o...");
                } else {
                    LoggerUtil.info((String)"Nenhum valor de personaliza\u00e7\u00e3o n\u00e3o utilizada encontrada para excluir.");
                }
            } else {
                LoggerUtil.info((String)"Nenhum hist\u00f3rico para excluir.");
            }
        });
    }
}

