/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.pub;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.HorarioDeFuncionamento;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.model.entity.api.CategoriaDoProdutoApi;
import com.escolpi.omni.api.model.entity.api.OpcaoDePagamentoApi;
import com.escolpi.omni.api.model.projection.EmpresaProdutoEmDestaqueView;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.CatalogoService;
import com.escolpi.omni.api.service.EmpresaService;
import com.escolpi.omni.api.service.PedidoService;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/public/empresas/{empresaId}"})
public class ConsultarEmpresaResource
extends BaseResource {
    @Autowired
    private CatalogoService catalogoService;
    @Autowired
    private EmpresaService empresaService;
    @Autowired
    private PedidoService pedidoService;

    @GetMapping(value={"/horarios-de-funcionamento"})
    public List<HorarioDeFuncionamento> getHorariosDeFuncionamento(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return this.empresaService.listarHorariosDeFuncionamentoPorEmpresa(empresaId);
    }

    @GetMapping(value={"/opcoes-de-pagamento"})
    public List<OpcaoDePagamentoApi> getOpcoesDePagamento(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return this.empresaService.listarOpcoesDePagamentoDaEmpresa(empresaId);
    }

    @GetMapping(value={"/categorias"})
    public List<CategoriaDoProdutoApi> getCategorias(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return this.catalogoService.listarCategoriasDoProdutoApiPorEmpresa(empresaId);
    }

    @GetMapping(value={"/produtos-em-destaque"})
    public List<EmpresaProdutoEmDestaqueView> listarProdutosEmDestaqueDaEmpresa(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return this.catalogoService.listarProdutosEmDestaquePorEmpresa(empresaId);
    }

    @Deprecated
    @PostMapping(value={"/pedido-na-mesa"})
    public void incluirPedido(@PathVariable Long empresaId, @RequestBody Pedido pedido) throws ApiException, JsonProcessingException {
        if (!CollectionUtils.isEmpty((Collection)pedido.getItensDoPedido())) {
            pedido.getItensDoPedido().forEach(item -> item.setId(null));
        }
        if (!CollectionUtils.isEmpty((Collection)pedido.getCestasDePromocao())) {
            pedido.getCestasDePromocao().forEach(item -> item.setId(null));
        }
        this.pedidoService.saveOrder(pedido, empresaId, false);
        System.gc();
    }
}

