/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.concentre;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Cliente;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.model.entity.Produto;
import com.escolpi.omni.api.model.entity.Usuario;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.ClienteService;
import com.escolpi.omni.api.service.EmpresaService;
import com.escolpi.omni.api.service.LogDeAcessoService;
import com.escolpi.omni.api.service.PedidoService;
import com.escolpi.omni.api.service.ProdutoService;
import com.escolpi.omni.api.service.UsuarioService;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/concentre/{companyId}"})
public class ConcentreResource
extends BaseResource {
    @Autowired
    private EmpresaService companyService;
    @Autowired
    private ClienteService customerService;
    @Autowired
    private LogDeAcessoService logService;
    @Autowired
    private PedidoService orderService;
    @Autowired
    private ProdutoService productService;
    @Autowired
    private UsuarioService userService;

    @PostMapping(value={"/sync/customer"})
    public boolean createCustomerFromConcentre(@PathVariable Long companyId, @RequestBody List<Cliente> customers) throws ApiException {
        try {
            return this.customerService.saveFromPDV(companyId, customers);
        }
        catch (Exception e) {
            this.logService.save(companyId, Entidade.CLIENTE, Operacao.INCLUSAO, e.getMessage());
            return false;
        }
    }

    @DeleteMapping(value={"/"})
    public void deleteProdutosByConcentre(@PathVariable(value="companyId") Long companyId, @RequestBody List<String> codigosAtos) throws ApiException {
        try {
            this.productService.deleteByConcentrePDV(companyId, codigosAtos);
        }
        catch (ApiException e) {
            this.logService.save(companyId, Entidade.PRODUTO, Operacao.EXCLUSAO, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/has-new-orders"})
    public boolean hasNewOrders(@PathVariable Long companyId) throws ApiException {
        return this.orderService.hasNewOrders(companyId);
    }

    @GetMapping(value={"/opening-state"})
    public boolean storeIsOpened(@PathVariable Long companyId) throws ApiException {
        return this.companyService.getOpeningState(companyId);
    }

    @PostMapping(value={"/pedidos/importados"})
    public ResponseEntity<Object> receiveImportedOrders(@RequestBody List<Long> importedOrders) {
        this.orderService.setImportedOrders(importedOrders);
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body(null);
    }

    @PostMapping(value={"/sync/seller"})
    public boolean createSellerFromConcentre(@PathVariable Long companyId, @RequestBody List<Usuario> sellers) throws ApiException {
        try {
            return this.userService.saveSellerFromPDV(companyId, sellers);
        }
        catch (Exception e) {
            this.logService.save(companyId, Entidade.USUARIO, Operacao.INCLUSAO, e.getMessage());
            return false;
        }
    }

    @PutMapping(value={"/sync/customer"})
    public boolean updateCustomerFromConcentre(@PathVariable Long companyId, @RequestBody List<Cliente> customers) throws ApiException {
        try {
            return this.customerService.saveFromPDV(companyId, customers);
        }
        catch (Exception e) {
            this.logService.save(companyId, Entidade.CLIENTE, Operacao.INCLUSAO, e.getMessage());
            return false;
        }
    }

    @PutMapping(value={"/alterar-situacao"})
    public void updatePedidosByConcentre(@PathVariable(value="companyId") Long companyId, @RequestBody List<Pedido> pedidos) throws ApiException, IOException, InterruptedException {
        try {
            this.orderService.updatePedidosByPDV(pedidos);
        }
        catch (ApiException e) {
            this.logService.save(companyId, Entidade.PEDIDO, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/alterar-valor-produto"})
    public void updatePrice(@PathVariable(value="companyId") Long companyId, @RequestParam(value="codigoAtos") String codigoAtos, @RequestParam(value="valor") Double valor) throws ApiException {
        try {
            this.productService.updatePrice(companyId, codigoAtos, valor);
        }
        catch (ApiException e) {
            this.logService.save(companyId, Entidade.PRODUTO, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/atualizar-produtos"})
    public void updateProdutosByConcentre(@PathVariable(value="companyId") Long companyId, @RequestBody List<Produto> produtos) throws ApiException {
        try {
            this.productService.updateProdutosFromPDV(produtos);
        }
        catch (ApiException e) {
            this.logService.save(companyId, Entidade.PRODUTO, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/sync/seller"})
    public void updateSaller(@PathVariable Long companyId, @RequestBody List<Usuario> sallers) {
    }

    @GetMapping(value={"/verificar-bloqueio"})
    public ResponseEntity<Boolean> verificarBloqueioEmpresa(@PathVariable(value="companyId") Long companyId) throws ApiException {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.companyService.companyIsLocked(companyId));
    }
}

