/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Usuario;
import com.escolpi.omni.api.service.LogDeAcessoService;
import com.escolpi.omni.api.service.UsuarioService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/usuarios/{companyId}/{profileId}"})
public class ManterUsuarioResource {
    private Entidade entity = Entidade.CATEGORIA_DO_PRODUTO;
    @Autowired
    private UsuarioService service;
    @Autowired
    private LogDeAcessoService logService;

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_USUARIO_EXCLUIR') and #oauth2.hasScope('write')")
    public void delete(@PathVariable Long companyId, @PathVariable Long id) throws ApiException {
        try {
            this.service.delete(id);
        }
        catch (ApiException e) {
            this.logService.save(companyId, this.entity, Operacao.EXCLUSAO, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/filter"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_USUARIO_LISTAR') and #oauth2.hasScope('write')")
    public Page<Usuario> filter(@PathVariable Long companyId, @PathVariable Long profileId, @RequestParam(value="search") String search, @RequestParam(value="numeroPagina") Integer pageNumber, @RequestParam(value="sortBy") List<String> sortBy, @RequestParam(value="sortDirection") String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        search = search + "@@perfilId:" + profileId + "@@" + "excluido:false";
        return this.service.filter(search, pageNumber.intValue(), sortBy, sortDirection, entriesByPage);
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_USUARIO_OBTER') and #oauth2.hasScope('write')")
    public Usuario get(@PathVariable Long companyId, @PathVariable Long id) throws ApiException {
        return this.service.findById(id);
    }

    @PutMapping(value={"/lock-user/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_USUARIO_EDITAR') and #oauth2.hasScope('write')")
    public void lockUser(@PathVariable Long id) throws ApiException {
        this.service.toggleUserLock(id);
    }

    @PostMapping
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_USUARIO_CRIAR') and #oauth2.hasScope('write')")
    public void save(@PathVariable Long companyId, @RequestBody Usuario user) throws ApiException {
        try {
            this.service.save(user);
        }
        catch (ApiException e) {
            this.logService.save(companyId, this.entity, Operacao.INCLUSAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_USUARIO_EDITAR') and #oauth2.hasScope('write')")
    public void update(@PathVariable Long companyId, @RequestBody Usuario user) throws ApiException {
        try {
            this.service.save(user);
        }
        catch (ApiException e) {
            this.logService.save(companyId, this.entity, Operacao.INCLUSAO, e.getMessage());
            throw e;
        }
    }
}

