/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.TarifacaoDeEntrega;
import com.escolpi.omni.api.model.entity.dto.Option;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.resource.impl.BaseCrudResource;
import com.escolpi.omni.api.service.LogDeAcessoService;
import com.escolpi.omni.api.service.TarifacaoDeEntregaService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/tarifacoes-entrega/{empresaId}"})
public class ManterTarifacaoDeEntregaResource
extends BaseResource
implements BaseCrudResource<TarifacaoDeEntrega, Long> {
    private Entidade entidade = Entidade.TARIFACAO_DE_ENTREGA;
    @Autowired
    private LogDeAcessoService logService;
    @Autowired
    private TarifacaoDeEntregaService service;

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFACAO_ENTREGA_EXCLUIR') and #oauth2.hasScope('write')")
    public void delete(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="id") Long id) throws ApiException {
        try {
            this.service.delete(id);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.EXCLUSAO, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/filter"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFACAO_ENTREGA_LISTAR') and #oauth2.hasScope('read')")
    public Page<TarifacaoDeEntrega> filter(@PathVariable(value="empresaId") Long empresaId, @RequestParam(value="search") String search, @RequestParam(value="numeroPagina") Integer numeroPagina, @RequestParam(value="sortBy") List<String> sortBy, @RequestParam(value="sortDirection") String sortDirection, @RequestParam(value="entriesByPage") Integer entriesByPage) throws ApiException {
        return this.service.filter(search, numeroPagina.intValue(), sortBy, sortDirection, entriesByPage);
    }

    @GetMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFACAO_ENTREGA_OBTER') and #oauth2.hasScope('read')")
    public TarifacaoDeEntrega get(@PathVariable(value="empresaId") Long empresaId, @PathVariable(value="id") Long id) throws ApiException {
        try {
            return this.service.findById(id, empresaId);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFACAO_ENTREGA_LISTAR') and #oauth2.hasScope('read')")
    public List<TarifacaoDeEntrega> list(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        try {
            return this.service.findAll(empresaId);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/cidades"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_BAIRRO_NAO_ATENDIDO_LISTAR') and #oauth2.hasScope('read')")
    public List<Option> listOptionCities(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        try {
            return this.service.listCitiesByCompanyId(empresaId);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @PostMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFACAO_ENTREGA_CRIAR') and #oauth2.hasScope('write')")
    public void save(@PathVariable(value="empresaId") Long empresaId, @RequestBody TarifacaoDeEntrega tarifacao) throws ApiException {
        try {
            this.service.save(tarifacao);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.INCLUSAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_TARIFACAO_ENTREGA_EDITAR') and #oauth2.hasScope('write')")
    public void update(@PathVariable(value="empresaId") Long empresaId, @RequestBody TarifacaoDeEntrega tarifacao) throws ApiException {
        try {
            this.service.save(tarifacao);
        }
        catch (ApiException e) {
            this.logService.save(empresaId, this.entidade, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }
}

