/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.MunicipioAtendido;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.resource.impl.BaseCrudResource;
import com.escolpi.omni.api.service.EmpresaService;
import com.escolpi.omni.api.service.MunicipioAtendidoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/municipios-atendidos/{empresaId}"})
public class ManterMunicipioAtendidoResource
extends BaseResource
implements BaseCrudResource<MunicipioAtendido, Long> {
    @Autowired
    private MunicipioAtendidoService service;
    @Autowired
    private EmpresaService empresaService;

    @DeleteMapping(value={"/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_MUNICIPIO_ATENDIDO_EXCLUIR') and #oauth2.hasScope('write')")
    public void delete(@PathVariable(value="empresaId") Long empresaId, @PathVariable Long id) throws ApiException {
        this.empresaService.detachCity(empresaId, id);
    }

    @DeleteMapping(value={"/all"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_MUNICIPIO_ATENDIDO_EXCLUIR') and #oauth2.hasScope('write')")
    public void deleteAll(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        this.empresaService.detachAllCity(empresaId);
    }

    @PutMapping(value={"/update-values"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_MUNICIPIO_ATENDIDO_CRIAR') and #oauth2.hasScope('write')")
    public void updateValues(@PathVariable(value="empresaId") Long empresaId, @RequestBody List<MunicipioAtendido> cities) throws ApiException {
        this.service.updateValues(empresaId, cities);
    }

    public MunicipioAtendido get(Long empresaId, Long id) throws ApiException {
        return null;
    }

    public Page<MunicipioAtendido> filter(Long empresaId, String search, Integer numeroPagina, List<String> sortBy, String sortDirection, Integer entriesByPage) throws ApiException {
        return null;
    }

    @GetMapping
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_MUNICIPIO_ATENDIDO_LISTAR') and #oauth2.hasScope('read')")
    public List<MunicipioAtendido> list(@PathVariable(value="empresaId") Long empresaId) throws ApiException {
        return this.empresaService.findByEmpresaId(empresaId);
    }

    @PostMapping
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_MUNICIPIO_ATENDIDO_CRIAR') and #oauth2.hasScope('write')")
    public void save(@PathVariable Long empresaId, @RequestBody MunicipioAtendido attendedCity) throws ApiException {
        this.service.saveAttendedCity(attendedCity);
    }

    public void update(Long empresaId, MunicipioAtendido entity) throws ApiException {
    }
}

