/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource.admin;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Configuracao;
import com.escolpi.omni.api.model.entity.EmpresaConfiguracao;
import com.escolpi.omni.api.service.ConfiguracaoService;
import com.escolpi.omni.api.service.EmpresaService;
import com.escolpi.omni.api.service.LogDeAcessoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/admin/configuracoes/{companyId}"})
public class ManterConfiguracoesResource {
    private Entidade configEntity = Entidade.CONFIGURACAO;
    private Entidade entity = Entidade.EMPRESA_CONFIGURACAO;
    @Autowired
    private ConfiguracaoService service;
    @Autowired
    private EmpresaService companyService;
    @Autowired
    private LogDeAcessoService logService;

    @GetMapping(value={"filter/{configName}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_OBTER') and #oauth2.hasScope('read')")
    public List<EmpresaConfiguracao> filter(@PathVariable Long companyId, @PathVariable String configName) throws ApiException {
        return this.service.findByCompanyIdAndConfigName(companyId, configName);
    }

    @PostMapping(value={"/config"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_EDITAR') and #oauth2.hasScope('write')")
    public void createConfig(@PathVariable Long companyId, @RequestBody Configuracao config) throws ApiException {
        try {
            this.service.save(config);
        }
        catch (ApiException e) {
            this.logService.save(companyId, this.configEntity, Operacao.INCLUSAO, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/config/{id}"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_OBTER') and #oauth2.hasScope('write')")
    public Configuracao getConfig(@PathVariable Long companyId, @PathVariable Long id) throws ApiException {
        try {
            return this.service.findById(id);
        }
        catch (Exception e) {
            this.logService.save(companyId, this.entity, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @GetMapping
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_OBTER') and #oauth2.hasScope('read')")
    public List<EmpresaConfiguracao> getCompanyConfigs(@PathVariable Long companyId) throws ApiException {
        return this.companyService.listCompanyConfigs(companyId);
    }

    @PutMapping
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_EDITAR') and #oauth2.hasScope('write')")
    public void update(@PathVariable Long companyId, @RequestBody List<EmpresaConfiguracao> configs) throws ApiException {
        try {
            this.companyService.updateCompanyConfigs(configs);
        }
        catch (ApiException e) {
            this.logService.save(companyId, this.entity, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }

    @PutMapping(value={"/config"})
    @PreAuthorize(value="hasAuthority('ROLE_ADMIN_EMPRESA_EDITAR') and #oauth2.hasScope('write')")
    public void updateConfig(@PathVariable Long companyId, @RequestBody Configuracao config) throws ApiException {
        try {
            this.service.save(config);
        }
        catch (ApiException e) {
            this.logService.save(companyId, this.configEntity, Operacao.ALTERACAO, e.getMessage());
            throw e;
        }
    }
}

