/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.enumeration.Entidade;
import com.escolpi.omni.api.enumeration.Operacao;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CestaDePromocao;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.service.LogDeAcessoService;
import com.escolpi.omni.api.service.MessengerService;
import com.escolpi.omni.api.service.PedidoService;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sem-cadastro/{companyId}/pedidos"})
public class PedidoSemCadastroResource {
    @Autowired
    private PedidoService service;
    @Autowired
    private MessengerService messengerService;
    @Autowired
    private LogDeAcessoService logService;

    @PutMapping(value={"/cancelar/{orderId}"})
    public ResponseEntity<Boolean> cancelOrder(@PathVariable Long companyId, @PathVariable Long orderId) throws ApiException {
        try {
            this.service.cancelGuestOrder(orderId, true);
            return new ResponseEntity((Object)true, HttpStatus.OK);
        }
        catch (ApiException e) {
            this.logService.save(companyId, Entidade.PEDIDO, Operacao.CONSULTA, e.getMessage());
            throw e;
        }
    }

    @GetMapping(value={"/{orderId}"})
    public ResponseEntity<Pedido> get(@PathVariable Long companyId, @PathVariable Long orderId) throws ApiException {
        Pedido order = this.service.get(companyId, orderId);
        order.setCliente(null);
        return new ResponseEntity((Object)order, HttpStatus.OK);
    }

    @PostMapping(value={"/validar"})
    public ResponseEntity<Boolean> validateOrderRequest(@PathVariable Long companyId, @RequestBody Pedido order) throws ApiException {
        this.service.validateGuestOrderRequest(order);
        this.service.validateGuestDelivery(order);
        if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
            for (CestaDePromocao basket : order.getCestasDePromocao()) {
                this.service.validatePromotion(basket.getPromocao());
            }
        }
        return new ResponseEntity((Object)Boolean.TRUE, HttpStatus.OK);
    }

    @PostMapping
    public ResponseEntity<Long> requestOrder(@PathVariable Long companyId, @RequestBody Pedido order) throws ApiException {
        if (!CollectionUtils.isEmpty((Collection)order.getItensDoPedido())) {
            order.getItensDoPedido().forEach(item -> item.setId(null));
        }
        if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
            order.getCestasDePromocao().forEach(item -> item.setId(null));
        }
        order = this.service.saveOrder(order, companyId, false);
        this.messengerService.sendOrderMessage(order);
        System.gc();
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)order.getId());
    }
}

