/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.CestaDePromocao;
import com.escolpi.omni.api.model.entity.CupomDeDesconto;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.CupomDeDescontoService;
import com.escolpi.omni.api.service.MessengerService;
import com.escolpi.omni.api.service.PedidoService;
import com.escolpi.omni.api.util.NullUtil;
import com.escolpi.omni.api.util.StringUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/cliente/{companyId}/pedidos"})
public class PedidoResource
extends BaseResource {
    @Autowired
    private CupomDeDescontoService discountTicketService;
    @Autowired
    private MessengerService messengerService;
    @Autowired
    private PedidoService orderService;

    @PutMapping(value={"/cancelar"})
    @PreAuthorize(value="hasAuthority('ROLE_PEDIDO_CANCELAR') and #oauth2.hasScope('write')")
    public void cancelOrder(@RequestParam Long orderId, @RequestParam Long userId) throws ApiException, IOException, InterruptedException {
        this.orderService.cancelOrder(orderId, userId);
    }

    @GetMapping(value={"/cliente"})
    @PreAuthorize(value="hasAuthority('ROLE_PEDIDO_LISTAR') and #oauth2.hasScope('read')")
    public Page<Pedido> filterCustomerOrders(@RequestParam String search, @RequestParam Integer pageNumber, @RequestParam List<String> sortBy, @RequestParam String sortDirection, @RequestParam Integer entriesByPage) throws ApiException {
        return this.orderService.filter(search, pageNumber.intValue(), sortBy, sortDirection, entriesByPage, false);
    }

    @GetMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_PEDIDO_OBTER') and #oauth2.hasScope('read')")
    public Pedido get(@PathVariable(value="companyId") Long companyId, @RequestParam Long pedidoId) throws ApiException {
        return this.orderService.get(companyId, pedidoId);
    }

    @GetMapping(value={"/ultimo-pedido"})
    @PreAuthorize(value="hasAuthority('ROLE_PEDIDO_LISTAR') and #oauth2.hasScope('read')")
    public Pedido getLastOrder(@PathVariable Long companyId, @RequestParam Long usuarioId) {
        return this.orderService.getLastCustomerOrder(usuarioId, companyId);
    }

    @GetMapping(value={"/ultimos-pedidos"})
    @PreAuthorize(value="hasAuthority('ROLE_PEDIDO_LISTAR') and #oauth2.hasScope('read')")
    public List<Pedido> getLastOrders(@PathVariable Long companyId, @RequestParam Long usuarioId, @RequestParam Integer periodoEmDias) {
        return this.orderService.getLastOrders(usuarioId, companyId, periodoEmDias);
    }

    @GetMapping(value={"/em-andamento"})
    @PreAuthorize(value="hasAuthority('ROLE_PEDIDO_LISTAR') and #oauth2.hasScope('read')")
    public List<Pedido> listOrderInProgress(@PathVariable Long companyId, @RequestParam Long usuarioId) {
        return this.orderService.getOrderInProgress(usuarioId);
    }

    @GetMapping(value={"/vendedor/{vendorId}"})
    @PreAuthorize(value="hasAuthority('ROLE_PEDIDO_LISTAR') and #oauth2.hasScope('read')")
    public List<Pedido> listLastOrdersByVendor(@PathVariable Long companyId, @PathVariable Long vendorId) {
        return this.orderService.getOrderInProgressByVendor(vendorId);
    }

    @PostMapping(value={"/"})
    @PreAuthorize(value="hasAuthority('ROLE_PEDIDO_CRIAR') and #oauth2.hasScope('write')")
    public void requestOrder(@PathVariable Long companyId, @RequestBody Pedido pedido) throws ApiException, JsonProcessingException {
        if (!CollectionUtils.isEmpty((Collection)pedido.getItensDoPedido())) {
            pedido.getItensDoPedido().forEach(item -> item.setId(null));
        }
        if (!CollectionUtils.isEmpty((Collection)pedido.getCestasDePromocao())) {
            pedido.getCestasDePromocao().forEach(item -> item.setId(null));
        }
        Pedido order = this.orderService.saveOrder(pedido, companyId, false);
        this.messengerService.sendOrderMessage(this.orderService.get(companyId, order.getId()));
        System.gc();
    }

    @PutMapping(value={"/feedback"})
    @PreAuthorize(value="hasAuthority('ROLE_PEDIDO_CRIAR') and #oauth2.hasScope('write')")
    public void sendFeedback(@PathVariable Long companyId, @RequestBody Pedido pedido) throws ApiException {
        this.orderService.saveOrderFeedback(pedido);
    }

    @PutMapping(value={"/util"})
    @PreAuthorize(value="hasAuthority('ROLE_PEDIDO_CRIAR') and #oauth2.hasScope('write')")
    public void sendFeedbackReply(@PathVariable Long companyId, @RequestParam(value="pedidoId") Long pedidoId, @RequestParam(value="util") Boolean util) throws ApiException {
        this.orderService.sendFeedbackResponse(pedidoId, util);
    }

    @PostMapping(value={"/validar"})
    @PreAuthorize(value="hasAuthority('ROLE_PEDIDO_CRIAR') and #oauth2.hasScope('write')")
    public void validateOrderRequest(@PathVariable Long companyId, @RequestBody Pedido order) throws ApiException {
        this.orderService.validateOrderRequest(order);
        if (!CollectionUtils.isEmpty((Collection)order.getCestasDePromocao())) {
            for (CestaDePromocao basket : order.getCestasDePromocao()) {
                this.orderService.validatePromotion(basket.getPromocao());
            }
        }
        CupomDeDesconto cupom = null;
        if (NullUtil.isNotNull((Object)order.getCupomDeDesconto()) && NullUtil.isNotNullOrZero((Number)order.getCupomDeDesconto().getId())) {
            cupom = this.discountTicketService.findById(order.getCupomDeDesconto().getId());
        }
        if (NullUtil.isNotNull(cupom) && StringUtil.isNotBlank((String)order.getCupomDeDesconto().getCodigo())) {
            BigDecimal totalOrderWithoutDiscount = this.orderService.calculateTotalOrderValueWithoutDiscount(order);
            this.orderService.validateDiscountTicketRole(cupom, totalOrderWithoutDiscount);
        }
    }
}

