/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.enumeration.SituacaoDoPedido;
import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.model.projection.PedidoView;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.MessengerService;
import com.escolpi.omni.api.service.PedidoService;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/empresa/pedidos/{empresaId}"})
public class PedidoEmpresaResource
extends BaseResource {
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private MessengerService messengerService;

    @GetMapping(value={"/"})
    public List<Pedido> obterNovosPedidos(@PathVariable Long empresaId) {
        return this.pedidoService.getNewOrders(empresaId);
    }

    @GetMapping(value={"/{pedidoId}"})
    public Pedido obterPedidoPorId(@PathVariable Long empresaId, @PathVariable Long pedidoId) throws ApiException {
        return this.pedidoService.get(empresaId, pedidoId);
    }

    @PostMapping(value={"/por-situacao"})
    public ResponseEntity<List<PedidoView>> obterPedidosPorSituacao(@PathVariable Long empresaId, @RequestBody String situacao) {
        return new ResponseEntity((Object)this.pedidoService.listdOrderViewByStatus(empresaId, SituacaoDoPedido.valueOf((String)situacao)), HttpStatus.OK);
    }

    @GetMapping(value={"/novos"})
    public ResponseEntity<List<PedidoView>> obterPedidosNaoImportados(@PathVariable Long empresaId) {
        return ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)this.pedidoService.listNotImportedOrderView(empresaId));
    }

    @GetMapping(value={"/pedidos-em-aberto"})
    public List<Pedido> obterPedidosMonitorados(@PathVariable Long empresaId) throws ApiException {
        return this.pedidoService.getMonitoredOrders(empresaId);
    }

    @PutMapping(value={"/alterar-situacao"})
    public void updateOrderStatus(@PathVariable Long empresaId, @RequestBody Pedido order) throws ApiException, IOException, InterruptedException {
        if (!(order = this.pedidoService.updateOrderStatus(order)).getSituacao().equals((Object)SituacaoDoPedido.AGUARDANDO_CONFIRMACAO) || !order.getSituacao().equals((Object)SituacaoDoPedido.FINALIZADO)) {
            this.messengerService.sendOrderMessage(order);
        }
    }
}

