/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.resource;

import com.escolpi.omni.api.exception.ApiException;
import com.escolpi.omni.api.model.entity.Personalizacao;
import com.escolpi.omni.api.model.entity.PersonalizacaoDeProduto;
import com.escolpi.omni.api.model.entity.ValorDaPersonalizacao;
import com.escolpi.omni.api.resource.BaseResource;
import com.escolpi.omni.api.service.CatalogoService;
import com.escolpi.omni.api.service.PedidoService;
import com.escolpi.omni.api.service.PersonalizacaoDeProdutoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/carrinho/{companyId}"})
public class CarrinhoResource
extends BaseResource {
    @Autowired
    private CatalogoService service;
    @Autowired
    private PedidoService pedidoService;
    @Autowired
    private PersonalizacaoDeProdutoService customizationProductService;

    @GetMapping(value={"/personalizacoes-categoria"})
    public List<Personalizacao> obterPersonalizacoes(@PathVariable(value="companyId") Long companyId, @RequestParam Long categoriaId) throws ApiException {
        return this.pedidoService.getCustomizations(companyId, categoriaId);
    }

    @Deprecated
    @GetMapping(value={"/personalizacoes-categoria/promocao"})
    public List<Personalizacao> obterPersonalizacoesParaPromocao(@PathVariable(value="companyId") Long companyId, @RequestParam Long categoriaId) throws ApiException {
        return this.service.getCustomizationsForPromotion(companyId, categoriaId);
    }

    @GetMapping(value={"/personalizacoes-produtos/{productId}"})
    public List<PersonalizacaoDeProduto> getCustomizationsProducts(@PathVariable Long productId) throws ApiException {
        return this.customizationProductService.findByProductIdToCatalog(productId);
    }

    @GetMapping(value={"/valores-personalizacoes"})
    public List<ValorDaPersonalizacao> obterValoresPersonalizacoes(@RequestParam Long personalizacaoId) {
        return this.pedidoService.getCustomizationValues(personalizacaoId);
    }

    @GetMapping(value={"/valores-personalizacoes-produtos/{productCustomizationId}"})
    public List<ValorDaPersonalizacao> getProductCustomizationValues(@PathVariable Long productCustomizationId) {
        return this.customizationProductService.findByProductCustomizationIdToCatalog(productCustomizationId);
    }
}

