/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.repository;

import com.escolpi.omni.api.model.entity.TarifacaoDeEntrega;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface TarifacaoDeEntregaRepository
extends JpaRepository<TarifacaoDeEntrega, Long>,
JpaSpecificationExecutor<TarifacaoDeEntrega> {
    public static final String ENTITY_NAME = "Tarifa\u00e7\u00e3o de Entrega";

    public Optional<TarifacaoDeEntrega> findByIdAndEmpresaId(@Param(value="id") Long var1, @Param(value="empresaId") Long var2);

    public List<TarifacaoDeEntrega> findByEmpresaId(@Param(value="empresaId") Long var1);

    public List<TarifacaoDeEntrega> findByEmpresaIdAndMunicipioId(@Param(value="empresaId") Long var1, @Param(value="municipioId") Long var2);

    public Long countByEmpresaIdAndMunicipioIdAndBairroIgnoreCase(@Param(value="empresaId") Long var1, Long var2, @Param(value="bairro") String var3);

    public Long countByIdNotAndMunicipioIdAndEmpresaIdAndBairroIgnoreCase(@Param(value="id") Long var1, @Param(value="municipioId") Long var2, @Param(value="empresaId") Long var3, @Param(value="bairro") String var4);

    @Query(value="FROM TarifacaoDeEntrega te WHERE te.empresa.id = :empresaId AND te.municipio.id = :municipioId AND STRPOS(UNACCENT(:bairro), UNACCENT(te.bairro)) > 0 ORDER BY te.valor DESC")
    public List<TarifacaoDeEntrega> findTarifacaoPorMunicipioEBairro(@Param(value="empresaId") Long var1, @Param(value="municipioId") Long var2, @Param(value="bairro") String var3);

    public TarifacaoDeEntrega findTopByEmpresaIdOrderByIdDesc(@Param(value="empresaId") Long var1);
}

