/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.repository;

import com.escolpi.omni.api.enumeration.FormaDeEntrega;
import com.escolpi.omni.api.enumeration.LojaDeOrigem;
import com.escolpi.omni.api.enumeration.SituacaoDoPedido;
import com.escolpi.omni.api.model.entity.Pedido;
import com.escolpi.omni.api.model.projection.ClienteView;
import com.escolpi.omni.api.model.projection.CupomDeDescontoView;
import com.escolpi.omni.api.model.projection.EnderecoDeEntregaView;
import com.escolpi.omni.api.model.projection.OpcaoDePagamentoComCartaoView;
import com.escolpi.omni.api.model.projection.PedidoView;
import com.escolpi.omni.api.model.projection.ProdutoView;
import com.escolpi.omni.api.model.projection.StatusDoPedidoView;
import com.escolpi.omni.api.model.projection.TotalPedidoView;
import com.escolpi.omni.api.model.projection.TotalView;
import com.escolpi.omni.api.model.projection.UsuarioView;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PedidoRepository
extends JpaRepository<Pedido, Long>,
JpaSpecificationExecutor<Pedido> {
    public static final String ENTITY_NAME = "Pedido";

    public List<Pedido> findByClienteIdOrderByIdDesc(Long var1);

    public List<Pedido> findTop20ByVendedorIdOrderByDataHoraPedidoDesc(Long var1);

    public List<Pedido> findByEmpresaIdOrderByIdAsc(Long var1);

    public List<Pedido> findByEmpresaIdAndMesa(Long var1, String var2);

    @Query(value="FROM Pedido p WHERE p.empresa.id = :companyId AND p.mesa = :table AND p.nomeClienteMesa IN(:customers)")
    public List<Pedido> findByEmpresaIdAndMesaAndCustomers(Long var1, String var2, List<String> var3);

    public Pedido findByIdExterno(String var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.ClienteView(p.cliente.id, p.cliente.nome, p.cliente.telefone) FROM Pedido p WHERE p.id = ?1")
    public Optional<ClienteView> findCustomerByOrderId(Long var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.OpcaoDePagamentoComCartaoView(p.opcaoPagamentoCartao.id, p.opcaoPagamentoCartao.descricao, p.opcaoPagamentoCartao.funcao, p.opcaoPagamentoCartao.exclusivoDoVendedor, p.opcaoPagamentoCartao.temDetalhes, p.opcaoPagamentoCartao.descontoAplicado) FROM Pedido p WHERE p.id = ?1")
    public Optional<OpcaoDePagamentoComCartaoView> findCardOptionPaymentByOrderId(Long var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.EnderecoDeEntregaView(p.enderecoEntrega.id, p.enderecoEntrega.logradouro, p.enderecoEntrega.numero, p.enderecoEntrega.complemento, p.enderecoEntrega.cep, p.enderecoEntrega.pontoDeReferencia, p.enderecoEntrega.descricao, p.enderecoEntrega.bairro) FROM Pedido p WHERE p.id = ?1")
    public Optional<EnderecoDeEntregaView> findDeliveryAddressByOrderId(Long var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.CupomDeDescontoView(p.cupomDeDesconto.id, p.cupomDeDesconto.codigo, p.cupomDeDesconto.tipoDesconto, p.cupomDeDesconto.valorDesconto,p.cupomDeDesconto.tipoRegra, p.cupomDeDesconto.valorRegraCupom, p.cupomDeDesconto.tipoUtilizacao) FROM Pedido p WHERE p.id = ?1")
    public Optional<CupomDeDescontoView> findDiscountTicketByOrderId(Long var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.ProdutoView(p.produtoDeRodizio.id, p.produtoDeRodizio.codigoAtos, p.produtoDeRodizio.nome, p.produtoDeRodizio.descricao, p.produtoDeRodizio.valor,p.produtoDeRodizio.valorTamanhoBroto, p.produtoDeRodizio.valorTamanhoMedio, p.produtoDeRodizio.valorTamanhoGrande,p.produtoDeRodizio.valorTamanhoGigante, p.produtoDeRodizio.valorMeioRodizio, p.produtoDeRodizio.valorAtacado) FROM Pedido p WHERE p.id = ?1")
    public Optional<ProdutoView> findProductByOrder(Long var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.UsuarioView(p.vendedor.id, p.vendedor.nome, p.vendedor.login) FROM Pedido p WHERE p.id = ?1")
    public Optional<UsuarioView> findSallerByOrderId(Long var1);

    @Query(value="SELECT p.id FROM Pedido p WHERE p.empresa.id = :companyId AND p.situacao IN (:status) AND DATE(p.dataAtualizacaoPedido) >= CURRENT_DATE AND p.rodizio IS FALSE AND p.formaEntrega <> 2 ORDER BY p.id DESC")
    public List<Long> findNewOrdersIds(@Param(value="companyId") Long var1, @Param(value="status") List<SituacaoDoPedido> var2);

    public Pedido findTopByClienteIdAndEmpresaIdOrderByIdDesc(Long var1, Long var2);

    @Query(nativeQuery=true, value="SELECT p.situacao FROM pedidos p WHERE p.cliente_id = ?1 ORDER BY id DESC LIMIT 1")
    public Optional<Integer> getLastOrderStatusByCustomer(Long var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.StatusDoPedidoView(p.id, p.formaEntrega , p.situacao,p.classificacao, p.respostaFeedback, p.feedbackUtil, p.clienteSemCadastro) FROM Pedido p WHERE p.id = ?1")
    public Optional<StatusDoPedidoView> getOrderState(Long var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.StatusDoPedidoView(p.id, p.formaEntrega , p.situacao,p.classificacao, p.respostaFeedback, p.feedbackUtil, p.clienteSemCadastro) FROM Pedido p WHERE p.cliente.id = ?1 ORDER BY p.id DESC")
    public Optional<StatusDoPedidoView> getOrderStateByCustomer(Long var1);

    @Query(value="SELECT p.situacao FROM Pedido p WHERE p.id = ?1")
    public Optional<Integer> getOrderStatusByOrder(Long var1);

    @Query(value="FROM Pedido p WHERE p.cliente.id = :clienteId AND DATE(p.dataAtualizacaoPedido) = CURRENT_DATE ORDER BY p.id DESC")
    public List<Pedido> findLastCustomersOrderFromDay(@Param(value="clienteId") Long var1);

    @Query(value="FROM Pedido p WHERE p.empresa.id = :companyId AND p.mesa = :table AND p.situacao != 5 AND DATE(p.dataAtualizacaoPedido) = CURRENT_DATE AND p.rodizio IS FALSE ORDER BY p.id DESC")
    public List<Pedido> findLastCustomerOrderByTableFromDay(@Param(value="companyId") Long var1, @Param(value="table") String var2);

    @Query(value="SELECT p FROM Pedido p WHERE p.cliente.id = :clienteId AND p.empresa.id = :empresaId AND p.situacao = :situacao AND DATE(p.dataHoraPedido) BETWEEN :diasDeDiferenca AND CURRENT_DATE ORDER BY p.dataHoraPedido DESC")
    public List<Pedido> findUltimosPedidosRealizados(@Param(value="clienteId") Long var1, @Param(value="empresaId") Long var2, @Param(value="situacao") SituacaoDoPedido var3, @Param(value="diasDeDiferenca") Date var4);

    @Query(value="FROM Pedido p WHERE p.situacao IN (:situacoes) ORDER BY p.empresa.id")
    public List<Pedido> findOrdersBySituacoes(@Param(value="situacoes") List<SituacaoDoPedido> var1);

    @Query(value="FROM Pedido p WHERE p.situacao NOT IN (:status) AND p.empresa.ativo IS TRUE")
    public List<Pedido> findOrdersBySituacoesNotIn(@Param(value="status") List<SituacaoDoPedido> var1);

    public Long countByEnderecoEntregaId(@Param(value="enderecoEntregaId") Long var1);

    @Query(value="SELECT COUNT(p) FROM Pedido p WHERE p.empresa.id = :companyId AND p.situacao IN (0,1) AND DATE(p.dataHoraPedido) = DATE(CURRENT_DATE)")
    public Long countCompanyNewOrders(@Param(value="companyId") Long var1);

    @Query(value="SELECT COUNT(p) FROM Pedido p WHERE p.cliente.id = :clienteId AND DATE(p.dataAtualizacaoPedido) <= DATE(:diasDeDiferenca) AND p.situacao IN (:situacoes)")
    public Long countEncerradosOuCanceladosNosUltimos90Dias(@Param(value="clienteId") Long var1, @Param(value="diasDeDiferenca") Date var2, SituacaoDoPedido ... var3);

    @Query(value="FROM Pedido p WHERE p.cliente.id = :clienteId AND DATE(p.dataAtualizacaoPedido) <= DATE(:diasDeDiferenca) AND p.situacao IN (:situacoes) ORDER BY p.dataAtualizacaoPedido ASC")
    public List<Pedido> findEncerradosOuCanceladosNosUltimos90Dias(@Param(value="clienteId") Long var1, @Param(value="diasDeDiferenca") Date var2, Pageable var3, SituacaoDoPedido ... var4);

    public Optional<Pedido> findTopByEmpresaIdOrderByIdDesc(@Param(value="empresaId") Long var1);

    @Query(value="FROM Pedido p WHERE p.empresa.id = :companyId AND p.teste IS FALSE AND p.situacao = :status AND p.dataAtualizacaoPedido BETWEEN :initialDate AND :finalDate ")
    public List<Pedido> findCompanyOrdersByStatusOnPeriod(@Param(value="companyId") Long var1, @Param(value="status") SituacaoDoPedido var2, @Param(value="initialDate") Date var3, @Param(value="finalDate") Date var4);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.PedidoView(p.id, p.taxaDeEntrega, p.valorDescontoPagamentoEmDinheiro,p.dataHoraPedido, p.formaEntrega, p.formaPagamento, p.valorTroco,p.cpfCnpjNota, p.mesa, p.situacao, p.dataAtualizacaoPedido, p.feedback,p.classificacao, p.sugestaoMelhoria, p.origem, p.respostaFeedback,p.feedbackUtil, p.dataHoraAgendamento, p.totalDoPedido, p.nomeClienteMesa,p.teste, p.parcelas, p.valorDaParcela, p.lojaDeOrigem, p.idExterno,p.nomeClienteExterno, p.enderecoEntregaExterno, p.telefoneClienteExterno,p.dataHoraCancelamento, p.creditoCashback,p.debitoCashback, p.rodizio, p.qtdeRodizioCompleto,p.qtdeMeioRodizio, p.valorRodizioCompleto, p.valorMeioRodizio,p.rodizioFechado, p.detalheDoPagamento, p.observacoes, p.comFrete,p.nomeDaEmpresaDoFrete, p.urlDoLogoDaEmpresaDoFrete, p.nomeDoServicoDoFrete,p.valorDeDescontoDoFrete, p.estimativaDeEntrega, p.taxaDeComissao,p.taxaAdicional, p.pedidoExcedente, p.descontoExterno, p.clienteSemCadastro,p.nomeClienteSemCadastro, p.telefoneClienteSemCadastro,p.enderecoDeEntregaClienteSemCadastro,p.importado) FROM Pedido p WHERE p.empresa.id = :companyId AND p.teste IS FALSE AND p.situacao = :status AND p.dataAtualizacaoPedido BETWEEN :initialDate AND :finalDate ")
    public List<PedidoView> findCompanyOrdersViewByStatusOnPeriod(@Param(value="companyId") Long var1, @Param(value="status") SituacaoDoPedido var2, @Param(value="initialDate") Date var3, @Param(value="finalDate") Date var4);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.PedidoView(p.id, p.taxaDeEntrega, p.valorDescontoPagamentoEmDinheiro,p.dataHoraPedido, p.formaEntrega, p.formaPagamento, p.valorTroco,p.cpfCnpjNota, p.mesa, p.situacao, p.dataAtualizacaoPedido, p.feedback,p.classificacao, p.sugestaoMelhoria, p.origem, p.respostaFeedback,p.feedbackUtil, p.dataHoraAgendamento, p.totalDoPedido, p.nomeClienteMesa,p.teste, p.parcelas, p.valorDaParcela, p.lojaDeOrigem, p.idExterno,p.nomeClienteExterno, p.enderecoEntregaExterno, p.telefoneClienteExterno,p.dataHoraCancelamento, p.creditoCashback,p.debitoCashback, p.rodizio, p.qtdeRodizioCompleto,p.qtdeMeioRodizio, p.valorRodizioCompleto, p.valorMeioRodizio,p.rodizioFechado, p.detalheDoPagamento, p.observacoes, p.comFrete,p.nomeDaEmpresaDoFrete, p.urlDoLogoDaEmpresaDoFrete, p.nomeDoServicoDoFrete,p.valorDeDescontoDoFrete, p.estimativaDeEntrega, p.taxaDeComissao,p.taxaAdicional, p.pedidoExcedente, p.descontoExterno, p.clienteSemCadastro,p.nomeClienteSemCadastro, p.telefoneClienteSemCadastro,p.enderecoDeEntregaClienteSemCadastro,p.importado) FROM Pedido p WHERE p.empresa.id = :companyId AND p.teste IS FALSE AND p.dataAtualizacaoPedido BETWEEN :initialDate AND :finalDate AND p.importado IS FALSE AND p.situacao IN (1,2)")
    public List<PedidoView> findCompanyNotImportedOrdersViewOnPeriod(@Param(value="companyId") Long var1, @Param(value="initialDate") Date var2, @Param(value="finalDate") Date var3);

    public List<Pedido> findByEmpresaIdAndTotalDoPedidoIsNull(@Param(value="empresaId") Long var1);

    @Query(value="FROM Pedido p WHERE p.empresa.id = :empresaId AND DATE(p.dataHoraPedido) > DATE(:dataInicio) AND DATE(p.dataHoraPedido) <= DATE(:dataFim)")
    public List<Pedido> findByDataPedidoAndEmpresaId(@Param(value="empresaId") Long var1, @Param(value="dataInicio") Date var2, @Param(value="dataFim") Date var3);

    @Query(value="SELECT DISTINCT(SUBSTRING(dthr_pedido\\:\\:TEXT, 1, 7)) as anoMes FROM pedidos WHERE empresa_id = :empresaId ORDER BY anoMes DESC", nativeQuery=true)
    public List<String> findDistinctMonths(@Param(value="empresaId") Long var1);

    @Query(value="SELECT c.descricao, SUM(ip.quantidade) AS qtd FROM itens_pedidos ip INNER JOIN pedidos p ON ip.pedido_id = p.id INNER JOIN produtos pr ON pr.id = ip.produto_id INNER JOIN categorias_produtos c ON c.id = pr.categoria_id WHERE p.empresa_id = :empresaId AND DATE(p.dthr_pedido) BETWEEN DATE(:dataInicio) AND DATE(:dataFim) AND p.situacao <> 6 AND p.ind_teste IS FALSE AND c.ind_composicao_produtos IS FALSE GROUP BY c.id ORDER BY qtd DESC LIMIT 10", nativeQuery=true)
    public List<Object> findTop10Categories(@Param(value="empresaId") Long var1, @Param(value="dataInicio") Date var2, @Param(value="dataFim") Date var3);

    @Query(value="SELECT c.descricao, SUM(ip.quantidade) AS qtd FROM itens_pedidos ip INNER JOIN pedidos p ON ip.pedido_id = p.id INNER JOIN produtos_compostos pc ON pc.id = ip.produto_composto_id INNER JOIN produtos pr ON pc.produtos_ids LIKE concat('%', pr.id, '%') INNER JOIN categorias_produtos c ON c.id = pr.categoria_id WHERE p.empresa_id = :empresaId AND DATE(p.dthr_pedido) BETWEEN DATE(:dataInicio) AND DATE(:dataFim) AND p.situacao <> 6 AND p.ind_teste IS FALSE AND c.ind_composicao_produtos IS TRUE GROUP BY c.id ORDER BY qtd DESC LIMIT 10", nativeQuery=true)
    public List<Object> findTop10CategoriesByComposition(@Param(value="empresaId") Long var1, @Param(value="dataInicio") Date var2, @Param(value="dataFim") Date var3);

    @Query(value="SELECT c.nome AS nome, COUNT(p.id) AS quantidade, SUM(p.total_pedido) AS soma FROM pedidos p INNER JOIN clientes c ON p.cliente_id = c.id WHERE p.empresa_id = :companyId AND DATE(p.dthr_pedido) BETWEEN DATE(:initialDate) AND DATE(:finalDate) AND p.situacao <> 6 AND p.ind_teste IS FALSE GROUP BY c.id ORDER BY soma DESC LIMIT 10", nativeQuery=true)
    public List<Object> findTop10Customers(@Param(value="companyId") Long var1, @Param(value="initialDate") Date var2, @Param(value="finalDate") Date var3);

    @Query(value="SELECT e.bairro, COUNT(p.id) AS quantidade, SUM(p.taxa_de_entrega) AS soma FROM pedidos p INNER JOIN enderecos_entrega e ON p.endereco_entrega_id = e.id WHERE empresa_id = :empresaId AND DATE(p.dthr_pedido) > DATE(:dataInicio) AND DATE(p.dthr_pedido) <= DATE(:dataFim) AND p.taxa_de_entrega IS NOT NULL AND p.ind_teste IS FALSE GROUP BY e.bairro ORDER BY soma DESC LIMIT 10", nativeQuery=true)
    public List<Object> findTop10Neighborhoods(@Param(value="empresaId") Long var1, @Param(value="dataInicio") Date var2, @Param(value="dataFim") Date var3);

    @Query(value="SELECT p.nome, COALESCE(COUNT(ip.id) + (select count_promotion_sales_by_product(p.id, p.empresa_id, :dataInicio, :dataFim)), COUNT(ip.id)) AS qtd, COALESCE(SUM(ip.valor) + (select sum_promotion_sales_by_product(p.id, p.empresa_id, :dataInicio, :dataFim)), SUM(ip.valor)) AS soma FROM itens_pedidos ip INNER JOIN produtos p ON ip.produto_id = p.id INNER JOIN pedidos pd ON ip.pedido_id = pd.id WHERE pd.empresa_id = :empresaId AND DATE(pd.dthr_pedido) BETWEEN DATE(:dataInicio) AND DATE(:dataFim) AND ip.valor IS NOT NULL AND pd.ind_teste IS FALSE GROUP BY p.id ORDER BY soma DESC LIMIT 10", nativeQuery=true)
    public List<Object> findTop10Products(@Param(value="empresaId") Long var1, @Param(value="dataInicio") Date var2, @Param(value="dataFim") Date var3);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.PedidoView(p.id, p.taxaDeEntrega, p.valorDescontoPagamentoEmDinheiro,p.dataHoraPedido, p.formaEntrega, p.formaPagamento, p.valorTroco,p.cpfCnpjNota, p.mesa, p.situacao, p.dataAtualizacaoPedido, p.feedback,p.classificacao, p.sugestaoMelhoria, p.origem, p.respostaFeedback,p.feedbackUtil, p.dataHoraAgendamento, p.totalDoPedido, p.nomeClienteMesa,p.teste, p.parcelas, p.valorDaParcela, p.lojaDeOrigem, p.idExterno,p.nomeClienteExterno, p.enderecoEntregaExterno, p.telefoneClienteExterno,p.dataHoraCancelamento, p.creditoCashback,p.debitoCashback, p.rodizio, p.qtdeRodizioCompleto,p.qtdeMeioRodizio, p.valorRodizioCompleto, p.valorMeioRodizio,p.rodizioFechado, p.detalheDoPagamento, p.observacoes, p.comFrete,p.nomeDaEmpresaDoFrete, p.urlDoLogoDaEmpresaDoFrete, p.nomeDoServicoDoFrete,p.valorDeDescontoDoFrete, p.estimativaDeEntrega, p.taxaDeComissao,p.taxaAdicional, p.pedidoExcedente, p.descontoExterno, p.clienteSemCadastro,p.nomeClienteSemCadastro, p.telefoneClienteSemCadastro,p.enderecoDeEntregaClienteSemCadastro,p.importado) FROM Pedido p WHERE p.id = ?1")
    public Optional<PedidoView> findViewById(Long var1);

    @Query(value="FROM Pedido p WHERE p.empresa.id = :companyId AND p.mesa = :table AND p.situacao NOT IN (5,6)")
    public List<Pedido> findOrdersToFinalize(@Param(value="companyId") Long var1, @Param(value="table") String var2);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.TotalView(SUM(p.totalDoPedido), COUNT(id)) FROM Pedido p WHERE p.empresa.id = :empresaId AND DATE(p.dataHoraPedido) > DATE(:dataInicio) AND DATE(p.dataHoraPedido) <= DATE(:dataFim) AND p.teste IS FALSE AND p.lojaDeOrigem = :lojaDeOrigem")
    public List<TotalView> findOrdersValueByDate(@Param(value="empresaId") Long var1, @Param(value="dataInicio") Date var2, @Param(value="dataFim") Date var3, @Param(value="lojaDeOrigem") LojaDeOrigem var4);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.TotalView(SUM(p.totalDoPedido), COUNT(id)) FROM Pedido p WHERE p.empresa.id = :empresaId AND DATE(p.dataHoraPedido) > DATE(:dataInicio) AND DATE(p.dataHoraPedido) <= DATE(:dataFim) AND p.formaEntrega = :formaDeEntrega AND p.teste IS FALSE")
    public List<TotalView> findOrdersValueByDateAndDeliveryWay(@Param(value="empresaId") Long var1, @Param(value="dataInicio") Date var2, @Param(value="dataFim") Date var3, @Param(value="formaDeEntrega") FormaDeEntrega var4);

    @Query(value="SELECT SUM(p.totalDoPedido), COUNT(id) FROM Pedido p WHERE p.empresa.id = :empresaId AND DATE(p.dataHoraPedido) > DATE(:dataInicio) AND DATE(p.dataHoraPedido) <= DATE(:dataFim) AND p.situacao = :situacao AND p.teste IS FALSE")
    public List<Object> findOrdersValueByDateAndSituation(@Param(value="empresaId") Long var1, @Param(value="dataInicio") Date var2, @Param(value="dataFim") Date var3, @Param(value="situacao") SituacaoDoPedido var4);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.TotalView(SUM(p.totalDoPedido), COUNT(id)) FROM Pedido p WHERE p.empresa.id = :empresaId AND DATE(p.dataHoraPedido) > DATE(:initialDate) AND DATE(p.dataHoraPedido) <= DATE(:finalDate) AND p.situacao IN(:status) AND p.teste IS FALSE")
    public List<TotalView> findOrdersValueByDateAndStatus(@Param(value="empresaId") Long var1, @Param(value="initialDate") Date var2, @Param(value="finalDate") Date var3, @Param(value="status") List<SituacaoDoPedido> var4);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.TotalPedidoView(p.dataHoraPedido, p.totalDoPedido) FROM Pedido p WHERE p.empresa.id = :empresaId AND DATE(dthr_pedido) > DATE(:dataInicio) AND DATE(dthr_pedido) <= DATE(:dataFim) AND p.situacao <> 6 AND p.teste IS FALSE")
    public List<TotalPedidoView> findOrdersByDayInMonth(@Param(value="empresaId") Long var1, @Param(value="dataInicio") Date var2, @Param(value="dataFim") Date var3);

    @Query(value="SELECT COUNT(p) FROM Pedido p WHERE p.empresa.id = :companyId AND DATE(p.dataHoraPedido) > DATE(:firstDayInMonth) AND p.situacao >= 1 AND p.situacao <> 6 AND p.teste IS FALSE")
    public int countOrdersInCurrentMonthByCompanyId(@Param(value="companyId") Long var1, @Param(value="firstDayInMonth") Date var2);

    @Modifying
    @Query(value="UPDATE Pedido p SET p.importado = TRUE WHERE p.id = ?1")
    public void setImported(Long var1);

    @Modifying
    @Query(value="UPDATE Pedido p SET p.situacao = :status, p.dataAtualizacaoPedido = :updateDate, p.importado = :imported WHERE p.id = :id")
    public void updateOrderStatus(@Param(value="status") SituacaoDoPedido var1, @Param(value="updateDate") Date var2, @Param(value="imported") Boolean var3, @Param(value="id") Long var4);
}

