/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.repository;

import com.escolpi.omni.api.model.entity.ItemDoPedido;
import com.escolpi.omni.api.model.projection.ItemDoPedidoView;
import com.escolpi.omni.api.model.projection.OpcionalDoItemDoPedidoView;
import com.escolpi.omni.api.model.projection.ProdutoCompostoView;
import com.escolpi.omni.api.model.projection.ProdutoView;
import com.escolpi.omni.api.model.projection.ValorDaPersonalizacaoView;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ItemDoPedidoRepository
extends JpaRepository<ItemDoPedido, Long> {
    public static final String ENTITY_NAME = "Item do Pedido";

    public Set<ItemDoPedido> findByPedidoId(@Param(value="pedidoId") Long var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.ItemDoPedidoView(ip.id, ip.quantidade, ip.observacoes, ip.valor) FROM ItemDoPedido ip WHERE ip.pedido.id = ?1")
    public Set<ItemDoPedidoView> findViewByOrderId(Long var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.ProdutoCompostoView(ip.produtoComposto.id, ip.produtoComposto.produtosIds, ip.produtoComposto.tamanho, ip.produtoComposto.valor) FROM ItemDoPedido ip WHERE ip.id = ?1")
    public Optional<ProdutoCompostoView> findComposedProductByItemId(Long var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.ProdutoView(ip.produto.id, ip.produto.codigoAtos, ip.produto.nome, ip.produto.descricao, ip.produto.valor,ip.produto.valorTamanhoBroto, ip.produto.valorTamanhoMedio, ip.produto.valorTamanhoGrande,ip.produto.valorTamanhoGigante, ip.produto.valorMeioRodizio, ip.produto.valorAtacado) FROM ItemDoPedido ip WHERE ip.id = ?1")
    public Optional<ProdutoView> findProductByItemId(Long var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.OpcionalDoItemDoPedidoView(o.id, o.quantidade) FROM ItemDoPedido ip INNER JOIN ip.opcionais o WHERE ip.id = ?1")
    public Set<OpcionalDoItemDoPedidoView> findItemOptionals(Long var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.ValorDaPersonalizacaoView(vp.id, vp.descricao) FROM ItemDoPedido ip INNER JOIN ip.valoresDasPersonalizacoes vp WHERE ip.id = ?1")
    public Set<ValorDaPersonalizacaoView> findItemCustomizationValues(Long var1);
}

