/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.repository;

import com.escolpi.omni.api.enumeration.ControleEstoque;
import com.escolpi.omni.api.enumeration.FusoHorario;
import com.escolpi.omni.api.model.entity.Empresa;
import com.escolpi.omni.api.model.entity.Usuario;
import com.escolpi.omni.api.model.projection.AutocompleteView;
import com.escolpi.omni.api.model.projection.EmpresaView;
import com.escolpi.omni.api.model.projection.StatusDaLojaView;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface EmpresaRepository
extends JpaRepository<Empresa, Long> {
    public static final String ENTITY_NAME = "Empresa";

    public Long countByTelefonePrincipal(String var1);

    @Modifying
    @Query(value="DELETE FROM Empresa e WHERE e.id = :id")
    public void deleteCompany(@Param(value="id") Long var1);

    @Query(value="SELECT e.aceitaPedidosAuto FROM Empresa e WHERE e.id = ?1")
    public Optional<Boolean> getCompanyReceivesAutoOrdersConfig(Long var1);

    @Query(value="SELECT e.controleEstoque FROM Empresa e WHERE e.id = ?1")
    public Optional<ControleEstoque> getCompanyStockControl(Long var1);

    @Query(value="SELECT e.fusoHorario FROM Empresa e WHERE e.id = ?1")
    public Optional<FusoHorario> getTimeZone(Long var1);

    public Optional<Empresa> findByCnpj(String var1);

    @Query(value="SELECT e.ativo FROM Empresa e WHERE e.id = ?1")
    public Optional<Boolean> getCompanyActivationStatus(Long var1);

    @Query(value="SELECT e.aberto FROM Empresa e WHERE e.id = ?1")
    public Optional<Boolean> getCompanyOpeningStatus(Long var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.StatusDaLojaView(e.tempoDeEntrega, e.tempoDeRetirada, e.aberto) FROM Empresa e WHERE e.id = :companyId")
    public Optional<StatusDaLojaView> getStoreOpeningStatus(@Param(value="companyId") Long var1);

    @Query(value="SELECT e.usuario.id FROM Empresa e WHERE e.id = ?1")
    public Optional<Long> getCompanyUserId(Long var1);

    public Optional<Empresa> findByFcmTokenServidor(String var1);

    @Query(value="FROM Empresa e WHERE e.usuario.login = :login")
    public Optional<Empresa> findByLogin(@Param(value="login") String var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.EmpresaView(e.id, e.nomeFantasia, e.aberto, e.ativo) FROM Empresa e WHERE e.usuario.login = ?1")
    public Optional<EmpresaView> getByLogin(String var1);

    @Query(value="SELECT e.usuario FROM Empresa e WHERE e.id = ?1")
    public Optional<Usuario> getUserByCompany(Long var1);

    public List<Empresa> findByIdStoreAndIdNot(String var1, Long var2);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.EmpresaView(e.id, e.idStore, e.nomeFantasia, e.nomeAbreviado, e.ativo,e.aberto, e.cep, e.logradouro, e.numero, e.bairro, e.complemento,e.municipio, e.controleEstoque, e.descontoPagamentoEmDinheiro, e.emTeste,e.fazDelivery, e.fazRetirada, e.logotipo, e.fusoHorario, e.logotipoStore,e.latitude, e.longitude, e.maximoDeParcelas, e.parcelaMinima, e.planoDeFundoStore, e.segmento, e.telefonePrincipal, e.telefoneSecundario, e.tempoDeEntrega, e.tempoDeRetirada, e.tokenFcm, e.urlAppAndroid, e.urlAppIos, e.urlFacebook, e.urlInstagram, e.valorDescontoPagamentoEmDinheiro, e.valorIsencaoEntrega, e.valorTarifaUnica, e.valorPedidoExcedente, e.porcentagemDoCashback) FROM Empresa e WHERE e.idStore = ?1")
    public Optional<EmpresaView> findByIdStore(String var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.AutocompleteView(e.nomeFantasia, e.id) FROM Empresa e WHERE UNACCENT(e.nomeFantasia) LIKE CONCAT('%', UNACCENT(:term), '%') ORDER BY e.nomeFantasia")
    public List<AutocompleteView> findByAutocomplete(@Param(value="term") String var1);

    public List<Empresa> findByMatrizOrderByAbertoDesc(Empresa var1);

    @Query(value="FROM Empresa e WHERE e.telefonePrincipal = :telefone")
    public Optional<Empresa> findByTelefone(@Param(value="telefone") String var1);

    public Optional<Empresa> findByUsuarioId(Long var1);

    @Query(value="SELECT new com.escolpi.omni.api.model.projection.EmpresaView(e.id, e.nomeFantasia, e.aberto) FROM Empresa e WHERE e.id = ?1")
    public Optional<EmpresaView> findToClose(Long var1);

    @Modifying
    @Query(value="UPDATE Empresa e SET e.aberto = :opening WHERE e.id = :id")
    public void changeOpeningState(@Param(value="id") Long var1, @Param(value="opening") boolean var2);
}

