/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.specification;

import com.escolpi.omni.api.domain.SearchCriteria;
import com.escolpi.omni.api.model.entity.Promocao;
import com.escolpi.omni.api.util.DateUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class PromocaoSpecification
implements Specification<Promocao> {
    private static final long serialVersionUID = -4419402331645392016L;
    private SearchCriteria criteria;

    public PromocaoSpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    public Predicate toPredicate(Root<Promocao> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        if (this.criteria.getKey().equals("empresaId")) {
            return builder.equal((Expression)root.get("empresa").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("excluida")) {
            return builder.equal((Expression)root.get("excluida"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("dtInicioValidade")) {
            return builder.greaterThanOrEqualTo((Expression)root.get("dtInicioValidade"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        if (this.criteria.getKey().equals("dtFimValidade")) {
            return builder.lessThanOrEqualTo((Expression)root.get("dtFimValidade"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        if (this.criteria.getKey().equals("disponibilidades")) {
            return builder.like((Expression)root.get("disponibilidades"), "%" + this.criteria.getValue().toString() + "%");
        }
        if (this.criteria.getKey().equals("aceitaCupomDeDesconto")) {
            return builder.equal((Expression)root.get("aceitaCupomDeDesconto"), this.criteria.getValue());
        }
        if (this.criteria.getOperation().equalsIgnoreCase(":")) {
            if (root.get(this.criteria.getKey()).getJavaType() == String.class) {
                return builder.like(builder.function("unaccent", String.class, new Expression[]{root.get(this.criteria.getKey())}), "%" + this.criteria.getValue().toString().toUpperCase() + "%");
            }
            return builder.equal((Expression)root.get(this.criteria.getKey()), this.criteria.getValue());
        }
        return null;
    }
}

