/*
 * Decompiled with CFR 0.152.
 */
package com.escolpi.omni.api.model.specification;

import com.escolpi.omni.api.domain.SearchCriteria;
import com.escolpi.omni.api.enumeration.ProvedorDePagamento;
import com.escolpi.omni.api.model.entity.LogDePagamento;
import com.escolpi.omni.api.util.DateUtil;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class LogDePagamentoSpecification
implements Specification<LogDePagamento> {
    private static final long serialVersionUID = -566859526039441687L;
    private SearchCriteria criteria;

    public LogDePagamentoSpecification(SearchCriteria criteria) {
        this.criteria = criteria;
    }

    public Predicate toPredicate(Root<LogDePagamento> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        if (this.criteria.getKey().equals("empresaId")) {
            return builder.equal((Expression)root.get("empresa").get("id"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("nomeCliente")) {
            return builder.like(builder.function("unaccent", String.class, new Expression[]{builder.upper((Expression)root.get("cliente").get("nome"))}), "%" + this.criteria.getValue().toString().toUpperCase() + "%");
        }
        if (this.criteria.getKey().equals("provedorDePagamento")) {
            return builder.equal((Expression)root.get("provedorDePagamento"), (Object)ProvedorDePagamento.valueOf((String)this.criteria.getValue().toString()));
        }
        if (this.criteria.getKey().equals("statusDaTransacao")) {
            return builder.equal((Expression)root.get("statusDaTransacao"), this.criteria.getValue());
        }
        if (this.criteria.getKey().equals("dataHoraTransacaoInicio")) {
            return builder.greaterThanOrEqualTo((Expression)root.get("dataHoraDaTransacao"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        if (this.criteria.getKey().equals("dataHoraTransacaoFim")) {
            return builder.lessThanOrEqualTo((Expression)root.get("dataHoraDaTransacao"), (Comparable)DateUtil.parseMillisecondsToDate((long)new Long(this.criteria.getValue().toString())));
        }
        return null;
    }
}

